/* RENLOGS.CMD -- Backup (rename) several of SRE-Filter's & GoServe'e log files.
    This program is designed to be called by SRE-Filter's "scheduled program"
    facility (as described in SREFLOGS.DOC).

To use this program, you should set the following variables.

  i) The LOGFILES. stem variable.
       The LOGFILES. stem variable(s) should contain "log file names"
        you want to backup, and a "renaming pattern".   These "log file name"
       should match the names specified in SREFLOGS.INI.
       The "renaming pattern" is used to create a target file.

  ii) VERBOSE
         Set to 1 to report errors. Set to 2 to report all results. Set to 0 to suppress reporting.

Examples:

  *  LOGFILES.1='D:\GOSERVE\DATA\COMMON.LOG D:\GOSERVE\OLDLOGS\$Y$M$D_C.LOG'
  *  LOGFILES.2='D:\GOSERVE\DATA\REFERER.LOG D:\GOSERVE\OLDLOGS\$D$H??.REF '
  *  LOGFILES.3='D:\GOSERVE\DATA\COMMON2.LOG D:\GOSERVE\OLDLOGS\$Y$M$D_D.LOG'
  *  LOGFILES.0=3

**  Note that you MUST set LOGFILES.0 to be equal to the number of LOGFILES. stem variables
     specified.

Specifying "renaming patterns":

  Each log file mentioned (in LOGFILES.) will be copied to the file
  named by the "renaming pattern".  This "renaming pattern" will have a few strings replacement
  done to it, with the resulting name used as the target file.
  In particular, the following "strings" will be replaced in the "renaming pattern" .
    $Y  = The current 2 digit year
    $M  = The current 2 digit monty
    $D  = The current 2 digit day
    $H  = The current 2 digit hour
    ?   = A random value picked to assure a unique file name.
  All other character (strings) are used as is.
 
  Examples; assuming the time is 2:00 PM on 22 March 1997 --
   *  D:\GOSERVE\OLDLOGS\$Y$M$D_D.LOG' becomes D:\GOSERVE\OLDLOGS\970322_D.LOG
 
   * D:\GOSERVE\OLDLOGS\$D$H??.REF  (might) become D:\GOSERVE\OLDLOGS\220201.REF
         (The ?? would yield 02 if 220201.REF already existed).
 
Notes:
  * The files will be copied and then deleted. Thus, the target (the renaming pattern)
    can be on a different drive.
  * See SREFLOGS.INI for more details on selection of common, browser, and referer
    log files.
  * See SREFLOGS.INI for a discussion of how to use the SCHED. parameters to
     create scheduled backups (you should coordinate your SCHED. parameters and
     your "renaming patterns".

*/

/* BEGIN USER CHANGABLE CODE ................................................... */

logfiles.0=0

verbose=1


/* END USER CHANGABLE CODE ..................................................... */
/* END USER CHANGABLE CODE ..................................................... */
/* END USER CHANGABLE CODE ..................................................... */

rename_logs:
if verbose>1 then call pmprintf_sref(' Archiving SRE-Filter Log files. ....')

if symbol('LOGFILES.0')<>'VAR' then logfiles.0=0

hh=time('h')
if hh<10 then hh="0"||hh

addd=date('o')

parse var addd yy '/' mm '/' dd .
yy=strip(yy); mm=strip(mm); dd=strip(dd); hh=strip(hh)
if length(yy)<2 then yy="0"||yy
if length(mm)<2 then mm="0"||mm
if length(dd)<2 then dd="0"||dd
do imm=1 to logfiles.0
   parse var logfiles.imm asource atarget1
   atarget=fix_name(atarget1)
  
  foo=doscopy(strip(asource),strip(atarget),'R')
  if foo<>0 then do
      call pmprintf_sref(' REXXLIB DOSCOPY error (' foo ') copying log file ' asource ' to  ' atarget1)
  end  /* Do */
  else do
     foo=sysfiledelete(asource)
     if verbose>1 then call pmprintf_sref(asource ' moved to ' atarget)
  end  /* Do */
end

return 0

/************/
fix_name:procedure expose hh mm dd yy
parse upper arg aname
new1=sref_replacestrg(aname,'$Y',yy,'ALL')

new1=replacestrg(new1,'$M',mm,'ALL')
new1=replacestrg(new1,'$D',dd,'ALL')
new1=replacestrg(new1,'$H',hh,'ALL')
if pos('?',new1)>0 then new1=dostempname(new1)
return new1


replacestrg:

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end
 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring




