/* DOPUT -- send a file to a HTTP server, using the PUT verb */
/* Call as:  DOPUT serveraddress url_to_use filename                   */
/* ------------------------------------------------------------------- */
/* This program requires that the RxSock.DLL be in your LIBPATH (it is */
/* usually in your \TCPIP\DLL directory.  It was shipped with the      */
/* August 1994 CSD for the TCP/IP base (UN64092).                      */

call load /* load functions if necessary */

say " Program to transfer files to HTTP server using the PUT verb "

parse arg server  use_url afile

if server="" then do 
   say " Reminder: the HTTP server must support the PUT verb "
   say "  (you may also require special access privileges) "

    say " Please enter server address: "
    parse pull server
end  /* Do */
if use_url="" then  do
  say " Please enter url to use (on " server "): "
  parse pull use_url
end
if afile="" then do
     say " Please enter the file you want to transfer: "
     parse pull afile
     foo=stream(afile,'c','query exists')
     if foo="" then  do
         say " Error: file does not exist "
        exit
     end
end

crlf    ='0d0a'x                        /* constants */
family  ='AF_INET'
httpport=80

rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
if rc=0 then do; say 'Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")


message='PUT ' use_url ' HTTP/1.0'crlf
message=message||'Content-type:application/x-www-form-urlencoded'||crlf

lt1=chars(afile)
t1=charin(afile,1,lt1)
message=message||'Content-length:'||lt1||crlf

message=message||crlf||t1
say " Starting transfer of  " lt1 " byte file  ... "

got=''
rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say 'Unable to connect to "'server'"'; exit; end
rc = SockSend(gosock, message)
say " bytes transfered = " rc " .. waiting for reply .... "

/* Now wait for the response */
do r=1 by 1
  rc = SockRecv(gosock, "response", 1000)
  got=got||response
  /* say '>'rc'/>' response */
  if rc<=0 then leave
  end r
rc = SockClose(gosock)

say 'Got' length(got) 'bytes of response:'
say  got
exit

/* --- Load the function library, if necessary --- */
load:
if \RxFuncQuery("SockLoadFuncs") then return      /* already there */
call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
call SockLoadFuncs
return
