; Support file for SRE-FILTER HTTP server. 5/97
; This file is used to store SEL-specific access information.
;
; SRE-FILTER will attempt to (exact or wildcard) match the 
; request selector with one of these entries.
;
; Each entry should be a space delimited list containing:
;  HOST_NICKNAME// NAME  RESOURCE_PRIVS , PERMISSIONS_LIST , SEL_REALM , FAIL_FILE , ADV_OPTIONS_FILE
;
; HOST_NICKNAME//)  Optional.
;     Used to identify "host specific" entries.  If a host_nickname is present,
;     then the entry is only used with requests to hosts having this host_Nickname.
;
; NAME) Required.
;   The NAME  should be a possible request selector
;       (to be compared against the request selector sent by the clien)
;       It may indicate a file, or a server side action.
;       It may contain (several) * (wildcard) character(s).
;
;       Definition of "request selector:"
;           The "request selector" is the non-domain part of the URL the
;           client selected.
;           For example, a URL of
;                 http://your.server/big/dance/price.htm
;           would generate a request string of
;                 GET  /big/dance/price.htm  HTTP/1.0
;           and the selector would be
;                big/dance/price.htm
;
; RESOURCE_PRIVS) Optional.
;      The RESOURCE_PRIVS  should be a (space delimited) list.
;      It can contain 2 forms of privileges:
;          ONE_OF -- the client has to have "one of" these ONE_OF privileges
;          MUST_HAVE -- the client "must have" all of the MUST_HAVE privileges
;      To specify a MUST_HAVE privilege, add a & character at the beginning.
;      Otherwise, it is assumed to be a ONE_OF privilege
;                 (in other words, ONE_OF is the default form)
;.
;      For example, the list:
;           SALMON &TROUT HALIBUT
;      means that the client must have a TROUT privilege, as well as
;      either a SALMON or HALIBUT privilege (note that the TROUT privilege
;      is necessary but NOT sufficient!)
;
;      There are a few special "ONE_OF" privileges: *  YES and NO
;          YES and * mean "allow everyone in" (given MUST_HAVE privs are ok)
;          NO means "only superusers"
;
;     Notes:
;
;       *   If there are no ONE_OF conditions, it is assumed that the
;           "ONE_OF conditions are automatically satisfied" (the same can be
;           said if there  are no MUST_HAVE conditions).
;       *   If a SEL_REALM is specified, and a realm-specific resource 
;           privilege list exists for this REALM, then it will be
;           is appended to this RESOURCE_PRIVS list (see below for details).
;       *   If the combination of this RESOURCE_PRIVS list, and a "realm-specific
;           resource privileges" list is empty (that is, neither is specified),
;           then access IS allowed.
;       *   If the ADD_RESOURCE_NAME='YES', then the "action" portion of the request
;           selector is added to the resource privilege list.
;       *   Caution: when including entries of the form:
;                   SECRETS/*  ADMIN1
;            and NODIR_EXT='DIR', then a request generated by
;                  http://foo.bar.net/secrets
;            will NOT match the SECRETS/* .. entry.
;       *   See ADDPRIVS.DOC for a discussion of how client's are granted 
;           privileges.
;
; PERMISSIONS_LIST) Optional.
;   The PERMISSIONS_LIST is optional (there MUST be comma seperating the
;       RESOURCE_PRIV and the PERMISSIONS_LIST)
;
;   Each of these permissions apply to <em>just this selector </em> (or, if
;   you used an *, to just this  set of selectors)
;     NO_SSI  : Suppress server side includes.
;     NO_SSP  : Suppress server side processing.
;     NO_CODE : Suppress SELECT and INTERPRET CODE ssi-keyphrases.
;           NO_CODE is a subset of NO_SSP (that is, if NO_SSP is present,
;           then NO_CODE is irrelevant)
;     CACHE :  ALWAYS cache this selector (assuming GoServe's caching is enabled).
;           Typically, if logon controls or access controls are in place, then
;           caching is disabled.  Use of CACHE allows one to override this
;           general rule for.
;      PUT :  Allow PUT method requests to "copy information to" the directory
;           represented by this selector (also used by GET_URL and PUT_FILE
;           facilities)
;    DELETE :  Allow DELETE method request to "delete" the file represented by
;           this selector.
;    NO_HTACCESS: Suppress the HTACCESS method.
;    NO_ALIAS   : Suppress SRE-Filter "aliasing."
;    NO_VIRTUAL : Suppress virtual directory lookup.
;    NO_POSTFILTER: Suppress post-filter processing (such as common-log auditing,
;               and augmentation of the SRE-Filter RECORD_ALL file).
;
;   The last three (NO_VIRTUAL, NO_ALIAS, and NO_POSTFILTER) are meant
;   to be used to avoid unnecessary processing.  Note that, NO_VIRTUAL
;   is ignored by CGI-BIN scripts and SRE-Filter addons (use the virtual
;   dircectory's limitation_lists instead).
;
; REALM) Optional.
;   The REALM is optional (there must be a comma between the REALM and the
;   PERMISSIONS_LIST).  The REALM is displayed as a SEL-specific realm
;   whenever SRE-Filter needs to "re prompt" the client for a 
;   new username/password (as when the user's first username/password
;   did not contain sufficient privileges to access the selector).
;
;   If you've set the REALM_1ST_PRIV parameter (in SREFILTR.80)
;   then the first resource privilege is used as the realm name
;   when no sel-specific REALM is specified). Otherwise, the THE_REALM
;   variable (set in INITFILT.80) is used
;
;   In addition, special !REALM entries in this file can be used to specify
;   shorthands a "realm specific resource privileges list" (see below).
;
;
; FAIL_FILE) Optional.
;    The FAIL_FILE  (sometimes refered to as the ACCESS_FAILURE_FILE)
;    is optional (there must be a comma between the FAIL_FILE
;    and the REALM). If the client does not have SEL-specific access
;    privileges, then the FAIL_FILE is used as a "response file".  Basically,
;    the FAIL_FILE "overrides" the ACCESS_FAIL_FILE parameter.
;    Note that the FAIL_FILE should be one of:
;              -1: If no access, do NOT ask for authorization. Useful when
;                  combined with "dynamic privileges"
;     0 or blank :  use generic access_fail_file (or send an authorization response)
;   filename.ext :  a fully qualified file name.
;
;  Actually, the ACCESS_FAIL_FILE can suppress use of this FAIL_FILE -- see
;  initfilt.doc for details.
;
; ADV_OPTS_FILE) Optional.
;  The ADV_OPTS_FILE is optional -- if you do specify it, you must 
;  precede it with a comma (to seperate it from the FAIL_FILE)
;  SRE-Filter allows you to specify several "advanced options", including:
;     * customization of the response header,
;     * execution of a rexx program before sending a file (sort of
;       "mid-filter" hook),
;     * suppression of SSI features (such as headers and footers) --
;     * sel specific mime type
;  all on a request-selector-specific basis.  
;  To do this, you must use the ADV_OPTS_FILE parameter to specify a 
;  special "advanced options file". 
;  The ADV_OPTS_FILE should be a relative file name, though it may point to a
;  subdirectory (it will be interpreted relative to the the GoServe working
;  directory).  For more details, see ADV_OPTS.DOC
;
;                        ---------------------------
; NOTES:
;
; Special Entries: additional, REALM-specific, resource privileges
;
;     Each realm can have associated with it a list of "realm specific 
;     resource privileges".  If available, this (space delimited)
;     list is added to the selectors own RESOURCE_PRIVS list.
;     The syntax of these special entries is:
;           !REALM  realm_name  realm_privilege_list
;     Typically, this is used to specify a common set of privileges available
;     to all selectors in a given REALM (it saves having to enter these
;     resource privileges for each selector in the realm).
;     See below for some examples of realm-specific resource privilege_lists.
;
;     NOTE: Currently, these !realm entires are NOT host specific!
;          (Hint: To minimize confusion...
;                Use the host nickname as part of the realm_name)
;
; Match precedence and wildcarding:
;   Entries are checked using a "multiple wildcard" algorithim.
;   (the multiple wildcard feature is new to version 1.2j).

;   If several entries can match the selector...
;     1) Exact matches always take precedence
;     2) The wildcard match that has the most "early character" matches wins
;     Thus, if your selector is FOOD/FRUIT/ORANGES.HTM
;     then the order (with first being chosen before last) is:
;               FOOD/FRUIT/ORANGES.HTM  (the exact match)
;               FOOD/FRUIT/*HTM
;               FOOD/FRUIT/*
;               FOOD/*IT/*HTM
;               FOOD/*.HTM          
;               FOOD*
;     (these entries can appear in any order in this file, with no
;      effect on precedence). For further discussion, see SREFILTR.FAQ
;
;     Some wildcard examples:
;                  /BILL/DOG.HTM will match /BILL/DOG.HTM
;                  /JOE/*  will match /JOE/FOO.HTM
;                  /JOAN/SRCH.HTM?*  will match /JOAN/SRCH.HTM?search+me
;                  /JOAN/SRCH.HTM?*  will NOT match /JOAN/SRCH.HTM
;                       (/JOAN/SRCH.HTM* will match BOTH these examples)
;                  /PETS/*FOOD/*INDEX.HTM will match
;                       /PETS/FOOD/INDEX.HTM, /PETS/CAT/FOOD/INDEX.HTM and
;                       /PETS/PUPPY/FOOD/LAB/INDEX.HTM
;                    but will NOT match
;                       /PETS/CAT/PUREBRED.HTM and /PETS/FOOD/HELLO.HTM
;
;  / and \ :  They are treated the same (all / are converted to \)
;                       A Leading \ (or /) is stripped.
;
;                        - - - - - - - -
; EXAMPLES:
;
; Only superusers have access to the SYSTEM subdirectory
;SYSTEM\*   NO
; only inhouse and superusers have access to the PRIVATE directory
;PRIVATE\*  INHOUSE
; everyone has access to the PUBLIC\ directory, but documents in the
; public directory can not contain SELECT or INTERPRET CODE keyphrases.
;PUBLIC\*  * , NO_CODE
;
; Requests, to the host with nickname SWEETSHOP, for selectors that match  RECORDS/*,
; requires INHOUSE privileges
; SWEETSHOP//  RECORDS/*  INHOUSE , , ADMIN_REALM
;
; The client has to have "one of" VENUS,MARS, or MERCURY privlieges,
; and "must have" an EARTH privilege, to access the PLANETS/INNER directory.
; If the client does not have these privilegs, D:\WWW\NOPLANET.HTm
; is returned (given that ACCESS_FAIL_FILE<>0.
; PLANETS/INNER/*  MERCURY VENUS &EARTH MARS , , , d:\www\NOPLANET.HTM
;
; Allow uploads and deletes in the Uploads directory 
; UPLOADS/* * , DELETE PUT 
;
; this wildcards all requests for getafile.  Add a privilege list if you 
; want to limit it's use 
;GETAFILE*
;
; These wildcard the  message box facilitiy.
; Add a privilege list if desired ..
;MESSAGE*
;!ASKMESS*
;
; This controls access to the SECRET2 message box
;!VIEWMESS?messbox=secret2*  INHOUSE
; all other message boxes are open to everyone with VIEWMESS privileges.
;!VIEWMESS* VIEWMESSAGES
;
; This gives selectors pointing to the GUEST subdirectory (or virtual directory)
;  a limited purview 
;GUEST/*  * , NO_SSI NO_SSP , GUEST_REALM
;
; This will use the NEW.CTL "advanced options file" with all selectors
; that point to NEWSTUFF (and below). Note that there are no permissions
; specified, and no FAIL_FILE.
;NEWSTUFF/*  * , , EXPERIMENTAL , , NEW.CTL
;
; allow caching of GIF files in (or under) the IMG directory; and don't bother
; checking aliases or the virtual directories, and don't do postfilter stuff
;IMGS/*.GIF * , CACHE NO_ALIAS NO_VIRTUAL NO_POSTFILTER
;
;This gives access to a clients with a privilege of MARTIANS, IONIANS
;  or one of the privileges in the "additional resource privilege" list
; associated with the SPACMEN realm (see below), access to files
; in the STELLAR directory
;STELLAR/* MARTIANS IONIANS ,  , SPACEMEN
;
;
; and this last one means "for all other files, everyone has access" 
; (it's a catchall) -- change the second * to whatever privilege list 
; you want (i.e.; NO, to disallow all access)
;/* *
;  ---------------------- Some !REALM examples
; Note that !REALM entries can appear in any order or location in this file,
; but there should only be one entry per realm_name.
;
; In this example, all selectors with entries that have SEL-specific 
;  REALM of "REALM1" will have BIGFOOT and SASQUATCH added to 
;  their (possibly empty) RESOURCE_PRIV list.
; That is, the client will be allowed access  (to selectors with
; SEL-specfic realm of REALM1) if they have a privilege
; of BIGFOOT or SASQUATCH (or one the entries in the RESOURCE_PRIV
; list).
;!REALM  REALM1  BIGFOOT  SASQUATCH
;
; Note that the SPACEMEN realm has "additional resource
; privileges" of: VULCANS KLINGONS and FERENGI
;!REALM  SPACEMEN  VULCANS KLINGONS FERENGI
;
; and the SPACEMEN2 realm requires a FEDERATION privileges as well
; as "one of" the VULCANS KLINGONS or FERENGI
;!REALM SPACEMEN2 VULCANCS KLINGONS FERENGI &FEDERATION
;
; (summary: host// sel privs , permiss , realm , failfile , advoptfile
; --------- End of examples
IMGS/*.GIF * , CACHE NO_ALIAS NO_VIRTUAL NO_POSTFILTER
/* *

