/*  */
htaccfg:

CHECKIT=0   /* Change this to 0 if you want to enable REMOTE configuration by SUPERUSERS */

/* background color */
USECOLOR='2dd52f'

/* ---------------- DO NOT MODIFY BELOW THIS LINE  ------------------ */



parse arg ddir,tempfile,sel,list,verb,uri,user,basedir,workdir,privset, ,
               enmadd,transaction,verbose, ,
              servername,host_nickname,homedir

if verb=" " then do
    say " This SRE-Filter procedure is NOT meant to be run from the command line."
   exit
end  /* Do */

list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */
/* write results (2nd call */
if pos('WRITETO=',translate(list))>0 then do
   call writeres
  return ' Results written '
end


who2=extract('CLIENTADDR')
saddr2=extract('SERVERADDR')

NO_REM=VALUE('SREF_NO_REMOTE_CONFIG',,'OS2ENVIRONMENT')

select
   when checkit=1 | no_rem>0 then do

/* only if user = serveraddress !!! */
     if who2<>saddr2 | no_rem=2 then do

        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>SRE-FILTER  remote configurator disabled </title>"
        call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '


        call lineout tempfile,' <strong> Action not allowed remotely.</strong> <pre>'
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
        'FILE ERASE TYPE text/html NAME' tempfile
        return 'HTACCFG: action not allowed remotely. '
     end
   end
   otherwise do
      if wordpos('SUPERUSER',privset)=0 then do
        'RESPONSE HTTP/1.0 401 Unauthorized '     /* Set HTTP response line */
        'header add WWW-Authenticate: Basic Realm=<CONFIGURE>'  /* challenge */

        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>Not authorized </title>"
        call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '

        call lineout tempfile,' <strong> You do not have configuration rights.</strong> <pre>'
        if who2=saddr2 then 
                call lineout tempfile,'<br> <Em> You may want to edit HTACCFG.CMD </em> '
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
         iia=dosdir(tempfile,'s')

        'FILE ERASE TYPE text/html NAME' tempfile
        return '401 'iia' HTACCFG: not permitted to configure. '
      end
   end
end


htfile=' ' ;htacc=' '
list=strip(list)
DO UNTIL LIST=""
    PARSE VAR  list a1 '&' list
    parse var a1 avar '=' aval
    if translate(avar)='HTFILE' then do
         htfile=strip(translate(translate(packur(aval),'\','/')))
         htfile=strip(htfile,'t','\')||'\'
    end
    if translate(avar)='ACCFILE' then
         htacc=strip(translate(translate(packur(aval),'\','/')))
end /* do */
if left(htfile,1)='\' | pos(':',htfile)>0 then
   nop
else 
   htfile=translate(ddir||htfile,'\','/')

if htacc=' ' then
   htacc=get_value('htaccess_file')

if filespec('p',htfile)='\' then do
   call lineout tempfile,' <h2> ' HTFILE ' not permitted </h2> '
  call lineout tempfile,' Sorry, HTACCESS file can <strong>not</strong> be in the root'
  call lineout tempfile, '</body> </html> '
  call lineout tempfile
  'file erase  type text/html name  ' tempfile
  return 'htaccess not allowed in root '
end
if htfile=' '| htacc=' ' then do
   call lineout tempfile,' <h2> Missing information </h2> '
  call lineout tempfile,' Sorry, the directory, or the name for the HTACCESS file,'
  call lineout tempfile,' was not specified.'
  call lineout tempfile, '</body> </html> '
  call lineout tempfile
  'file erase  type text/html name  ' tempfile
  return ' missing information '
end /* do */


HTFILE=STRIP(HTFILE); HTFILE=STRIP(HTFILE,'T','\')||'\'
tmp1=get_htaccess(0,HTfile,HTACC,ddir,TEMPFILE,2)

parse var tmp1 gotlist ',' tmp1
gotlist=strip(gotlist)

this1=htfile||htacc
is1=stream(this1,'c','query exists')

vlist='GOTLIST AUTH.NAME AUTH.TYPE AUTH.USERFILE AUTH.GROUPFILE '
vlist=vlist||'AUTH.INDEX REDIRECTFILE AUTH.LIMIT DIR.BUILD DIR.EXCLUDE '
vlist=vlist||'DIR.INFO  DIR.DESCRIBE DIR.FORBID RX.BUILDdir RX.ENABLEPOSTPROCESS'

vlist2=' x AuthName AuthType AuthUserFile AuthGroupFile DefaultIndex RedirFile '
vlist2=vlist2||' Limit BuildDir Dir.Exclude Dir.Info Dir.Describe Dir.Forbid '
vlist2=vlist2||' Dir.Builder EnablePostProcess '
gotlist0=gotlist

call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
call lineout tempfile, "<html><head><title>SRE-Filter HTACCESS configurator </title>"
call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '

call lineout tempfile, "<h1> SRE-Filter: <A NAME="top"> HTACCESS Configurator </A>   </h1> <p>"
call lineout tempfile,' <a href="#review"> Review current parameters &amp; files for ' htfile '</a> ?'


this1a=strip(this1,'t','.')
foo=wordpos(translate(this1a),translate(gotlist))
if foo>0 then do
    gotlist=delword(gotlist,foo,1)
end  /* Do */

call lineout tempfile,' <h2> For directory== ' translate(htfile) ' </h2>'
call lineout tempfile,' <ul> '
if is1=' ' then
  call lineout tempfile,' <li> Currently, there is <strong> no</strong> HTACCESS file in: ' htfile
else
  call lineout tempfile,' <li> The HTACCESS file for ' htfile ' is: <strong> ' this1 '</strong>'


if gotlist<>' ' then
  call lineout tempfile,' <li> The set of HTACCESS files in the parent directories are: <strong> ' gotlist '</strong>'

call lineout tempfile,' </ul>'


/* get "this files" parameter values (if accessible ) */
if is1 =' ' then do
   call lineout tempfile,' <hr width=30%> <h3> Creating: ' this1 ' </h3>  '
/* initialize some variable */
   auth.name=' '; auth.type=' ' ; auth.userfile=' ' ; auth.groupfile=' '
   auth.index=' '; redirectfile=' '; auth.limit=' '; dir.exclude=' ';
   dir.info=' ' ; dir.describe=' ' ; dir.forbid=' ' ; rx.builddir=' '
end
else do
   tmp1=get_htaccess(0,HTfile,HTACC,ddir,TEMPFILE,3)

   do mm=1 to words(vlist)
     parse var tmp1 aval ',' tmp1
     avar=word(vlist,mm) ; aval=strip(aval)
     call value avar,aval
  end /* do */
  call lineout tempfile,' <hr width=30%>  <h3> Modifying: ' this1 ' </h3>  '
end

/* let user fill out form */
CALL LINEOUT TEMPFILE,'<FORM ACTION="/HTACCFG" METHOD="POST">'
call lineout tempfile,'<h3> Access control parameters </h3>'

ee=makeit('<b>One line comment:</b>','COMMENT',gotlist0,' ')
call lineout tempfile,ee


ee=makeit(' <p> <b>AuthName</b>: Authorization name (the REALM) ','AuthName',gotlist0,auth.name,10)
call lineout tempfile,ee


ischeck1=' ' ;IF translate(auth.type)='BASIC' then ischeck1='CHECKED'
ischeck2=' ';IF translate(auth.type)='IDENT' then ischeck2='CHECKED'
call lineout tempfile,' <p><b>AuthType</b>: Authorization type: '
CALL LINEOUT TEMPFILE,' <INPUT TYPE=RADIO NAME="AuthType" VALUE="BASIC"' ISCHECK1 ' >BASIC ||'
CALL LINEOUT TEMPFILE,'<INPUT TYPE=RADIO NAME="AuthType" VALUE="IDENT"' ISCHECK2 ' >IDENT '

ee=makeit('<b>AuthUserfile</b>: Userfile (contains usernames and passwords) ','AuthUserFile',gotlist0,auth.userfile)
call lineout tempfile,ee

ee=makeit('<b>AuthGroupfile</b>: Group file (groups of users) ','AuthGroupFile',gotlist0,auth.groupfile)
call lineout tempfile,ee


if wordpos('REQUIRE',translate(auth.limit))=1 then
   auth.limit=delword(auth.limit,1,1)
ee=makeit('<b>Limit</b>:Allowed users list','Limit',gotlist0,auth.limit)
call lineout tempfile,ee

call lineout tempfile, ' <p> <h3> Redirection, etc. parameters </h3>'

ee=makeit('<b>DefaultIndex</b>: Directory specific default documents ','DefaultIndex',gotlist0,auth.index)
call lineout tempfile,ee

ee=makeit('<b>ReDirFile</b>: Redirection file ','ReDirFile',gotlist0,REDIRECTFILE)
call lineout tempfile,ee


call lineout tempfile,' <p><h3>Parameters used by dynamic directory list processor </h3>'

ischeck1=' ' ;IF dir.build=1 then ischeck1='CHECKED'
ischeck2=' ';IF  dir.build=0 then ischeck2='CHECKED'
call lineout tempfile,' <p> <B>BuildDir</b>:Enable dynamic directory list processor: '
CALL LINEOUT TEMPFILE,' <INPUT TYPE=RADIO NAME="Builddir" VALUE="1"' ISCHECK1 ' >YES (allow) || '
CALL LINEOUT TEMPFILE,'<INPUT TYPE=RADIO NAME="Builddir" VALUE="0"' ISCHECK2 ' >NO  (do not allow)'

ee=makeit('<b>Dir.Exclude</b>:Exclusion files (these files are not displayed) ', ,
          'Dir.Exclude',gotlist0,dir.exclude)
call lineout tempfile,ee
ischeck1=' ' ;IF _diris=1 then ischeck1='CHECKED'
ischeck0=' ';IF  _diris=0 then ischeck0='CHECKED'
call lineout tempfile,' <br><blockquote> Reset list of exclusion files  '
CALL LINEOUT TEMPFILE,'<menu> <li> <INPUT TYPE=RADIO NAME="_diris" VALUE="1" 'ischeck1' > YES (use _Dir.Exclude) '
CALL LINEOUT TEMPFILE,'<li> <INPUT TYPE=RADIO NAME="_diris" VALUE="0" 'ischeck0'> NO  (use Dir.Exclude) </menu> </blockquote>'



ee=makeit('<b>Dir.Info</b>: Directory Info file (displayed at top of document) ', ,
          'Dir.Info',gotlist0,dir.info)
call lineout tempfile,ee


ee=makeit('<b>Dir.Describe</b>:File description file (per entry descriptions) ', ,
          'Dir.Describe',gotlist0,dir.describe)
call lineout tempfile,ee

ee=makeit('<b>Dir.Builder:</b> Name of dynamic directory list processor ', ,
          'Dir.Builder',gotlist0,rx.builddir)
call lineout tempfile,ee

ischeck1=' ' ;IF dir.forbid=1 then ischeck1='CHECKED'
ischeck2=' ';IF  dir.forbid=0 then ischeck2='CHECKED'
call lineout tempfile,' <p><b>Dir.Forbid</b>: Prevent directory list processor from displaying directory: <menu>'
CALL LINEOUT TEMPFILE,' <li> <INPUT TYPE=RADIO NAME="Dir.Forbid" VALUE="1"' ISCHECK1 ' >YES (do NOT allow display) '
CALL LINEOUT TEMPFILE,'<li> <INPUT TYPE=RADIO NAME="Dir.Forbid" VALUE="0"' ISCHECK2 ' >NO  (allow display) </menu>'

ischeck=' '; if rx.enablepostprocess=' ' then ischeck='CHECKED'
ischeck0=' ' ;IF rx.enablepostprocess=0 then ischeck0='CHECKED'
ischeck1=' ' ;IF rx.enablepostprocess=1 then ischeck1='CHECKED'
ischeck2=' ' ;IF rx.enablepostprocess=2 then ischeck2='CHECKED'
call lineout tempfile,'<br> <b>EnablePostProcessor</b>: Post processing option: <menu>'
CALL LINEOUT TEMPFILE,' <li><INPUT TYPE=RADIO NAME="EnablePostProcess" VALUE="0"' ISCHECK0 ' >Disable Post Processing ' 
CALL LINEOUT TEMPFILE,' <li><INPUT TYPE=RADIO NAME="EnablePostProcess" VALUE=" "' ISCHECK ' >Enable for all files'
CALL LINEOUT TEMPFILE,' <li><INPUT TYPE=RADIO NAME="EnablePostProcess" VALUE="1"' ISCHECK1 ' >Enable for all files .*HTM* extensions'
CALL LINEOUT TEMPFILE,' <li><INPUT TYPE=RADIO NAME="EnablePostProcess" VALUE="2"' ISCHECK2 ' >Enable for ".SHTML" files only'

call lineout tempfile,'</menu>'


call lineout tempfile,' <p>  <INPUT TYPE="reset" VALUE="reset"> <br>'

if is1=' ' then
   call lineout tempfile,'  <INPUT TYPE="submit" VALUE="Create 'this1'"> '
else do
   call lineout tempfile,'<INPUT TYPE="submit" VALUE="Modify 'this1'"> '
  call lineout tempfile,' <br> <Em> --- Caution: the old copy of ' this1 ' will be deleted! </em> '
end


call lineout tempfile,'<INPUT TYPE="hidden" name="WRITETO" VALUE="'this1'">'
CALL LINEOUT TEMPFILE,'</FORM>'


/* ------ TIPS AND HINTS SETCION */

call lineout tempfile,' <hr> <P> <HR> <a name="review"> <h3> Review: Parameters and Files </h3> </a>'

call lineout tempfile," Some notes on SRE-Filter's use of HTACCESS files "
call lineout tempfile,'<br> For the most part, SRE-Filter emulates GOHTTP. '
call lineout tempfile,' The following lists some potential differences: '
call lineout tempfile,' <ul> <li> BASIC authorization uses only the "uppermost" HTACCESS file (rather then all of them)'
call lineout tempfile,'<li> EnablePostProcess is ignored for non-file transfers (that is, it is ignored when server side processing are recieved)'
call lineout tempfile,' <li>Dir.Builder works -- we recommend the "SHOWDIR" variant (see SHOWDIR.DOC for details) '
call lineout tempfile,'<li>To invoke the Dir.Builder "dynamic directory list processsor", put !SHOWDIR at the end of the DefaultIndex list '
call lineout tempfile,' <li> IDENT is a bit flaky (it works reasonably well if you * the portion before the @ )'
call lineout tempfile,'</ul>'
/* parameters from own and parent htaccess files */
         tmp1=get_htaccess(0,HTfile,HTACC,ddir,TEMPFILE,2)

do mm=1 to words(vlist)
   parse var tmp1 aval ',' tmp1
   avar=word(vlist,mm) ; aval=strip(aval)
   call value avar,aval
end /* do */
call lineout tempfile,' <hr width=30%> <h3> Effective parameters values for ' htfile ' </h3>  '
call lineout tempfile,' These may include parameters set by HTACCESS files in parent directories <br>'
if gotlist0=' ' then do
   call lineout tempfile,' <BLOCKQUOTE> <strong> No HTACCESS parameters! </strong> </BLOCKQUOTE>'
end  /* Do */
else do
  call lineout tempfile,'<dl>'
  do mm=2 to words(vlist)  /* dont show gotlist */
     avar=word(vlist,mm) ; avar2=word(vlist2,mm)
     aval=value(avar)
     call lineout tempfile,' <dt> <var> ' avar2 ' </var> <dd> ' aval
  end /* do */
  call lineout tempfile,'</dl> '
end

/* ----- USER FILE */
call lineout tempfile,' <HR WIDTH=30%> <H3> User file </h3>'
call lineout tempfile,' Username/password file should have entries with the following syntax:<br>'
call lineout tempfile,' <blockquote> USERNAME:PASSWORD </blockquote>'
call lineout tempfile,' For example: <menu> <li> John:final1 <li> Sam:invidious <li> ; comment <li> wonder:womack </menu>'
call lineout tempfile,' <h3> User file for: ' htfile' </h3>'
if  auth.userfile=' ' then do
 call lineout tempfile,' <blockquote><strong> No user file selected </strong> </blockquote>'
end
else do
   call lineout tempfile,' Current user file is: <strong> ' auth.userfile '</strong> <p> '
   foo=get_lines(auth.userfile)

   if foo>0  then do
      call lineout tempfile,' Contents of ' auth.userfile ' <code> <ul>'

      do mm=1 to foo
         alin=strip(somelines.mm)
         if alin=' ' then iterate
         if abbrev(alin,';')=1 then
                call lineout tempfile, '<li> <em>'alin ' </em> '
         else
                call lineout tempfile, '<li> 'alin  
      end /* do */
      call lineout tempfile,'</ul>  </code>'
    end
    else do
        call lineout tempfile,' <blockquote>  File does not exist: <strong> 'auth.userfile '</strong> </blockquote>'
    end
end  /* Do */


/* ----- groups FILE */
call lineout tempfile,' <HR WIDTH=30%> <H3> Groups file </h3>'
call lineout tempfile,' The user Groups file should have entries with the following syntax:<br>'
call lineout tempfile,' <blockquote> GROUPNAME: user1 user2 use33r@xx.yy.zz </blockquote>'
call lineout tempfile,' For example: <menu> '
call lineout tempfile,' <li> Detroit: phil george '
call lineout tempfile,' <li> Boston:  joe *@dept1.school.edu '
call lineout tempfile,' <em>  ... (note the use of the <strong>IDENT</strong> style name, and the * wildcard)</em>'
call lineout tempfile,' <li> ; comment <li> Miami:  Cheryl Ruby Carlos </menu>'
call lineout tempfile,' <h3> Groups file for: ' htfile ' </h3>'
if  auth.groupfile=' ' then do
 call lineout tempfile,' <blockquote><strong> No group file selected </strong> </blockquote>'
end
else do
   call lineout tempfile,' Current group file is: <strong> ' auth.groupfile '</strong> <p> '
   foo=get_lines(auth.groupfile)

   if foo>0  then do
      call lineout tempfile,' Contents of ' auth.groupfile ' <code> <ul>'

      do mm=1 to foo
         alin=strip(somelines.mm)
         if alin=' ' then iterate
         if abbrev(alin,';')=1 then
                call lineout tempfile, '<li> <em>'alin ' </em> '
         else
                call lineout tempfile, '<li> 'alin  
      end /* do */
      call lineout tempfile,'</ul>  </code>'
    end
    else do
        call lineout tempfile,' <blockquote>  File does not exist: <strong> 'auth.groupfile '</strong> </blockquote>'
    end
end  /* Do */

/* ----- redirectFILE */
call lineout tempfile,' <HR WIDTH=30%> <H3> Redirection file </h3>'
call lineout tempfile,' The Redirection file should have entries with the following syntax:<br>'
call lineout tempfile,' <blockquote> old_url  : new_url  NOTIFY </blockquote>'
call lineout tempfile, 'Where NOTIFY is optional (if present, redirection will NOT occur; instead, the client recieves a short notification) <p> '
call lineout tempfile,' For example: <menu> '
call lineout tempfile,' <li> zoo/sched.htm : http://www.newzoo.org/index.htm '
call lineout tempfile,' <li> store/toys/*:  http://toys.newstore.com/inventory/*  NOTIFY '
call lineout tempfile,' <em> ... (note the use of the * wildcard) </em> '
call lineout tempfile,' <li> !CASE SENSITIVE  <em> ... (following entries are case sensitive) </em> '
call lineout tempfile,' <li> candy/VANILLA.HTM :  /icecream/vanilla.htm  <EM> ... ( no http:// in the new_url implies redirect to same site) </em> '
call lineout tempfile,'</menu> '
call lineout tempfile,' <h3> Redirection file  for: ' htfile '</h3>'
if  redirectfile=' ' then do
 call lineout tempfile,' <blockquote><strong> No redirection file selected </strong> </blockquote>'
end
else do
   call lineout tempfile,' Current  redirection file is: <strong> ' redirectfile '</strong> <p> '
   foo=get_lines(redirectfile)

   if foo>0  then do
      call lineout tempfile,' Contents of ' redirectfile ' <code> <ul>'

      do mm=1 to foo
         alin=strip(somelines.mm)
         if alin=' ' then iterate
         if abbrev(alin,'!')=1 then
                call lineout tempfile, '<li> <em>'alin ' </em> '
         else
                call lineout tempfile, '<li> 'alin  
      end /* do */
      call lineout tempfile,'</ul>  </code>'
    end
    else do
        call lineout tempfile,' <blockquote>  File does not exist: <strong> 'redirectfile '</strong> </blockquote>'
    end
end  /* Do */




call lineout tempfile,' </body> </html> '
call lineout tempfile

'file erase  type text/html name  ' tempfile

return 'Changes made, now submitting '


/* do mm=1 to words(vlist)
   parse var tmp1 aval ',' tmp1
   avar=word(vlist,mm) ; aval=strip(aval) ; avar2=word(vlist2,mm)
   if mm=1 then iterate 
   call lineout tempfile,' <dt> <var> ' avar2 ' </var> <dd> ' aval
end
call lineout tempfile,' </dl> <p> '
*/


makeit:procedure
parse arg message,avar,gotlist0,aval,nshow
if nshow=' 'then nshow=28
if gotlist0=' ' then 
  t1=' ' 
else 
  t1=aval
rr=' <p> '|| message|| ':'
rr=rr||' <INPUT TYPE="text" NAME="'||avar||'"  VALUE="'||t1||'"  SIZE='nshow' MAXLENGTH=85> '
return rr





/* ----------- */                                                        
/* get environment value, possibly host specific */                      
/* ------------ */                                                       
get_value: procedure expose enmadd host_nickname usecolor
parse arg vname,hname0
if hname0=0 then 
        hname=' '
else                                                    
    hname=strip(host_nickname)                          

vname=strip(vname) ;
if hname<>' ' then do                                                    
   aval=value(enmadd||vname||'.'||hname,,'os2environment')               
   if aval<>' ' Then                                                     
        return aval                                                      
end                                                                      
aval=value(enmadd||vname,,'os2environment')                              
return aval                   


/* write results routine */
writeres:
list0=list
do until list=""
    parse var list a1 '&' list
    parse upper var a1 avar '=' aval
    if avar='WRITETO' then do
       htout=strip(packur(aval))
       leave
    end  /* Do */
end /* do */
foo=sysfiledelete(htout)
foo=lineout(htout,,1)
_diris=0
if pos('_DIRIS=1',upper(list0))>0 then _diris=1
list=list0
do until list=""
    parse var list a1 '&' list
    parse var a1 avar '=' aval
    avar=strip(packur(avar));
    aval=strip(packur(aval));

    if translate(avar)='_DIRIS' then iterate
    if translate(avar)='WRITETO' then iterate
    if translate(avar)='LIMIT' then aval=' require '||aval
    if translate(avar)='COMMENT' then avar='; ' 
    if translate(avar)='DIR.EXCLUDE' & _diris=1 then
        avar='_'||avar
    if aval \=' ' then
        call lineout htout,avar ':' aval
end
call lineout htout

call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
call lineout tempfile, "<html><head><title>SRE-Filter HTACCESS configurator </title>"
call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '

call lineout tempfile, "<h1> SRE-Filter: <A NAME="top"> HTACCESS Configurator </A>   </h1> <p>"
call lineout tempfile,' Results were written to ' htout

call lineout tempfile, '</body> </html> '
call lineout tempfile
'file erase  type text/html name  ' tempfile

return 0


/* ----------------------------------------------------------------------- */
/* get_HTACCESS --- a modification of Don Meyer's CHECKAUTH & other stuff:

This will CHECK all the accessfilenames in the tree underneath
file for access privileges, etc.  

For details on how to set up an accessfile, see
     http://w3.ag.uiuc.edu/DLM/GOHTTP/Auth.Guide.html


ENABLEPOSTPROCESS (use the post_filter stuff), and _DIR.BUILDER


When dodirs=2, return ALL parameters (used by htaccess configurator)
Dodirs=3, just the "own directory" (if it exists)


*/

/* ----------------------------------------------------------------------- */
get_htaccess:procedure expose _diris

  parse arg sel,file,accessfilename,dir,TEMPFILE,dodirs

  file = translate( file, '/', '\')

  dir.exclude=' '
  PathTo = ''
  rest = file
  retCode = 0
  gotlist=' '
  set=' '

/* initialize some variable */
auth.name=' '; auth.type=' ' ; auth.userfile=' ' ; auth.groupfile=' '
auth.index=' '; redirectfile=' '; auth.limit=' '; dir.exclude=' ';
dir.info=' ' ; dir.describe=' ' ; dir.forbid=' ';rx.builddir=' '
_diris=0
rx.enablepostprocess=' '
dir.build=0 ; rx.builddir=' '


  owndir=filespec('d',file)||filespec('p',file)
  owndir=translate(translate(owndir,'/','\'))
  owndir=strip(owndir,'t','/')

/* find htaccess files;
   and if found, extract the parameters, starting at base of directory tree
   (thus, own htaccess file is favored */

  do while (rest \= '')
    restdoggy=right(rest,1)
    parse var rest _dir'/'rest
    if (right( _dir,1) == ':') then PathTo = _dir
    else PathTo = PathTo'/'_dir

    if dodirs==3 then do;
          if translate(pathto) \= owndir then do
                iterate
          end
    end

    goofy=rest ; if goofy=' ' & restdoggy='/' then goofy='/'
    if (left(PathTo,3) == '///') then 
           PathTo = substr(PathTo,2)
    else if (goofy \= '')  & (right( _dir,1) \= ':') then do
         geek1=pathto'/'accessfilename
         ACLfile = stream(geek1, 'c', 'query exists')


      if (ACLfile \= '') then do /* if not, climb up the tree */
         gotlist=gotlist' 'aclfile
         Auth.GroupFile = ' '
         Auth.Limit = ' '
         rc = stream( ACLfile, 'c', 'OPEN READ')
         line = linein( ACLfile, 1)
         do while (line \= '')
            do while( pos(left(line,1), "2009"x) > 0); line = substr(line, 2); end
            if ( pos(left(line,1), "#") > 0) then line = substr(line, 2)
            if ( left(line,1) == ';') then line = ';COMMENT'

            parse var line key ':' val
            val = strip(val)
            key = translate(key)
            if (key = 'AUTHUSERFILE') | (key = 'AUTHGROUPFILE') | (key = 'REDIRLIST') then do
               if (pos(':', val ) == 0) then do
                  val = translate(val, '\', '/')
                  if (left(val,1) == '\') then val = substr( val, 2)
                  val = dir || val
               end
            end
            select
               when (key = 'AUTHNAME') then Auth.Name = val
               when (key = 'AUTHTYPE') then Auth.Type = translate( strip(val))
               when (key = 'AUTHUSERFILE') then Auth.UserFile = val
               when (key = 'AUTHGROUPFILE') then Auth.GroupFile = val
               when (key = 'DEFAULTINDEX') then Auth.Index = val
               when (key = 'REDIRLIST') then RedirectFile = val
               when (key = 'REDIRFILE') then RedirectFile = val  /* bug? in original code */
               when (key = 'LIMIT') then    Auth.Limit = val
               when (key = 'BUILDDIR') then Dir.Build = (val \= '0')
               when (key = 'DIR.EXCLUDE') then Dir.Exclude = Dir.Exclude val
               when (key = '_DIR.EXCLUDE') then do
                      Dir.Exclude = val
                      _diris=1
               end  /* Do */
               when (key = 'DIR.INFO') then Dir.Info = val
               when (key = 'DIR.DESCRIBE') then Dir.Describe = val
               when (key = 'DIR.FORBID') then Dir.Forbid = (val \= '0')
               when (key = 'DIR.BUILDER') then Rx.BuildDir = val
               when (key = 'ENABLEPOSTPROCESS') then do
                     v = left(strip(val),1)
                     if (pos(v, '012') > 0) then Rx.EnablePostProcess = v
                  end
               otherwise 
            end

            line = linein( ACLfile)
         end
         rc = stream( ACLfile, 'c', 'close')

       end                /* this aclfile */
    end          /* goofy */
  end                       /* climbing up directory tree */

    bigone=gotlist', 'auth.name', 'auth.type', 'auth.userfile', 'auth.groupfile
    bigone=bigone', 'auth.index', 'redirectfile', 'auth.limit', 'dir.build
    bigone=bigone', 'dir.exclude', 'dir.info', 'dir.describe', 'dir.forbid', 'rx.builddir
    bigone=bigone', 'rx.enablepostprocess
  return bigone

    



/* get file line by line . Return in somelines. variable */

get_lines:procedure expose somelines.

parse arg afile
crlf='0d0a'x

mm=0

foo=stream(afile,'c','query exists')
if foo=' ' then do
   somelines.0=0
   return 0
end

foo=charin(afile,1,chars(afile))
foo=strip(foo,'t','1a'x)
a=stream(afile,'c','close')

do until foo=''
   parse var foo  aline (crlf) foo
   mm=mm+1
   somelines.mm=aline
end
somelines.0=mm

return mm


end /* do */





