/* DODELETE.CMD -- delete files from http server using DELETE http method  */
/* ------------------------------------------------------------------- */
/* Call as:  MOVEAUD serveraddress url_to_delete                     */
/* ------------------------------------------------------------------- */
/* This program requires that the RxSock.DLL be in your LIBPATH (it is */
/* usually in your \TCPIP\DLL directory.  It was shipped with the      */
/* August 1994 CSD for the TCP/IP base (UN64092).                      */

call load /* load functions if necessary */

say " Program to DELETE files from an HTTP server using the PUT verb "


parse arg server request .

if server="" then do 
   say " Reminder: the HTTP server must support the DELETE http method "
   say "  (you may also require special access privileges) "

    say " Please enter server address: "
    parse pull server
end  /* Do */
if request="" then  do
  say " Please enter url to use (on " server "): "
  parse pull request
end

crlf    ='0d0a'x                        /* constants */
family  ='AF_INET'
httpport=80

rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
if rc=0 then do; say 'Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")

message='DELETE /'request' HTTP/1.0'crlf||crlf
say message


got=''
rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say 'Unable to connect to "'server'"'; exit; end
rc = SockSend(gosock, message)
say " rc " rc
/* Now wait for the response */
do r=1 by 1
  rc = SockRecv(gosock, "response", 1000)
  got=got||response
  /* say '>'rc'>' response */
  if rc<=0 then leave
  end r
rc = SockClose(gosock)

say 'Got' length(got) 'bytes of response:'
say  got
exit

/* --- Load the function library, if necessary --- */
load:
if \RxFuncQuery("SockLoadFuncs") then return      /* already there */
call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
call SockLoadFuncs
return
