/* rexx */
/* This rexx script will convert the files in the queue
   directory from virtual domain que files to regular
   que files */

call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

rc = SysFileTree('*.que', s., 'FO')

if rc = 0 then do i = 1 to s.0
  Tmp = SysTempFileName('????.tmp', '?')
  rc = stream(Tmp, 'c', 'open write')
  rc = stream(s.i, 'c', 'open read')

  Line = linein(s.i)        /* last tried */
  rc = lineout(Tmp, Line, )

  Line = linein(s.i)        /* entry time */
  rc = lineout(Tmp, Line, )

  Line = linein(s.i)        /* virtual domain, discard it */

  do while lines(s.i) <> 0       /* Now the rest of the lines */
    Line = linein(s.i)
    rc = lineout(Tmp, Line, )
    end
  rc = stream(Tmp, 'c', 'close')
  rc = stream(s.i, 'c', 'close')

  copy Tmp s.i
  rc = SysFileDelete(Tmp)
  end

exit

