/*
 * Order.cmd 1.1
 *
 * Written by: Paul Hethmon <phethmon@hethmon.com>
 * Date: 17 February 1998
 *
 * This rexx script will order the email messages matching
 * the given file specification (e.g. *.txt) by renaming
 * them based on the message header date. This should provide
 * an ordering which is chronological.
 *
 * Use this script to rename an existing web archive directory
 * so that the WebArchive.cmd script can put them on the
 * new webpage in the correct order.
 *
 */

/* Do not modify this section */
hi = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
lo = 'abcdefghijklmnopqrstuvwxyz'
Env = 'OS2ENVIRONMENT'
FALSE = 0
TRUE = 1
Copy = 'copy'
Mkdir = 'mkdir'
Rename = 'ren'
HeadFrom = ''
HeadTo = ''
HeadReplyTo = ''
HeadSubject = ''
HeadDate = ''
HeadCc = ''
HeadSender = ''
HeadContentType = ''
HeadMimeVersion = ''
TmpDir = ''
/* End of section to not modify */

/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* start main function */
parse arg Pattern

call on error name ErrHandler

rc = SysFileTree(Pattern, s., 'FO')

if rc = 0 then do i = 1 to s.0

  MsgFile = s.i
  say 'MsgFile =' MsgFile
  rc = stream(MsgFile, 'c', 'open read')
  HeadDate = ''
  call ParseHeaders
  say 'HeadDate =' HeadDate
  rc = stream(MsgFile, 'c', 'close')

  /* Now we must determine the date of the message by the message header */
  /* Date: Mon, 1 Dec 1997 09:54:23 -0500 */
  if lastpos(',', HeadDate) = 0 then
    parse var HeadDate Day Month Year Hour ':' Minute ':' Second Tz
  else
    parse var HeadDate twkday Day Month Year Hour ':' Minute ':' Second Tz
  select
    when Month = 'Jan' then
      FullMonth = 'January'
    when Month = 'Feb' then
      FullMonth = 'February'
    when Month = 'Mar' then
      FullMonth = 'March'
    when Month = 'Apr' then
      FullMonth = 'April'
    when Month = 'May' then
      FullMonth = 'May'
    when Month = 'Jun' then
      FullMonth = 'June'
    when Month = 'Jul' then
      FullMonth = 'July'
    when Month = 'Aug' then
      FullMonth = 'August'
    when Month = 'Sep' then
      FullMonth = 'September'
    when Month = 'Oct' then
      FullMonth = 'October'
    when Month = 'Nov' then
      FullMonth = 'November'
    when Month = 'Dec' then
      FullMonth = 'December'
    otherwise
      FullMonth = Month
  end  /* select */

  /* Check for single digit days and adjust */
  if length(Day) < 2 then do
    Day = '0'||Day
    Day = right(Day, 2)
    end

  /* check for 2 digit years */
  if length(Year) = 2 then do
     Year = '19'||Year
     Year = left(Year, 4)
     end

  /* check for single digit hours */
  if length(Hour) = 1 then do
     Hour = '0'||Hour
     Hour = right(Hour, 2)
     end

  /* now we must rename it */
  NewName = Year||Month||Day||Hour||Minute||Second'.msg'
  rc = stream(NewName, 'c', 'query exists')
  if rc = '' then do
    Rename MsgFile NewName
    end
  else do
    NewName = Year||Month||Day||Hour||Minute||Second'????.msg'
    NewName = SysTempFileName(NewName, '?')
    Rename MsgFile NewName
    end

  end /* main if statement */

exit

/* ------------------------------------------------------------------ */
/*
 * Parse RFC822 headers
 *
 */

ParseHeaders: 

say 'ParseHeaders starting'

Line = linein(MsgFile)                /* get a line of the file */

do while Line <> ''                   /* until end of headers */
  FirstChar = left(Line, 1, '-')
  if FirstChar = ' ' then             /* continuation line */
    do
    Key = LastKey                     /* field name is same */
    Val = Line                        /* value is entire line */
    end
  else
    do
    parse var Line Key ':' Val          /* separate out the components */
    end

  Key = translate(Key, lo, hi)

  select
    when Key = 'date' then
      do
      HeadDate = HeadDate' 'Val
      LastKey = 'date'
      end
    otherwise do
      LastKey = Key
      end
    end   /* select */
  Line = linein(MsgFile)
end       /* do while */

return

/* ------------------------------------------------------------------ */

ErrHandler:

SIGerrCode = RC
L2wErrLog = 'l2w.err'

say 'Identified error while executing line #'Sigl'   RC = ['SIGerrCode']'
say '['SourceLine(Sigl)']'
rc = lineout( L2wErrLog, '     -----', )
rc = lineout( L2wErrLog, 'Error ['SIGerrCode'] while executing line #'Sigl, )
rc = lineout( L2wErrLog, '['SourceLine(Sigl)']')

return

/* -------------------------------------------------------- */
/* -------------------------------------------------------- */
/* -------------------------------------------------------- */