/* Steward Version 1.7 */
/*
 * A mailing list processor in Rexx by Paul Hethmon
 *
 */

/* variable declarations */

Steward = 'Steward'
StewardVersion = 'Version 1.7'
StewardDate = '2 March 1998'
uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
lowercase = 'abcdefghijklmnopqrstuvwxyz'
Env = 'OS2ENVIRONMENT'
FALSE = 0
TRUE = 1

/* Set to 1 to enable debug output */
Debug = TRUE
/* Set to 1 to enable logging */
Log = TRUE
LogFile = ''
ETime1 = 0
ETime2 = 0
Author = ''
AdminFile = ''
AdminSubject = ''
AdminTo = ''

/* Variables normally read from the configuration file */
/* These values are provided as defaults only */
HomeDir = 'c:'
LogDir = 'c:'
ListDir = 'c:'
Mailer = 'hmailer'
WhereAmI = 'example.com'
WhoAmI = Steward
WhoAmIOwner = 'postmaster@'WhereAmI
MasterPassword = 'steward'

/* The external functions we need */
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'

/* start main function */
/* The first arg is who the message was sent to.
 * The second is the filename. We're responsible
 * for cleaning up the file if needed.
 */
parse arg Rcpt MsgFile

parse var Rcpt Rcpt '@' Domain
if Debug = TRUE then say 'Rcpt =' Rcpt 'MsgFile =' MsgFile

call on error name ErrHandler

say 'Reading Master Configuration File Now.'

/* Read the master configuration file now */
rc = ReadMasterCf()
if rc = FALSE then
  do
  say 'Unable to read master configuration file. Failing.'
  ErrFile = SysTempFileName('?????.err', '?')
  rc = stream(ErrFile, 'C', 'OPEN WRITE')
  rc = lineout(ErrFile, 'Steward Error File', )
  rc = lineout(ErrFile, 'You must rerun Steward with the recipient name and', )
  rc = lineout(ErrFile, 'message file name listed below in order to process', )
  rc = lineout(ErrFile, 'this message.', )
  rc = lineout(ErrFile, 'Rcpt =' Rcpt, )
  rc = lineout(ErrFile, 'MsgFile =', MsgFile, )
  rc = stream(ErrFile, 'C', 'CLOSE')
  exit
  end

/* change to the Steward Home Directory */
Junk = directory(HomeDir)

if Debug = TRUE then
  do
  say 'LogDir =' LogDir
  say 'HomeDir = ' HomeDir
  say 'ListDir =' ListDir
  say 'Junk =' Junk
  end

/* figure out who got the message */
Rcpt = translate(Rcpt, lowercase, uppercase)
WhoAmI = translate(WhoAmI, lowercase, uppercase)

/* In case its a request, digest, or owner message */
if pos('-request', Rcpt, ) > 0 then do
  parse var Rcpt List '-request'
  RequestType = 'request'
  end
else if pos('-digest', Rcpt, ) > 0 then do
  parse var Rcpt List '-digest'
  RequestType = 'digest'
  end
else if pos('-owner', Rcpt, ) > 0 then do
  parse var Rcpt List '-owner'
  RequestType = 'owner'
  end
else if pos('-errors', Rcpt, ) > 0 then do
  parse var Rcpt List '-errors'
  RequestType = 'errors'
  end
else do
  List = Rcpt
  RequestType = 'list'
  end

/* now find out if it was to steward or one of the lists */
if RequestType = 'request' then do
  /* process this message with the list and admin specific filter */
  if Debug = TRUE then do
    say 'Processing Admin request'
    say 'Recipient was a request for:' List
    end
  call Admin(List MsgFile)
  end
else if RequestType = 'digest' then do
  /* process this as a digest submission */
  if Debug = TRUE then do
    say 'Processing Message request'
    say 'Recipient was a digest:' Rcpt
    end
  call Message(List MsgFile)
  end
else if RequestType = 'owner' then do
  /* process this as an admin request */
  if Debug = TRUE then do
    say 'Processing Owner request'
    say 'Recipient was an owner:' Rcpt
    end
  call Errors(List MsgFile)
  end
else if RequestType = 'errors' then do
  /* Process this as an error return */
  if Debug = TRUE then do
    say 'Processing Errors request'
    say 'Recipient was to errors:' Rcpt
    end
  call Errors(List MsgFile)
  end
else if Rcpt = WhoAmI then do
  /* process this message with the admin filter */
  if Debug = TRUE then do 
    say 'Processing Admin request'
    say 'Recipient was' WhoAmI
    end
  call Admin(Rcpt MsgFile)
  end
else do
  /* process this as a message to the list */
  if Debug = TRUE then do
    say 'Processing List request'
    say 'Recipient was a list:' List
    end
  call Message(List MsgFile)
  end

/* Make sure the tmp file is deleted */
rc = SysFileDelete(MsgFile)

exit

/* ------------------------------------------------------------------ */
/*
 * Read the master configuration file
 *
 */

ReadMasterCf: procedure expose HomeDir LogDir ListDir Mailer WhereAmI WhoAmI ,
              WhoAmIOwner MasterPassword Env TRUE FALSE Debug

if Debug = TRUE then say 'Reading Steward configuration file.'

/* Find out where the configuration file should be */
StewardCf = value('steward_cf',,Env)
/* StewardCf = value('steward_cf_test',,Env) */

/* If its not defined then assume wherever we are */
if StewardCf = '' then do
  StewardCf = '.'
  end

FileName = StewardCf'\steward.cf'

rc = LockOpen(FileName 'READ')  /* open the file locking it */
if rc = FALSE then
  return FALSE                   /* return FALSE if cannot open */

/* now read the configuration file */
do while lines(FileName) <> 0         /* until end of file */
  Line = linein(FileName)             /* get a line of the file */
  parse var Line Line '#' Comment     /* separate out any comments */
  if Line <> '' then do               /* if not null */
    parse var Line Key '=' Val        /* find the key and value */
    if Key <> '' then do
      Val = strip(Val, 'B', ' ')      /* remove any blanks */
      Key = strip(Key, 'B', ' ')
      select
        when Key = 'HomeDir' then
          do
          HomeDir = Val
          end
        when Key = 'LogDir' then
          do
          LogDir = Val
          end
        when Key = 'ListDir' then
          do
          ListDir = Val
          end
        when Key = 'Mailer' then
          Mailer = Val
        when Key = 'WhereAmI' then
          WhereAmI = Val
        when Key = 'WhoAmI' then
          WhoAmI = Val
        when Key = 'WhoAmIOwner' then
          WhoAmIOwner = Val
        when Key = 'MasterPassword' then
          MasterPassword = Val
        otherwise nop
        end   /* select */
      end     /* if Key <> '' */
    end       /* if Line <> '' */

  Key = ''

end /* end do while */

rc = LockClose(FileName)

if Debug = TRUE then say 'Steward.cf file read.'

return TRUE

/* ------------------------------------------------------------------ */

ErrHandler:

SIGerrCode = RC
StewardErrLog = 'Steward.err'

if Debug = TRUE then say 'Identified error while executing line #'Sigl'   RC = ['SIGerrCode']'
if Debug = TRUE then say '['SourceLine(Sigl)']'
rc = lineout( StewardErrLog, '     -----', )
rc = lineout( StewardErrLog, 'Error ['SIGerrCode'] while executing line #'Sigl, )
rc = lineout( StewardErrLog, '['SourceLine(Sigl)']')

return


/* ------------------------------------------------------------------ */
/* ------------------------------------------------------------------ */
/* ------------------------------------------------------------------ */


