/* AutoReply Rexx Script */

/*
 * This script will send an automatic reply based on
 * the username passed to it.
 *
 * Version 1.1
 *
 */

/* Date: 18 February 1998 */

uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
lowercase = 'abcdefghijklmnopqrstuvwxyz'
Env = 'OS2ENVIRONMENT'
FALSE = 0
TRUE = 1
HeadFrom = ''
HeadTo = ''
HeadReplyTo = ''
HeadSubject = ''
HeadDate = ''
HeadCc = ''
HeadSender = ''
HeadEmail = ''
ReplyTo = ''                   /* Point to an address for more info */
Mailer = 'hmailer'
WhereAmI = 'example.com'       /* Define to your local hostname */
Sender = 'AutoReply'           /* Where errors will go */

/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'

/* Find the temporary directory to use */
TmpDir = value('STEWARD_TMP',,Env)
if TmpDir = '' then
  do
  TmpDir = value('TMP',,Env)
  end

/* start main function */
/* The first arg is who the message was sent to.
 * The second is the filename. We're responsible
 * for cleaning up the file if needed.
 */
parse arg UserName MsgFile

/* Find out where the files are */
AutoReply = value('autoreply',,Env)  /* comment this line to not use the environment variable */
/*AutoReply = 'c:\inetmail\autoreply'*/  /* uncomment this line to specify a directory */

/* Remove the next line to enable multi-domain support */
parse var UserName UserName '@' Domain
/* If removed, then files to be sent back should be named */
/* user@domain.txt instead of user.txt */

/* change to the directory for autoreply files */
Junk = directory(AutoReply)

/* Find out who the message is from */
rc = stream(MsgFile, 'c', 'open read')
call ParseHeaders
rc = stream(MsgFile, 'c', 'close')

/* Figure out who to send mail back to */
if HeadReplyTo <> '' then
  HeadEmail = HeadReplyTo
else
  HeadEmail = HeadFrom
/* now clean up the email address */
HeadEmail = NormalizeEmail(HeadEmail)
HeadEmail = translate(HeadEmail, lowercase, uppercase)

if HeadEmail = '' then do
  say 'No valid return address found.'
  exit
  end

/* create a temp file for the outgoing message */
OutFile = SysTempFileName(TmpDir'\f?????.tmp', '?');
rc = stream(OutFile, 'C', 'OPEN WRITE')  /* open the file for writing */
call WriteHeaders /* the headers for the outgoing message */
rc = stream(OutFile, 'C', 'close')       /* close the file */

ReplyFile = AutoReply'\'UserName'.txt'   /* append the reply file to the */
rc = AppeLock(ReplyFile OutFile)         /* headers file */

/* the request is processed, now send the message back */
/* first create a file with the email address in it */
EmailFile = SysTempFileName(TmpDir'\e?????.tmp', '?')
rc = stream(EmailFile, 'C', 'OPEN WRITE')  /* open the file for writing */
rc = lineout(EmailFile, HeadEmail, )
rc = stream(EmailFile, 'C', 'CLOSE')

say 'Calling mailer'
/* now start the mailer */
Mailer Sender'@'WhereAmI EmailFile OutFile

/* Remove the request file from the user */
rc = SysFileDelete(MsgFile)

return

/* ------------------------------------------------------------------ */
/*
 * Normalize the email address into a SMTP form
 *
 */

NormalizeEmail: procedure

parse arg All

rc = pos('<', All, )
if rc = 0 then
  do
  /* in case some mailers use () instead of <> */
  All = translate(All, '<', '(')
  All = translate(All, '>', ')')
  end

parse var All Part1 '<' Part2 '>' Part3

rc = pos('@', Part1, )
if rc <> 0 then 
  do
  Part1 = strip(Part1, 'B', )  /* we must strip any blanks leftover */
  if Part2 <> '' then Author = Part2
  else if Part3 <> '' then Author = Part3
  else Author = Part1
  return Part1
  end

rc = pos('@', Part2, )
if rc <> 0 then
  do
  Part2 = strip(Part2, 'B', )
  if Part1 <> '' then Author = Part1
  else if Part3 <> '' then Author = Part3
  else Author = Part2
  return Part2
  end

rc = pos('@', Part3, )
if rc <> 0 then
  do
  Part3 = strip(Part3, 'B', )
  if Part2 <> '' then Author = Part2
  else if Part1 <> '' then Author = Part1
  else Author = Part3
  return Part3
  end

return ''  /* error finding SMTP email address */

/* ------------------------------------------------------------------ */
/*
 * Parse RFC822 headers
 *
 */

ParseHeaders: procedure expose HeadTo HeadFrom HeadReplyTo MsgFile HeadSubject ,
              lowercase uppercase HeadDate HeadCc HeadSender FALSE TRUE

say 'ParseHeaders starting'

Line = linein(MsgFile)                /* get a line of the file */
do while Line <> ''                   /* until end of headers */
  parse var Line Key ':' Val          /* separate out the components */
  Key = translate(Key, lowercase, uppercase)
  select
    when Key = 'to' then
      HeadTo = Val
    when Key = 'reply-to' then
      HeadReplyTo = Val
    when Key = 'from' then
      HeadFrom = Val
    when Key = 'subject' then
      HeadSubject = Val
    when Key = 'date' then
      HeadDate = Val
    when Key = 'cc' then
      HeadCc = Val
    when Key = 'sender' then
      HeadSender = Val
    otherwise nop
    end   /* select */
  Line = linein(MsgFile)
end       /* do while */

return

/* ------------------------------------------------------------------ */
/*
 * Write out our standard headers for a message
 *
 */

WriteHeaders:  /* note that we have full access to all globals here */

TimeZone = value( 'TZ', , Env)
TmpTime = time('N')
DayOfWeek = date('W')
DayOfWeek = left(DayOfWeek, 3)
TmpDate = date('N')
/* we put in the local time for date so that posts are chronological */
rc = lineout(OutFile, 'Date:' DayOfWeek',' TmpDate TmpTime TimeZone, )
rc = lineout(OutFile, 'Sender:' Sender '<'Sender'@'WhereAmI'>', )
rc = lineout(OutFile, 'From:' HeadTo, )
if ReplyTo <> '' then
  rc = lineout(OutFile, 'Reply-To:' ReplyTo, )
rc = lineout(OutFile, 'To:' HeadEmail, )
rc = lineout(OutFile, 'Subject: Re:' HeadSubject, )
rc = lineout(OutFile, '', )

return

/* ------------------------------------------------------------------ */



