/*********************************************************************/
/* DMI IRC REXX Command Script for REXX Clients.  v1.25   26 Sep 96  */
/*********************************************************************/
/* XDCC Functions                                         26 Sep 96  */
/*********************************************************************/

XDCC_Out:
   Parse Upper Arg WinHandle WinName OurNick Verb Parm1 Parm2 Parm3 Parms
   Parse Arg xWinHandle xWinName xOurNick xVerb xParm1 xParm2 xParm3 xParms

   Pool = 'OS2ENVIRONMENT'
   CMD = Value('COMSPEC',, Pool)
   DMIMsg = '*DMI*'
   ErrStr = '*[Error]*'
   DataDir = Value('DataDir',, Pool)
   XDCCList = DataDir || Value('XDCCList',, Pool)
   TotalSent = Value('TotalSent',, Pool)

   SIGNAL ON SYNTAX
   TotalSize = 0
   Select
      When Parm1 = 'LIST' then do
         If xParm2 == '' then do
            LineNo=0
            Call Library
            DescFile = Stream(XDCCList || '.DIZ', 'C', 'QUERY EXISTS')
            if DescFile \= '' then ExtDesc = 1
            IrcRexxDisplay(DMIMsg 'XDCC offer file:' XDCCList, WinHandle)
            do while Lines(XDCCList)
               Fileline = LineIn(XDCCList)
               if Fileline = '' then leave
               LineNo = LineNo + 1
               Drop FStem.
               Parse Var Fileline FSpec FDesc
               SysFileTree(FSpec, 'Files.', 'FO')
               If Files.0 <= 0 then do
                  IrcRexxDisplay(ErrStr 'Missing File on line' LineNo 'of XDCC Offer list' XDCCList '.', WinHandle)
                  iterate
               End
               else do
                  TempSize = 0
                  Files.Size = 0
                  TempCount = Files.0
                  do TempCount = 1 to TempCount
                     TempSize = Trunc((Stream(Files.TempCount, 'C', 'QUERY SIZE') / 1024), 1)
                     Files.Size = Files.Size + TempSize
                  end
                  if Files.Size >= 1000 then do
                     Files.Megs = TRUE
                     Files.Size = Trunc(Files.Size / 1024, 1)
                  end
                  if (ExtDesc = 1) then do
                     PackDesc.0 = 0
                     if ((SysFileSearch('Pack'||LineNo, DescFile, 'TempDesc.') = 0) & (TempDesc.0 > 0)) then do
                        do TempCount = 1 to TempDesc.0
                           parse var TempDesc.TempCount dummy PackDesc.TempCount
                        end
                        PackDesc.0 = TempDesc.0
                     end
                  end
                  if (Files.Megs == TRUE) then do
                     TotalSize = Trunc(TotalSize + (Files.Size * 1024), 0)
                     PackInfo = ''Right(Files.0, 2)':'Right(Files.Size, 5)'M'
                  end
                  else do
                     TotalSize = Trunc((TotalSize + Files.Size), 0)
                     PackInfo = ''Right(Files.0, 2)':'Right(Files.Size, 5)'K'
                  end
                  IrcRexxDisplay(DMIMsg '#'LineNo': ['PackInfo']' FDesc, WinHandle);
                  if (ExtDesc = 1) then do
                     do TempCount = 1 to PackDesc.0
                        IrcRexxDisplay(DMIMsg '               ' PackDesc.TempCount, WinHandle)
                     end
                  end
               End
            End
            IrcRexxDisplay(DMIMsg 'Total Offered: 'TotalSize'K. Total Sent: 'TotalSent'K.', WinHandle);
         End
         else do
            Value('XDCCList', xParm2, Pool);
            XDCCList = Value('XDCCList',, Pool);
            IrcRexxDisplay(DMIMsg 'XDCC Offer List set to:' XDCCList || '.', WinHandle);
         end
         Return ''
      end
      When Parm1 = 'SHOW' then do
         LineNo = 0
         Call Library
         DescFile = Stream(XDCCList || '.DIZ', 'C', 'QUERY EXISTS')
         if DescFile \= '' then ExtDesc = 1
         IrcRexxCommand('Files offered: (/MSG' xOurNick 'XDCC SEND #N for pack N)', WinHandle)
         do while Lines(XDCCList)
            Fileline = LineIn(XDCCList)
            if Fileline = '' then leave
            LineNo = LineNo + 1
            Drop FStem.
            Parse Var Fileline FSpec FDesc
            SysFileTree(FSpec, Files., 'FO')
            If Files.0 <= 0 then do
               IrcRexxDisplay(ErrStr 'Missing File on line' LineNo 'of XDCC Offer list' XDCCList '.', WinHandle)
               iterate
            End
            else do
               TempSize = 0
               Files.Size = 0
               do TempCount = 1 to Files.0
                  TempSize = Trunc((Stream(Files.TempCount, 'C', 'QUERY SIZE') / 1024), 1)
                  Files.Size = Files.Size + TempSize
               end
               if Files.Size >= 1000 then do
                  Files.Megs = TRUE
                  Files.Size = Trunc(Files.Size / 1024, 1)
               end
               if (ExtDesc = 1) then do
                  PackDesc.0 = 0
                  if ((SysFileSearch('Pack'||LineNo, DescFile, 'TempDesc.') = 0) & (TempDesc.0 > 0)) then do
                     do TempCount = 1 to TempDesc.0
                        parse var TempDesc.TempCount dummy PackDesc.TempCount
                     end
                     PackDesc.0 = TempDesc.0
                  end
               end
               if (Files.Megs == TRUE) then do
                  TotalSize = Trunc(TotalSize + (Files.Size * 1024), 0)
                  PackInfo = ''Right(Files.0, 2)':'Right(Files.Size, 5)'M'
               end
               else do
                  TotalSize = Trunc((TotalSize + Files.Size), 0)
                  PackInfo = ''Right(Files.0, 2)':'Right(Files.Size, 5)'K'
               end
               IrcRexxCommand('#'LineNo': ['PackInfo']' FDesc, WinHandle);
               if (ExtDesc = 1) then do
                  do TempCount = 1 to PackDesc.0
                     IrcRexxCommand('               ' PackDesc.TempCount, WinHandle)
                  end
               end
            End
         End
         IrcRexxCommand('Total Offered: 'TotalSize'K. Total Sent: 'TotalSent'K.', WinHandle)
         Return ''
      end
      When Parm1 = 'SEND' then do
         LineNo = 0
         if xParm2 <> '' then do
            NotNick = 'NOTICE' xParm2 ':'
            do while Lines(XDCCList)
               Fileline = LineIn(XDCCList)
               if Fileline = '' then leave
               LineNo = LineNo + 1
               Drop FStem.
               Parse Var Fileline FSpec FDesc
               if LineNo = xParm3 then do
                  Call Library
                  SysFileTree(FSpec, Files., 'FO')
                  If Files.0 <= 0 then do
                     IrcRexxDisplay(ErrStr 'Missing File on line' LineNo 'of XDCC Offer list' XDCCList '.', WinHandle)
                     leave
                  End
                  else do
                     Files.Size = 0
                     TempSize = 0
                     do TempCount = 1 to Files.0
                        TempSize = Trunc((Stream(Files.TempCount, 'C', 'QUERY SIZE') / 1024), 0)
                        Files.Size = Files.Size + TempSize
                     end
                     FileSize = Files.Size || 'K'
                     IrcRexxSend(NotNick || 'Sending you "'FDesc'" ('FileSize') by manual request.', WinHandle)
                     IrcRexxDisplay(DMIMsg 'Sending "'FDesc'"('FileSize') to 'xParm2'.', WinHandle)
                     Value('TotalSent', TotalSent + Files.Size, Pool);
                     do TempCount = 1 to Files.0
                        IrcRexxCommand('/DCC SEND' xParm2 Files.TempCount, WinHandle)
                        logentry = Date('N') Time('C') Files.TempCount 'sent to' xParm2
                        Lineout(DataDir'XDCC.Log', logentry)
                     end
                     Lineout(DataDir'XDCC.Log')
                     Return ''
                  end
               End
            End
            IrcRexxDisplay(ErrStr 'That pack is not available! Range: [1..'|| LineNo || ']', WinHandle)
            Return ''
         end
         else IrcRexxDisplay(ErrStr 'Usage: /XDCC SEND <User> <Pack>', WinHandle)
         Return ''
      end
      When Parm1 = '' then do
         IrcRexxDisplay(ErrStr 'Usage: /XDCC <Command> [Parameters]', WinHandle)
         Return ''
      end
      otherwise do
         If Parm1 <> '' then do
            Select
               When Parm2 = 'HELP' then IrcRexxSend('PRIVMSG' xParm1 ':XDCC HELP', WinHandle)
               When Parm2 = 'LIST' then IrcRexxSend('PRIVMSG' xParm1 ':XDCC LIST', WinHandle)
               When Parm2 = 'GET' then IrcRexxSend('PRIVMSG' xParm1 ':XDCC SEND' Parm3'', WinHandle)
               When Parm2 = 'SEND' then IrcRexxSend('PRIVMSG' xParm1 ':XDCC SEND' Parm3'', WinHandle)
               Otherwise IrcRexxDisplay(ErrStr 'Usage: /XDCC <User> <Command> [Params]', WinHandle)
            end
            Return ''
         end
         else do
            IrcRexxDisplay(ErrStr 'Unsupported (yet?) XDCC Command. Try /HELP XDCC', WinHandle)
            Return ''
         end
      end
   end
Return ''

library:
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
Return

SYNTAX:
   IrcRexxDisplay(ErrStr 'REXX Syntax Error' RC '(' || ErrorText(RC) || ') at line' SIGL 'of XDCC_Out.Cmd.', WinHandle);
Return ''

