/* program: which  (a freeby)
** written: Stan J. Towianski
** purpose: looks for the input filename in the directories in your 
**          PATH variable and tells you where it found it.
**          OR if you give a 2nd arg. it will use that environment variable to get the
**          path to look thru instead of PATH.  LIBPATH would be a common example.
**    date: Dec/1996
*/

parse arg fname fpath

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

if ( fpath = '' ) then
    fpath = 'PATH'

fpath = translate( fpath )

if ( fpath = 'LIBPATH' ) then
    Do
    dll_path = value( 'SYSTEM_INI', , 'OS2ENVIRONMENT' )
    dll_drive = filespec( 'drive', dll_path )

    configpath = dll_drive||'\config.sys'
    rc = stream( configpath, 'c', 'open' )
    Do while ( lines( configpath ) > 0 )
        tline = linein( configpath )
        if ( left( tline, 7 ) = 'LIBPATH'  |  left( tline, 7 ) = 'libpath' ) then
            Do
            '@set' tline
            leave
            End
    End
    rc = stream( configpath, 'c', 'close' )
    End

found_at = syssearchpath( fpath, fname )
say found_at
return found_at

