/* daytime.h
 *
 * Author:   <rommel@ars.de>
 * Created: Sun May 04 1997
 *
 * This code is in the public domain. 
 * Let the author know if you make improvements or fixes, though.
 */
 
/* $Id: daytime.h,v 1.1 1997/05/04 19:59:52 rommel Exp rommel $ */

/*
 * $Log: daytime.h,v $
 * Revision 1.1  1997/05/04 19:59:52  rommel
 * Initial revision
 * 
 */

#ifndef _DAYTIME_H
#define _DAYTIME_H

typedef enum {TIME = 0, DAYTIME = 1, SNTP = 2} service;
typedef enum {UDP = 0, TCP = 1} protocol;

typedef struct
{
  int leap_ind : 2;
  int version  : 3;
  int mode     : 3;
}
flags;

typedef struct
{
  long integer;
  long fraction;
}
tstamp;

typedef struct
{
  flags flags;
  char stratum;
  char poll;
  char precision;
  long root_delay;
  long root_dispersion;
  long reference_id;
  tstamp reference_time;
  tstamp originate_time;
  tstamp receive_time;
  tstamp transmit_time;
  long authenticator[3];
}
sntp;

#endif /* _DAYTIME_H */

/* end of daytime.h */
