/* os.h
 *
 * Author:   <rommel@ars.de>
 * Created: Sat Apr 26 1997
 */
 
/* $Id: os.h,v 1.2 1997/05/04 13:39:04 rommel Exp rommel $ */

/*
 * $Log: os.h,v $
 * Revision 1.2  1997/05/04 13:39:04  rommel
 * added NT service code
 *
 * Revision 1.1  1997/04/26 14:21:54  Rommel
 * Initial revision
 * 
 */

#ifndef _OS_H
#define _OS_H

time_t get_date(char *p, void *now);
int stime(time_t *newtime);

#ifdef OS2

#ifdef __IBMC__

#define BSD_SELECT
#include <types.h>
#include <sys/select.h>

#define INCL_DOS
#include <os2.h>

#endif

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#ifdef __EMX__

#define psock_errno perror
#define soclose close
#define sock_init() 0

#endif

#endif

#ifdef WIN32

#include <windows.h>
#include <winsock.h>

#define soclose closesocket
int sock_init(void);
void psock_errno(char *text);

#define sleep(s) Sleep(1000 * s)

void run_as_service(char *name, int (*function)(void));
int started_as_service(void);
int install_as_service(char *name, int install);

int save_options(char *name, void *data, int size);
int restore_options(char *name, void *data, int size);

#endif

#endif /* _OS_H */

/* end of os.h */
