/* os.c
 *
 * Author:   <rommel@ars.de>
 * Created: Sat Apr 26 1997
 */
 
static char *rcsid =
"$Id: os.c,v 1.2 1997/05/04 13:39:04 rommel Exp rommel $";
static char *rcsrev = "$Revision: 1.2 $";

/*
 * $Log: os.c,v $
 * Revision 1.2  1997/05/04 13:39:04  rommel
 * added NT service code
 *
 * Revision 1.1  1997/04/26 14:21:54  Rommel
 * Initial revision
 * 
 */

#include <stdio.h>
#include <time.h>

#include "os.h"

#ifdef OS2

#define INCL_DOS
#include <os2.h>

int stime(time_t *newtime)
{
  struct tm *newtm = localtime(newtime);
  DATETIME dt;

  dt.hours   = newtm -> tm_hour;
  dt.minutes = newtm -> tm_min;
  dt.seconds = newtm -> tm_sec;
  dt.hundredths = 0;

  dt.day     = newtm -> tm_mday;
  dt.month   = newtm -> tm_mon + 1;
  dt.year    = newtm -> tm_year + 1900;
  dt.weekday = newtm -> tm_wday;

  dt.timezone = -1;

  return DosSetDateTime(&dt) != 0;
}

#endif

#ifdef WIN32

#include <windows.h>
#include <stdio.h>

int stime(time_t *newtime)
{
  struct tm *newtm = localtime(newtime);
  SYSTEMTIME dt;

  dt.wHour   = newtm -> tm_hour;
  dt.wMinute = newtm -> tm_min;
  dt.wSecond = newtm -> tm_sec;
  dt.wMilliseconds = 0;

  dt.wDay    = newtm -> tm_mday;
  dt.wMonth  = newtm -> tm_mon + 1;
  dt.wYear   = newtm -> tm_year + 1900;
  dt.wDayOfWeek = 0;

  return !SetLocalTime(&dt);
}

int sock_init(void)
{
  WSADATA wsaData; 
  return WSAStartup(MAKEWORD(1, 1), &wsaData);
}

void psock_errno(char *text)
{
  int rc = WSAGetLastError();
  printf("%s: error code %d\n", text, rc);
}

static char *szServiceName;
static int (*fnServiceFunction)(void);
static int nServiceRC;

static SC_HANDLE schService;
static SC_HANDLE schSCManager;
static SERVICE_STATUS ssStatus;
static SERVICE_STATUS_HANDLE sshStatus;
static HANDLE hEventTerminate;
static HANDLE hThread;

static void StopService(LPTSTR lpszMsg)
{
  HANDLE hEventSource;
  CHAR chMsg[256];
  LPCTSTR lpszStrings[2];
  DWORD dwError = GetLastError();

  sprintf(chMsg, "%s error: %d", szServiceName, dwError);
  lpszStrings[0] = chMsg;
  lpszStrings[1] = lpszMsg;

  if ((hEventSource = RegisterEventSource(NULL, szServiceName)) != NULL) 
  {
    ReportEvent(hEventSource, EVENTLOG_ERROR_TYPE, 0, 0, NULL, 2, 0, 
		lpszStrings, NULL);
    DeregisterEventSource(hEventSource);
  }

  SetEvent(hEventTerminate);
}

static BOOL ReportStatus(DWORD dwCurrentState, DWORD dwWin32ExitCode,
			 DWORD dwCheckPoint, DWORD dwWaitHint)
{
  BOOL fResult;

  if (dwCurrentState == SERVICE_START_PENDING)
    ssStatus.dwControlsAccepted = 0;
  else
    ssStatus.dwControlsAccepted = 
      SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_PAUSE_CONTINUE;

  ssStatus.dwCurrentState = dwCurrentState;
  ssStatus.dwWin32ExitCode = dwWin32ExitCode;
  ssStatus.dwCheckPoint = dwCheckPoint;
  ssStatus.dwWaitHint = dwWaitHint;

  if (!(fResult = SetServiceStatus(sshStatus, &ssStatus)))
    StopService("SetServiceStatus");

  return fResult;
}

static VOID CALLBACK ServiceControl(DWORD dwCtrlCode)
{
  DWORD dwState = SERVICE_RUNNING;

  switch(dwCtrlCode) 
  {

  case SERVICE_CONTROL_PAUSE:
    if (ssStatus.dwCurrentState == SERVICE_RUNNING) 
    {
      SuspendThread(hThread);
      dwState = SERVICE_PAUSED;
    }
    break;

  case SERVICE_CONTROL_CONTINUE:
    if (ssStatus.dwCurrentState == SERVICE_PAUSED) 
    {
      ResumeThread(hThread);
      dwState = SERVICE_RUNNING;
    }
    break;

  case SERVICE_CONTROL_STOP:
    dwState = SERVICE_STOP_PENDING;
    ReportStatus(SERVICE_STOP_PENDING, NO_ERROR, 1, 3000);
    SetEvent(hEventTerminate);
    return;

  case SERVICE_CONTROL_INTERROGATE:
    break;

  default:
    break;

  }

  ReportStatus(dwState, NO_ERROR, 0, 0);
}

static DWORD CALLBACK WorkerThread(LPVOID pArgs)
{
  nServiceRC = fnServiceFunction();
  return 0;
}

static void ServiceMain(DWORD dwArgc, LPTSTR *lpszArgv)
{
  DWORD nTID;

  ssStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
  ssStatus.dwServiceSpecificExitCode = 0;

  sshStatus = RegisterServiceCtrlHandler(TEXT("SimpleService"), ServiceControl);

  if (sshStatus)
  {
    if (ReportStatus(SERVICE_START_PENDING, NO_ERROR, 0, 0))
    {
      hEventTerminate = CreateEvent(NULL, TRUE, FALSE, NULL);

      if (hEventTerminate)
      {
	hThread = CreateThread(NULL, 0, WorkerThread, NULL, 0, &nTID);

	if (hThread)
	{
	  if (ReportStatus(SERVICE_RUNNING, NO_ERROR, 0, 0))
	    WaitForSingleObject(hEventTerminate, INFINITE);
	}

	CloseHandle(hEventTerminate);
      }
    }
  }

  ReportStatus(SERVICE_STOPPED, nServiceRC, 0, 0);

  return;
}

void run_as_service(char *name, int (*function)(void))
{
  SERVICE_TABLE_ENTRY dispatchTable[] = 
  {
    {TEXT(name), (LPSERVICE_MAIN_FUNCTION) ServiceMain},
    {NULL, NULL}
  };

  szServiceName = name;
  fnServiceFunction = function;

  if (!StartServiceCtrlDispatcher(dispatchTable))
    StopService("StartServiceCtrlDispatcher failed.");
}

int started_as_service(void)
{
  STARTUPINFO si;
  GetStartupInfo(&si);
  return (si.wShowWindow == 0);
}

int install_as_service(char *name, int install)
{
  char szPath[512];
  int rc = 0;

  GetModuleFileName(NULL, szPath, sizeof(szPath));

  schSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);

  if (install)
  {
    schService = CreateService(schSCManager, name, name, SERVICE_ALL_ACCESS, 
      SERVICE_WIN32_OWN_PROCESS | SERVICE_INTERACTIVE_PROCESS, 
      SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL, szPath, 
      NULL, NULL, NULL, NULL, NULL);

    if (!schService) 
      rc = GetLastError();
    else
      CloseServiceHandle(schService);
  }
  else
  {
    schService = OpenService(schSCManager, name, SERVICE_ALL_ACCESS);

    if (schService)
      if (!DeleteService(schService))
	rc = GetLastError();
  }

  CloseServiceHandle(schSCManager);

  return rc;
}

int save_options(char *name, void *data, int size)
{
  char keyname[512];
  HKEY key;
  DWORD rc;

  strcpy(keyname, "System\\CurrentControlSet\\Services\\");
  strcat(keyname, name);

  if ((rc = RegOpenKey(HKEY_LOCAL_MACHINE, keyname, &key)) != 0)
    return rc;
  rc = RegSetValueEx(key, "Parameters", 0, REG_BINARY, data, size);
  RegCloseKey(key);

  return rc;
}

int restore_options(char *name, void *data, int size)
{
  char keyname[512];
  HKEY key;
  DWORD rc, type, bytes;

  strcpy(keyname, "System\\CurrentControlSet\\Services\\");
  strcat(keyname, name);

  if ((rc = RegOpenKey(HKEY_LOCAL_MACHINE, keyname, &key)) != 0)
    return rc;
  bytes = size;
  rc = RegQueryValueEx(key, "Parameters", 0, &type, data, &bytes);
  RegCloseKey(key);

  return rc;
}

#endif

/* end of os.c */
