#ifndef _KWDOBMGR_
#define _KWDOBMGR_

#ifndef _KDOBMGR_
   #include <kdobmgr.hpp>
#endif

class IWindow;

struct KDobWinMgrEntry
{
   KDobWinMgrEntry(IWindow *win, IWindow *call)
     : window(win)
     , manager(new KDobManager(win, call))
     , caller(call)
   {
   }

   ~KDobWinMgrEntry()
   {
      delete manager;
   }

   Boolean operator <(KDobWinMgrEntry const &other)
   { 
      return window < other.window; 
   }   

   Boolean operator ==(KDobWinMgrEntry const &other) 
   { 
      return window == other.window;
   }

   IWindow *window;
   IWindow *caller;
   KDobManager *manager;
};


typedef KDobWinMgrEntry *KDobWinMgrPtr;

IWindow* const &key(KDobWinMgrPtr const &entry);

#endif

