#ifndef _KVALEXC_
  #define _KVALEXC_

#ifndef _IEXCBASE_
  #include <iexcbase.hpp>
#endif

class IWindow;

class KException: public IException 
{
  public:
    KException(const char* a, unsigned long b = 0,
        Severity c = IException::unrecoverable)
      : IException(a,b,c) {}
    virtual const char* name() const { return "KException"; }
    virtual ~KException() {}
    KException(const KException& exc)
      : IException(exc) {}
  private:
    operator = ( const KException& );
};

class KValidateException : public KException
{
  public:
    KValidateException(const IWindow *wnd = 0) : 
      KException("Invalid field", 0, IException::recoverable),
      _window(wnd) 
    {
    }

    KValidateException(const KValidateException &copy) :
      KException(copy) 
    {
    }

    virtual const char *name() const { return "KValidateException"; }
    virtual ~KValidateException() {}
    const IWindow *window() const { return _window; }

  private:
    operator =(const KValidateException &);
    const IWindow *_window;

};


class KRequiredException : public KException
{
  public:
    KRequiredException(const IWindow *wnd = 0) :
      KException("Invalid field", 0, IException::recoverable),
      _window(wnd) {}

    KRequiredException(const KRequiredException &copy) :
      KException(copy) {}

    virtual const char *name() const { return "KRequiredException"; }
    virtual ~KRequiredException() {}
    const IWindow *window() const { return _window; }

  private:
    operator =(const KRequiredException &);
    const IWindow *_window;

};


#define KTHROWREQUIRED(win)
#define KTHROWVALIDATE(win)

#endif
