#define INCL_PM
#include <os2.h>
#include <kpthdr.hpp>
#include <ireslib.hpp>
#include <ihandle.hpp>

KPointerHandler::KPointerHandler(IPointerHandle *hdl)
   : handle(0)
{
   if (hdl)
      handle = new IPointerHandle(*hdl);  
}

KPointerHandler &KPointerHandler::setPointer(ISystemPointerHandle::Identifier id)
{
   delete handle;
   handle = new ISystemPointerHandle(id);
   return (KPointerHandler &) *this;
}

KPointerHandler &KPointerHandler::setPointer(const IResourceId& resId)
{
   delete handle;
   IPointerHandle hdl = resId.resourceLibrary().loadPointer(resId.id());
   handle = new IPointerHandle(hdl);
   return (KPointerHandler &) *this;
}

IPointerHandle KPointerHandler::pointer() const
{
   return *handle;
}

KPointerHandler::~KPointerHandler()
{
   delete handle;
}

/*-----------------------------------------------------------------
  mouseMove:
  
  This function is invoked by dispatchHandlerEvent when a mouse 
  movement event is received (which occurs whenever the user 
  moves the mouse pointer over the window).  It uses the 
  Presentation Manger WinSetPointer function to change the shape
  of the mouse pointer while it is above the owning window.
---------------------------------------------------------------- */
Boolean KPointerHandler::mouseMove(IEvent &event)
{
   if (handle)
   {
      WinSetPointer(HWND_DESKTOP, *handle);
      return true;
   }
   else
      return false;
}

/*-----------------------------------------------------------------
  controlPointer:

  This function is invoked by dispatchHandlerEvent when a mouse 
  movement is received by a child control window.  
-----------------------------------------------------------------*/
Boolean KPointerHandler::controlPointer(IEvent &event)
{
   if (handle)
   {
      event.setResult(handle);
      return true;
   }
   else
      return false;
}

/*-----------------------------------------------------------------
  dispatchHandlerEvent:
  
  This function overrides IHandler::dispatchHandlerEvent,
  and is invoked whenever the handler object receives an event of
  any type.  When the event received is triggered by a WM_MOUSEMOVE
  message, this function invokes the mouseMove member function
----------------------------------------------------------------- */
Boolean KPointerHandler::dispatchHandlerEvent(IEvent &event)
{
   switch(event.eventId())
   {
      case WM_MOUSEMOVE:
         return mouseMove(event);

   //   case WM_CONTROLPOINTER:
   //      return controlPointer(event);

      default:
         break;
   }
   return false;
}


