#ifndef _KACTHDR_
  #define _KACTHDR_

#ifndef _IFRAMHDR_
   #include <iframhdr.hpp>
#endif

#ifndef _IFRAMEVT_
  #include <iframevt.hpp>
#endif

#ifndef _IWINDOW_
   #include <iwindow.hpp>
#endif

#ifndef _IFRAME_
   #include <iframe.hpp>
#endif

#ifndef _IHANDLE_
  #include <ihandle.hpp>
#endif

#pragma pack(4)

class KActionHandler : public IFrameHandler
{
   public:
      KActionHandler(IWindow* win, void* data)
         : callerData(data)
      {
         if (win)
           caller = win->handle();
      }

   protected:
      // destructor is protected to prevent objects
      // from being created on the stack
      ~KActionHandler() {}
      Boolean closed(IFrameEvent &event)
      {
        IFrameWindow* frame = (IFrameWindow*) event.window();
        Boolean result = (frame->result() != 2);
        if (caller.isValid())
          caller.postEvent(KW_ACTION_COMPLETE, result, callerData);
        delete this;
        return false;
      }

   private:
      IWindowHandle caller;
      void*         callerData;
};

#pragma pack()

#endif
