#ifndef _KVALDATE_
#define _KVALDATE_

#ifndef _KVALMASK_
   #include <kvalmask.hpp>
#endif

#ifndef _ISTRING_
   #include <istring.hpp>
#endif

/*----------------------------------------------------------------------
 * Class: KDateValidator
 *
 * Implementation File: kvalid.cpp
 *
 * Base Class: Derived from KValidator
 *
 * Purpose: Allows the user to enter date values in an entry field.
 *
 * Notes:
 *--------------------------------------------------------------------*/
class _Export KDateValidator : public KMaskValidator
{
   public:
      KDateValidator();

   protected:
      Boolean isValid(const char *text, Boolean fill=false) const;

   private:
      struct Settings
      {
         Settings();
         IString mask;
         IString separator;
         unsigned dayPos;
         unsigned monthPos;
         unsigned yearPos;
      };
      static Settings settings;
};



#endif
