#define INCL_PM
#include <os2.h>
#include <kvalid.hpp>
#include <ikeyevt.hpp>
#include <kentryfd.hpp>
#include <istring.hpp>
#include <istrtest.hpp>
#include <ctype.h>
#include <iexcept.hpp>

KValidator::KValidator(Boolean val) 
  : validateContentOnChar(val)
{
}

KValidator::~KValidator() 
{
}

Boolean KValidator::characterKeyPress(IKeyboardEvent& event)
{

   // first check that the character itself is valid.  If any 
   // character not in the set allowed by the test member function
   // is found, the character is invalid.
   IString character(event.mixedCharacter());
   if (character.indexOfAnyBut(IStringTestMemberFn<KValidator>(*this, test)))
   {
      error();
      return true;
   }

   // simple validation doesn't require checking the format of 
   // field content on each character 
   if (!validateContentOnChar)
      return false;

   // save the current content of the entry field
   KEntryField *field = (KEntryField*)event.window();
   IString originalContent = field->text();

   // pass the event on to the control
   field->disableUpdate();
   defaultProcedure(event);

   // get the new field content and validate it
   Boolean invalid;
   IString newContent = field->text();
   if (!isValid(newContent))
   {
      error();
      invalid = true;
   }
   else
   {
      invalid = false;
   }
   
   // reset the content to allow other handlers to filter the
   // event if necessary
   field->setText(originalContent);
   field->enableUpdate();

   return invalid;
}

Boolean KValidator::virtualKeyPress(IKeyboardEvent& event)
{
   // simple validation doesn't require checking the format of 
   // field content on each character 
   if (!validateContentOnChar)
      return false;

   KEntryField *field = (KEntryField*)event.window();
   unsigned long ulKey = event.virtualKey();
   Boolean filtered = false;

   if (ulKey == IKeyboardEvent::backSpace || ulKey == IKeyboardEvent::deleteKey)
   {
      IString originalContent = field->text();
      field->disableUpdate();
      defaultProcedure(event);
      IString newContent = field->text();
      if (!isValid(newContent))
      {
         filtered = true;
         error();
      }
      field->setText(originalContent);
      field->enableUpdate();
   }
   return filtered;
}

void KValidator::error()
{
   WinAlarm(HWND_DESKTOP, WA_ERROR);
}

Boolean KValidator::isValid(const char *text, Boolean) const
{
   return !IString(text).indexOfAnyBut(
                 IStringTestMemberFn<KValidator>(*this, test));
}

Boolean KValidator::test(int) const
{
   return true;
}

IString &KValidator::fill(IString &text)
{
  return text;
}

IString &KValidator::strip(IString &text)
{
  return text;
}

KAlphaValidator::KAlphaValidator()
  : KValidator(false)
{
}

Boolean KAlphaValidator::test(int c) const
{
   return(isalpha(c) || c == ' ');
}


KNumericValidator::KNumericValidator()
  : KValidator(true)
  , allowSign(true)
{
}

void KNumericValidator::enableSign(Boolean val)
{
   allowSign = val;
}

void KNumericValidator::disableSign()
{
   enableSign(false);
}

Boolean KNumericValidator::isValid(const char *text, Boolean fill) const
{
   IString string(text);
   Boolean valid = false;

   valid = Inherited::isValid(string, fill);
   if (allowSign)
   {
      if (valid && string.indexOf('-') > 1)
          valid = false;
   }
   return valid;
}

Boolean KNumericValidator::test(int c) const
{
   if (isdigit(c))
      return true;
   if (allowSign && c == '-')
      return true;
   return false;
}


KAlphaNumericValidator::KAlphaNumericValidator()
  : KValidator(false)
{
}

Boolean KAlphaNumericValidator::test(int c) const
{
   return(isalnum(c));
}

KRealValidator::KRealValidator()
  : KValidator(true)
{
}

Boolean KRealValidator::isValid(const char *text, Boolean fill) const
{
   // check for valid characters
   if (!Inherited::isValid(text,fill))
      return false;

   // then check the format
   int nCount = 0, nDigitFound = 0;
   if(text[nCount] == '+' || text[nCount] == '-')
      nCount++;

   while((text[nCount] != 0x00) &&
         (text[nCount] != '.') &&
         (toupper(text[nCount]) != 'E') &&
         (toupper(text[nCount]) != 'D'))
   {
      if(isdigit(text[nCount]))
      {
         nCount++;
         nDigitFound = 1;
      }
      else
         return false;       
   }

   if(text[nCount] == '.')
   {
      nCount++;
      while(text[nCount] != 0x00 &&
            toupper(text[nCount]) != 'E' &&
            toupper(text[nCount]) != 'D')
      {
         if(isdigit(text[nCount]))
         {
            nCount++;
            nDigitFound = 1;
         }
         else
            return false;       
      }
   }

   if(text[nCount] == 0x00)
      return true;
   if(!nDigitFound)
      return false;
 
   nCount++;

   if(text[nCount] == '+' || text[nCount] == '-')
      nCount++;

   while(text[nCount] != 0x00)
   {
      if(isdigit(text[nCount]))
         nCount++;
      else
         return false;       
   }

   return true;
}

Boolean KRealValidator::test(int c) const
{
   return (isdigit(c) 
           || c == '.'
           || c == '-'
           || c == '+'
           || toupper(c) == 'E'
           || toupper(c) == 'D');
}



