#ifndef _KDIRLST_
  #define _KDIRLST_

#ifndef _ILISTBOX_
  #include <ilistbox.hpp>
#endif

#ifndef _KLSTHDR_
  #include <klsthdr.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

class _Export KDirListBox : public IListBox
                          , public KListHandler
{
  public:
    KDirListBox(unsigned long windowId, 
                 IWindow *parentWin, 
                 IWindow *ownerWin, 
                 const IRectangle &rect=IRectangle(),
                 const char *files = "*.*",
                 ITextControl *targetWin=0,
                 const IListBox::Style &style=defaultStyle())
      : IListBox(windowId, parentWin, ownerWin, rect, style)
      , KListHandler(targetWin)
      , spec(files)
    {
      KListHandler::handleEventsFor(this);
    }

    Boolean fill();
    const char *fileSpec() const { return spec; }
    KDirListBox &setFileSpec(const char *fileSpec) { spec = fileSpec; return *this; }

  protected:
    virtual Boolean enter(IControlEvent &event);

  private:
    IString                        spec;
};

#endif

