/*
    REXX SCRIPT FILE
*/

COPYRIGHT = "PAGER V1.0 by I&J Solutions, Created 07-02-95"

/*

This script file will parse the messages listed in the INBOX and based on some filters will
call specified pager number with certain code.

The name of the program that calls the pager is tcomm.exe and is part of the MLP package.

The correct way to use that program is:

        tcomm /com:2 /exit:30 /dial:1234567,,,,,,09877
                                                 ^^^^^-> Code for the pager
                                           ^^^^^^-> delay for the modem
                                    ^^^^^^^-> the number for the pager
                               ^^^^->stuff that follows after ATDT command.
                           ^^-> 30 secunds delay before closing the com port
                      ^^^^-> after dialing the number close the com port and exit
                    ^-> use COM2
               ^^^->specify com port (default is COM2)


----------------------

This script file requires a special configuration file (pager.cf) which 
would keep some keys and pager parameters. The configuration file is 
organized as a table with the following fields:

SENDER;SUBJECT;PAGER;CODE


The logic is the following:

If SENDER or SUBJECT matches the PAGER number will be dialed and CODE will be sent to the pager.
The mail message will be forwarded to pager@site and deleted from the InBox folder.

EXAMPLE:

pager.cf
--------
jivko;page me;123-4567;9999

when e-mail from jivko@any.site is received addressed to the mailing list or E-mail with
Subject: ... page me ... is received addressed to the same list the pager number 123-4567
will be dialed and code 9999 will be sent to the pager.

*/



call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg message_file extra

say COPYRIGHT

debug=0
config = pager.cf
PAGERTMP = pager.tmp    /* temporary file for the pager.cmd script         */
COMAS = ",,,,,,,"       /* This should be enough for most pagers           */
EXITDELAY=25            /* 20 secunds delay should be enough for the modem */
                        /* to dial the pager and enter the code using the  */
                        /* above number of comas                           */

/****************************************************************************/

if "" = message_file then
  exit
else do

    MESSAGE_PATH = filespec('drive',message_file)""filespec('path',message_file)
    message = filespec('name',message_file)
    if debug then say "Message directory: "MESSAGE_PATH
    done = 0
    move = 0
    mfile = MESSAGE_PATH""message
    if debug then say "Checking "mfile
    do while lines(mfile) & (done = 0)
      cl2 = strip(linein(mfile))

      done1 = 0

      /* Check for the end of the header */
      /* If the end of the header we have all the information we might need so we should go and */
      /* search the configuration file for matches.                                             */
      if (0 = length(cl2)) then do

        /* Open the configuration file and check it out */
         do while lines(config) 
           cl1 = strip(linein(config))

           /* Skip comments */

           if 1 <>pos("#",cl1) then do
              coma1 = pos(";",cl1)
              sender = substr(cl1,1,coma1-1)
              if debug then say "Sender = "sender
              coma2 = pos(";",substr(cl1,coma1+1))
              subj= substr(cl1,coma1+1,coma2-1)
              if debug then say "Subject= "Subject
              coma3 = pos(";",substr(cl1,coma1+coma2+1))
              Pager= substr(cl1,coma1+coma2+1,coma3-1)
              if debug then say "pager= "Pager
              coma4 = pos(";",substr(cl1,coma1+coma2+coma3+1))
              Code = substr(cl1,coma1+coma2+coma3+1)
              if debug then say "code= "Code

              /* Now we have one record read already and we could check it out */

              if 0<pos(sender,From) | 0<pos(subject,Subj) then do

                 /* there is a match and we should beep that pager now */

                 sh = '@tcomm /com:'COMPORT' /exit:'EXITDELAY' /dial:'Pager''COMAS''CODE
                 if debug then say sh
                 else sh

                 /* OK. We did what we had to do with the pager. Now we need to forward that */
                 /* message to pager@site and delete the original file                       */

                 rc=stream(mfile,'c','close')

                 /* Prepare a header for tha message */

                 host = value('HOSTNAME',,'OS2ENVIRONMENT')
                 rc=lineout(PAGERTMP,"From: Pager.CMD@"host)
                 rc=lineout(PAGERTMP,"To: Pager@"host)
                 rc=lineout(PAGERTMP,"Subject: Re: Message that made me page you")
                 rc=lineout(PAGERTMP,"")
                 rc=lineout(PAGERTMP,"")

                 do while lines(mfile) & (done = 0)
                   cl2 = linein(mfile)
                   rc=lineout(PAGERTMP,cl2)
                 end
                 rc=stream(mfile,'c','close')
                 rc=stream(PAGERTMP,'c','close')

                 sh= '@sendmail -af 'PAGERTMP' pager@'host
                 if debug then say sh
                 else sh

                 '@del 'mfile
                 '@del 'PAGERTMP
              end  /* Do */

           end
         end /* do */
         rc=stream(config,'c','close')

         done = 1
      end

      /* If this is the From: filed get store that line */
      if (1 = pos("From:",cl2)) then do
         From = substr(cl2,6)
      end

      /* If this is the SUBJECT: filed get store that line */
      if (1 = pos("Subject:",cl2)) then do
         Subject = substr(cl2,9)
      end


  end /* do */

exit

