/* REXX */
/* CCT, Inc. / POB 3350 / Sedona, AZ 86340 / 520-646-0331 */
/* Rewritten by Pat Martini */
/* send questions/comments to cct@sedona.net */
/* CCTDIAL.CMD - An adaptation of the original OS/2 Warp Rexx file which was */
/*      Written by: Don Russell (c) April 1995 */
/*      send email to drussell@direct.ca */
/* Portions Copyright (c)June 1995 - CCT, Inc. */
 
/* v1.2 */

/* NOTE: All text-type user parameters are to be entered between */
/*   two single quotes: '' (do not use double quotes: ") */

/* ------------------------------------Change the next (3) entries ------------------------------------- */
/* k1 - Fill-in your provider's phone number after the ATDT(add area code if nec.) */
/* k2 - Fill-in your user ID name (and any provider-required prefix if necessary) */
/* k3 - Fill-in your password */
/*       ---or---       */
/* Remove all but the quote marks and send the parameters via the Login        */
/* Sequence on Page 1 of the Modify Entries Settings Notebook as follows:     */
/*	cctdial.cmd ATDTxxx-xxxx userid password			        */
/* Substitute your provider's phone number and your userid and password.      */
/* The latter method may be used when more than one provider is configured. */
/* You may also use multiple iterations of this file for individual connections       */
/* with separate Entries in the Dialer, calling a particular CCTDIALx.CMD .          */

k1 = 'ATDTxxx-xxxx'	/* phone number to call your PPP provider */
k2 = 'userid'		/* your userid. (include 'special' chars like %p) */
k3 = 'password'		/* your case-sensitive password */

/* ------------------Change the Connect Parameters Only if Necessary------------------- */

timeout = 60		/* max # seconds to wait for connect */
promptwait = 30		/* max # seconds to wait for prompts */
pause = 4		/* max # seconds to wait between redials */
maxtry = 5		/* max # tries to connect before program abort */
audible = 1		/* audible beeps - 0=no / 1=yes */

/* -------------------Change Modem Specific Codes Only if Necessary------------------- */

ModemResetCommand = 'ATH0Z'	/* modem hangup and reset */
modemwait = 15	/* max # seconds to wait for modem response codes */

/* --------------------------------------Custom Access Variables------------------------------------ */

k4 = ''		/* ATDT + secondary access number */

prompt3 = ''	/* Additional prompt sent by network or provider (3rd) */
response3 = ''	/* Your response for above prompt */
/* NOTE: You may enter crlf *without single quotes* if response is Enter key */

p3pos = 1	/* Prompt3 position - ONLY 1 or 3 is valid (first or third prompt) */
/* the above determines if the 1st custom prompt arrives before (1) or after (3) the */
/* ID and password prompts - eg:a network access prompt may come before (1) */

/* --this may be weird and esoteric - but somebody really needed it!-- */
prompt4 = ''	/* Additional prompt sent by network or provider (4th) */
response4 = ''	/* Your response for above prompt */
p4pos = 4	/* Prompt4 position - ONLY 2 or 4 is valid here (second or fourth) */
/* the above determines if the 2nd custom prompt arrives directly after (2) the 1st */
/* custom prompt (p3pos=1 / both before userid and password) or the last (4) */
/* prompt to arrive (p3pos=1 or 3 / this one will be the very last) */
/* NOTICE: Improper prompt position parameters or setting a 4th prompt without */
/* first setting the 3rd prompt will generate an error and abort this program */

/* ================================================================= */
/* =========DO NOT CHANGE ANYTHING AFTER THIS POINT=========== */
/* ================================================================= */

/* some setup / valid parameter stuff */

LoginPrompt = 'ogin:'			/* look for part of login */
PasswordPrompt = 'ssword:'		/* look for part of password */

if k4 \='' then do				/* set altcall flag if second number */
    altcall=1
    numflip=0				/* set numflip flag for first number flip */
end
else do
    altcall=0
end
if prompt3 \='' then do			/* set addprompt3 flag if 3rd prompt */
    if ((p3pos \=1) & (p3pos \=3)) then do
      call lineout,'ERROR  : Prompt3 Position Must be 1 or 3!'
      call errout
    end
    else do
      addprompt3=1
    end
end
else do
    addprompt3=0
end
if prompt4 \='' then do			/* set addprompt4 flag if both prompts */
    if ((p4pos \=2) & (p4pos \=4)) then do
      call lineout,'ERROR  : Prompt4 Position Must be 2 or 4!'
      call errout
    end
    if addprompt3=1 then do
      addprompt4=1
    end
    else do
      call lineout,'ERROR  : Invalid Custom Prompt4 Setting!'
      call errout
    end
end
else do
    addprompt4=0
end

call rxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* check that PPP connection is selected */

if RxFuncQuery( 'ppp_com_input' ) = 1 then do
   if RxFuncQuery( 'slip_com_input' ) = 0 then do
      call lineout ,'This script is for PPP only.'
      call lineout ,'Your dialer is set for SLIP.'
      call lineout ,'Change your dialer and try again.'
      call sysSleep 60
      exit 0
   end  /* Do */
   
   call NotFromDialer
   exit 0
end  /* Do */

parse arg interface , port , . , dialcmd , username , password

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COMM strings */
cr='0d'x
crlf='0d0a'x

/* Setup primary variables */
if dialcmd = '' | dialcmd = '*' then do
   dialcmd = k1
end
if username = '' | username = '*' then do
   username = k2
end
if password = '' | password = '*' then do
   password = k3
end  /* Do */

pwlen=length(password)

/* Begin active code / show header */

call charout,crlf
call lineout ,'CCT, Inc. CCTDIAL.CMD REXX Script for OS/2'
call lineout, '            cct@sedona.net'
call lineout,'  <Timeout='timeout' Wait='promptwait' Pause='pause' Tries='maxtry'>'
call sysSleep 2

call charout,'Dial Attempt #1 - '
call flush_receive	/* Flush any stuff left over from previous COMM activity */

call ResetModem	/* Issue the ModemResetCommand */

FirstTime = 1		/* First dial attempt */
connected = 0		/* Not yet connected */
do count = 1 by 1 until connected		/* Increment count variable on each try */
    if count = maxtry+1 then do	/* Abort if max try setting reached (+initial try) */
       call lineout,'Maximum of' maxtry 'Tries Reached - Aborting...'
       call errout
    end
    if \FirstTime then do
       call charout,crlf
       call lineout ,'CCT, Inc. CCTDIAL.CMD REXX Script for OS/2'
       call lineout, 'Waiting 'pause' Seconds Before Try #'count
       call sysSleep pause			/* wait for redial attempt */
       call charout,crlf
    end  /* Do */
    FirstTime = 0				/* reset flag */

    /* Dial the remote server */
    call charout , 'Dialing...'

    /* Wait for connection */
    if ((altcall=1) & (numflip=1)) then do	/* test for and use secondary number */
      call send k4 || cr
      numflip=0				/* reset flag */
    end
    else do
      call send dialcmd || cr		/* use primary number */
      if altcall=1 then do			/* flip flag if necessary */
        numflip=1
      end
    end

    ringing:
    ResultCode = getresult( timeout )
    if left( ResultCode, 4 ) = 'RING' then
       signal ringing
    if left( ResultCode, 4 ) = 'BUSY' then
       iterate
    if left( ResultCode, 5 ) = 'ERROR' then
       exit 0
    if left( ResultCode, 7 ) \= 'CONNECT' then do
       call recycle				/* clean up and restart */
       iterate
    end

    /* prompt for a login id/password... :-(                   */

   if ((addprompt3=1) & (p3pos=1)) then do	/* check for custom 1st prompt */
     call CustPrompt3
     if ((addprompt4=1) & (p4pos=2)) then do	/* check for custom 2nd prompt */
       call CustPrompt4
     end
   end

   call waitfor LoginPrompt, promptwait	/* # seconds to wait for Login: prompt */
   if result = 1 then do
      call lineout , 'Host is not responding.'
      call recycle
      iterate
   end  /* Do */
   
   call send username || cr		/* send userid to server */

   call waitfor PasswordPrompt, promptwait	/* wait for Password: prompt */
   if result = 1 then do
      call lineout , 'Host is not asking for password.'
      call recycle
      iterate
   end  /* Do */
   
   call send password || cr		/* send password to server */

   do ast = 1 by 1 until ast=pwlen		/* show stars */
     call charout, '*'
   end
   call lineout, crlf

   if ((addprompt3=1) & (p3pos=3)) then do	/* check for custom 3rd prompt */
     call CustPrompt3
   end
   if ((addprompt4=1) & (p4pos=4)) then do	/* check for custom 4th prompt */
     call CustPrompt4
   end

   connected = 1				/* we are successfully connected  */
end					/* end main loop */

if audible then do
    call beep 400, 200			/* Audible connect confirmation */
    call beep 450, 150
end

exit 0					/* goodbye - our humble job is done */

/* ----------------------------------------------Subroutines---------------------------------------------- */

/* routine for custom prompts */

CustPrompt3:
    call waitfor prompt3, promptwait	/* go wait for it to come */
    call NoPrompt
    call send response3 || cr		/* send custom prompt response */
return

CustPrompt4:
    call waitfor prompt4, promptwait	/* go wait for prompt4 */
    call NoPrompt
    call send response4 || cr
return

NoPrompt:
    if result = 1 then do
      call lineout, 'Host has not sent custom prompt.'
      call recycle
      iterate
    end
return

/* Modem reset routine */

ResetModem:
   call lineout , 'Resetting modem...'
   call send ModemResetCommand || cr
   ResultCode = getresult( modemwait )
   if left(ResultCode , 2) \= 'OK' then do
       call lineout , 'Modem not resetting... Trying again'
       call sysSleep 2
       call send '+++'
       call waitfor crlf, 5
       call send ModemResetCommand || cr
       call getresult 10
   end
    /* call flush_receive 'echo' */
return

/* Routine to clear buffer, reset modem and flags for restart */

recycle:
  if audible then do
   call beep 200, 300
  end
   call flush_receive
   call ResetModem
   connected = 0
return

/* Routine for error exit */

errout:
   if audible then do
     call beep 250, 250
     call beep 200, 300
   end
     exit 1
return

/* Routine to send a modem command */

send:
   parse arg AtCmd
   call flush_receive
   call ppp_com_output interface , AtCmd
return


/*--------------------------------------------------------------------------*/
/*                    getresult( [waitout] )                                */
/*                                                                          */
/* Waits for any modem response, and returns the string.    */

/* If waitout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

getresult:
   parse arg waitout
   call waitfor crlf, waitout
   if result = 0 then
      call waitfor crlf, waitout
   if result = 1 then /* timed out */
      return '*timedout*'
   else
      return waitfor_buffer


/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [waitout] )                    */
/*                                                                          */
/* Waits for a specific string from the modem. */

waitfor:

   parse arg waitstring , waitout

   if waitout = '' then do
      waitout = 90    /* 1.5 minutes if delay not specified */
   end

   waitfor_buffer = ''
   done = -1
   curpos = 1

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   call time 'E'
   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = ppp_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (time('E')>waitout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end

 return done

/*--------------------------------------------------------------------------*/
/*                             flush_receive()                             */
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Read anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = ppp_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return

NotFromDialer:
    parse upper source . . MyDrivePathName
    MyDrive = filespec( 'D', MyDrivePathName )
    MyPath = filespec( 'P', MyDrivePathName )
    MyDrivePath = MyDrive || MyPath

    etcDrivePath = translate( value( 'etc',,'OS2ENVIRONMENT') )
    binDrive = filespec( 'D', etcDrivePath )
    binPath = filespec( 'P', etcDrivePath ) || 'BIN\'
    binDrivePath = binDrive || binPath

    EraseFile = 0
    if binDrivePath \= MyDrivePath then do
        say 'This script will be moved to' binDrivePath
        say 'Do you wish to continue? (y/n)'
        say '(Saying no will still show help)'
        answer = translate( sysGetKey( 'ECHO' ) )
        if answer = 'Y' then do
            'COPY' MyDrivePathName binDrivePath
            if rc = 0 then do
               say MyDrivePathName 'will be erased after displaying help'
               EraseFile = 1
            end
           '@PAUSE'
           call sysCls
        end /* Do */
    end  /* Do */

    call sysCls
    stop = 0
    do i = 3 by 1 until stop
       x = sourceline( i )
       if left( x, 5 ) = 'pause' then do
          '@PAUSE'
          call sysCls
          iterate
       end  /* Do */
       
       if left( x, 4 ) \= 'stop'  then
          say x
       else
          stop = 1
    end /* do */
    '@PAUSE'
    if EraseFile then
        'ERASE' MyDrivePathName
return
