program string_stripper_mania;

(* This liltle proggy is my first, and what it does is it searches the index file of e-mail
messages of PMMail 1.5 and strips out any attachement's (uucode or base64) data from it, but
leaving the filename for future reference.  Copyright 1996 Samuel Audet <guardia@cam.org>
distribute freely! *)

uses strings,dos;

var bag       : text;
    temp      : array[0..400] of char;  (* Can be enlarged if an entry in folder.bag is too long. *)
    statpos   : pchar;
    filepos   : pchar;
    index     : word;
    filename  : array[0..11] of char;

procedure strip(sup_file : string); (* da file stripper, case mania *)

var temp     : string;  (* <- This stores a line of text of a message, max 255 columns. If you *)
    unstrip  : text;    (* need more you can try to put an array[0..number_you_like] of char *)
    strip    : text;
    mode     : byte;
    name     : namestr;
    garbage  : string;

begin
   assign(unstrip,sup_file);                  (* renames the original file to *.bak and opens *)
   fsplit(sup_file,garbage,name,garbage);     (* for writing to the original name *)
   {$I-} rename(unstrip,name + '.bak'); {$I+}
   case ioresult of
      2: begin writeln('Error: message file does not exist'); exit; end;
      5: begin
            assign(unstrip,name + '.bak');
            erase(unstrip);
            assign(unstrip,sup_file);
            rename(unstrip,name + '.bak');
         end;
   end;
   assign(strip,sup_file);
   reset(unstrip);
   rewrite(strip);

   mode := 0;
   while not eof(unstrip) do         (* mode 0 = storing, no string search *)
   begin                             (* mode 1 = no storing, searching end string of base64 *)
      readln(unstrip,temp);          (* mode 2 = no storing, searching end string of uucode *)
      case mode of
         1: if pos('--',temp) = 1 then begin mode := 0; writeln (strip,temp); end;
         2: if pos('end',temp) = 1 then begin mode := 0; writeln (strip,temp); end;
         0: begin
               if pos('Content-Transfer-Encoding: base64',temp)
                  or pos('Content-Transfer-Encoding: BASE64',temp) = 1 then
               begin
                  mode := 1;
                  writeln(strip,temp);
                  writeln(strip,'');
               end else
               if pos('begin 6',temp) = 1 then
               begin
                  mode := 2;
                  writeln(strip,temp);
                  writeln(strip,'');
               end else
                  writeln(strip,temp);
            end;
      end;
   end;
   close(unstrip);
   close(strip);
   erase(unstrip);         (* clears the backup *)
end;

begin
   Writeln('PMMail 1.5 util, Strip Attachements  Copyright 1996 Samuel Audet');
   assign(bag,'folder.bag');
   {$I-} reset(bag); {$I+}
   if ioresult <> 0 then begin writeln('Error: folder.bag does not exist in the current directory'); exit; end;

   while not eof(bag) do begin
      readln(bag, temp);                        (* This part searches the index, folder.bag and *)
      statpos := strscan(temp, chr(222)) + 1;   (* will indicate which file has attachements. *)
      if statpos^ = '1' then begin              (* Check how that nifty position routine down *)
         filepos := strrscan(temp, chr(222));   (* there is *)
         index := 0;
         repeat
            dec(filepos);                       (* position routine finder *)
            inc(index);
            if filepos <= statpos then begin writeln ('Error: bad entry in folder.bag'); exit; end;
         until filepos^ = chr(222);
         if filepos > statpos then begin
            filename := '            ';
            strmove(filename,filepos + 1,index - 1);  (* This copies filename data to a array of *)
            writeln(filename);                        (* chars starting at the position found. *)
            strip(filename);
         end;
      end;
   end;
   close(bag);
end.
