program status_changer;

(* This proggy changes the status of all messages in a current PMMail 1.5 message directory to
'sent'.  Useful when rebuilding the index of the Sent Mail folder or migrating it from
PMMail 1.1 where PMMail 1.5 gives the messages the 'read' status.  Copyright 1996 Samuel Audet
<guardia@cam.org>   distribute freely! *)

uses strings;

const bagname = 'folder.bag';
      bakname = 'folder.bak';

var bag      : text;
    tmp_file : text;
    statpos  : pchar;
    temp     : array[0..400] of char;  (* Enlarge if an entry of folder.bag is bigger. *)
    filename : string;

begin
   Writeln('PMMail 1.5 util, Sent Status Changer  Copyright 1996 Samuel Audet');
   assign(bag,bagname);             (* Renames the original folder.bag to folder.bak, and *)
   {$I-} rename(bag,bakname); {$I+} (* opens writing to folder.bag. *)
   case ioresult of
      2: begin writeln('Error: ' + bagname + ' does not exist in the current directory'); halt; end;
      5: begin
            assign(bag,bakname);
            erase(bag);
            assign(bag,bagname);
            rename(bag,bakname);
         end;
   end;
   assign(tmp_file,bagname);
   reset(bag);
   rewrite(tmp_file);

   while not eof(bag) do
   begin
      readln(bag,temp);
      statpos := strscan(temp,chr(222));
      if statpos = nil then writeln('Error: bad entry in ' + bagname) else
         begin
            statpos := statpos - 1;
            statpos^  := '3';           (* change the current message status to 'sent' *)
            writeln(tmp_file,temp);
         end;
   end;

   close(bag);
   close(tmp_file);
   erase(bag);
end.
