/*********************************************************************/
/* DMI IRC REXX Command Script for REXX Clients.  v1.25   26 Sep 96  */
/*********************************************************************/
/* Alias Management Functions                             26 Sep 96  */
/*********************************************************************/

Alias:
   Parse Upper Arg WinHandle WinName OurNick Verb Action AliasName AliasText
   Parse Arg xWinHandle xWinName xOurNick xVerb xAction xAliasName xAliasText

   Pool = 'OS2ENVIRONMENT'
   CMD = Value('COMSPEC',, Pool)
   ErrStr = '*[Error]*'
   DMIMsg = '*DMI*'
   DataDir = Value('DataDir',, Pool)
   AliasList = DataDir || 'Aliases.Lst'
   
   SIGNAL ON SYNTAX
   Select
      When (Action == 'ADD') then do
         Stream(AliasList, 'C', 'SEEK <0')  /* Go to End of File */
         IF (Pos('/', AliasName) \= 1) then AliasName = '/'AliasName
         LineOut(AliasList, AliasName xAliasText)
         IrcRexxDisplay(DMIMsg 'Alias Added: ' || AliasName'.', WinHandle)
         LineOut(AliasList)
      end
      When (Action == 'DEL') then do
         Drop TempStem.
         TempNum = 0
         Stream(AliasList, 'C', 'CLOSE')
         IF (Pos('/', AliasName) \= 1) then AliasName = '/'AliasName
         do while Lines(AliasList)
            TempLine = LineIn(AliasList)
            Parse upper var TempLine TempName TempText
            If (IrcRexxWildCard(AliasName, TempName) == 'MATCH') then
               IrcRexxDisplay(DMIMsg 'Alias deleted: ' || xAliasName, WinHandle)
            else do
               TempNum = TempNum + 1
               TempStem.TempNum = TempLine
            end
         end
         LineOut(AliasList)
         CALL Library
         rc = SysFileDelete(AliasList)
         LineOut(AliasList)
         do TempNum2 = 1 to TempNum
            LineOut(AliasList, TempStem.TempNum2)
         end
         LineOut(AliasList)
      end
      When (Action == 'LIST') then do
         IrcRexxDisplay('Current Alias list:', WinHandle)
         IrcRexxDisplay('~~~~~~~~~~~~~~~~~~~', WinHandle)
         if ((SysFileSearch('/', AliasList, 'Temp.') = 0) & (Temp.0 > 0)) then do
            TempCount = 0
            TempStr = ''
            do until TempCount >= Temp.0
               TempCount = TempCount + 1
               parse var Temp.TempCount AliasName dummy
               TempStr = TempStr Left(AliasName, 8)
               If (TempCount // 5 = 0) then do
                  IrcRexxDisplay(TempStr, WinHandle)
                  TempStr = ''
               end
            end
            IrcRexxDisplay(TempStr, WinHandle)
         end
         else
            IrcRexxDisplay('No aliases defined.', WinHandle)
         LineOut(AliasList)
      end
      When (Action == 'VLIST') then do
         IrcRexxDisplay('Current Alias list:', WinHandle)
         IrcRexxDisplay('~~~~~~~~~~~~~~~~~~~', WinHandle)
         IrcRexxDisplay('Name     Text', WinHandle)
         IrcRexxDisplay('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~', WinHandle)
         do while Lines(AliasList)
            TempLine = LineIn(AliasList)
            Parse var TempLine TempName TempText
            IrcRexxDisplay(Left(TempName, 8) TempText, WinHandle)
         end
         LineOut(AliasList)
      end
      otherwise IrcRexxDisplay(ErrStr 'Usage: /ALIAS <Option> [Name] [Text]', WinHandle)
   end
   Return ''

library:
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
Return

SYNTAX:
   IrcRexxDisplay(ErrStr 'REXX Syntax Error' RC '(' || ErrorText(RC) || ') at line' SIGL 'of Alias.Cmd.', WinHandle);
Return ''

