
/*
 *           PVM 3.2:  Parallel Virtual Machine System 3.2
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.2 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	pvmdabuf.c
 *
 *	Data buffer manip.
 *
$Log: pvmdabuf.c,v $
 * Revision 1.1  1993/08/30  23:26:50  manchek
 * Initial revision
 *
 */

#include "protoglr.h"
#include "pvmalloc.h"


/***************
 **  Private  **
 **           **
 ***************/

static char rcsid[] = "$Id: pvmdabuf.c,v 1.1 1993/08/30 23:26:50 manchek Exp $";


char *
da_new(len)
	int len;
{
	char *p;

	if (p = TALLOC(len + 16, char, "data")) {
		p += 16;
		*(int*)(p - sizeof(int)) = 1;
	}
	return p;
}


void
da_ref(p)
	char *p;
{
	++*(int*)(p - sizeof(int));
}


void
da_unref(p)
	char *p;
{
	if (--*(int*)(p - sizeof(int)) < 1)
		PVM_FREE(p - 16);
}


