
/*
 *           PVM 3.2:  Parallel Virtual Machine System 3.2
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.2 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *     global.h
 *
 *     Generic includes.
 *
$Log: global.h,v $
 * Revision 1.6  1993/11/30  15:49:14  manchek
 * version change
 *
 * Revision 1.5  1993/10/27  17:32:16  manchek
 * version change
 *
 * Revision 1.4  1993/10/12  14:44:31  manchek
 * version change
 *
 * Revision 1.3  1993/09/23  20:53:50  manchek
 * version change
 *
 * Revision 1.2  1993/09/22  18:59:46  manchek
 * version change
 *
 * Revision 1.1  1993/08/30  23:26:47  manchek
 * Initial revision
 *
 */


/* release version */

#define PVM_VER "3.2.5"

/* UDPMAXLEN should be set to the largest UDP message length
   your system can handle. */

#ifndef UDPMAXLEN

#if    defined(IMA_CRAY) || defined(IMA_CRAY2)
#include <sys/tcp_config.h>
#define UDPMAXLEN UDPSENDSPACE/2
#endif

#endif /*!UDPMAXLEN*/

#ifndef UDPMAXLEN
#define UDPMAXLEN 4096 /* generic max message length */
#endif

#define LASTPORT 65535 /* last inet port number to try binding to */

/* tid:  s,g,h..h,p..p */

#define TIDHOST  0x3ffc0000
#define TIDLOCAL 0x0003ffff
#define TIDGID  0x40000000
#define TIDPVMD  0x80000000

#define TIDISTASK(x) (!((x) & (TIDGID|TIDPVMD)))
/*
#define TIDISTASK(x) (!((x) & (TIDGID|TIDPVMD)) && ((x) & TIDHOST) && ((x) & TIDLOCAL))
*/
#define TIDISMCA(x) (((x) & (TIDGID|TIDPVMD)) == TIDGID)

/* frag and packet flags */

#define FFSOM  1  /* first frag of msg */
#define FFEOM  2  /* final frag of msg */

#ifndef DEFBINDIR
#define DEFBINDIR "pvm3/bin/%"
#endif

#ifndef DEFDEBUGGER
#define DEFDEBUGGER "pvm3/lib/debugger"
#endif

#ifndef PVMDFILE
#ifndef IMA_OS2
#define PVMDFILE "lib/pvmd"
#else
#define PVMDFILE "/pvm3/lib/pvmd.cmd"
#endif
#endif

