;
; file=NWLITE.PAT (01Jun92 GLF)
;
; Novell's Netware Lite 1.0 has a minor bug which will prevent the server
; portion of the program from operating in an OS/2 VDM.  Under certain
; conditions it will also crash DOS.  This patch will correct the defect
; in the file SERVER.EXE.  This is not an official fix, and carries no
; guarantees.  Novell has been sent this patch file and appropriately
; informed of this condition.  Users should contact Novell to obtain
; official fixes to the Netware Lite program product.
;
; The problem is that SERVER.EXE assumes the JFN (Job File Number) for
; handles 0 and 1 (standard in and out) to always be a value of 1.  This
; is not always the true, since handles and the system file table are
; independent.  The correct solution is to copy the JFN from the PSP of
; SERVER.EXE for handles 0 and 1 to the new JFT (Job File Table).
;
; To install this fix enter the following from either an OS/2 or VDM
; command line:    PATCH NWLITE.PAT /A
;


FILE SERVER.EXE
;-------------------------------
                                ;;ES=DS=segment of PSP and data
VER  1E6B 06                    ; push    es
VER  1E6C A1-EB-11              ; mov     ax,[11EBh]         ;AX=new JFT size
VER  1E6F 8B-1E-D7-11           ; mov     bx,[11D7h]         ;BX=PSP
VER  1E73 8E-C3                 ; mov     es,bx              ;ES=PSP
VER  1E75 8B-16-ED-11           ; mov     dx,[11EDh]         ;DX=ofs new JFT
VER  1E79 26-A3-32-00           ; mov     es:[0032h],ax      ;PSP:=new JFT size
VER  1E7D 26-89-16-34-00        ; mov     es:[0034h],dx      ;PSP:=new JFT
VER  1E82 26-8C-1E-36-00        ; mov     es:[0036h],ds      ;        address
VER  1E87 07                    ; pop     es                 ;ES=seg new JFT
VER  1E88 8B-0E-EB-11           ; mov     cx,[11EBh]         ;CX=new JFT size
VER  1E8C B0-FF                 ; mov     al,-1              ;-1=unused JFN
VER  1E8E 8B-3E-ED-11           ; mov     di,[11EDh]         ;ES:DI=&new JFT
VER  1E92 FC                    ; cld
VER  1E93 F3-AA                 ; rep     stosb              ;fill new JFT w/-1
VER  1E95 8B-3E-ED-11           ; mov     di,[11EDh]
VER  1E99 C6-05-01              ; mov     byte ptr [di],1    ;JFN[0]:=1
VER  1E9C C6-45-01-01           ; mov     byte ptr [di+1],1  ;JFN[1]:=1
VER  1EA0 C3                    ; ret
                                ;;ES=DS=segment of PSP and data
                                ;;AH=junk (upper half of new JFT size)
                                ;;AL=-1
                                ;;BX=PSP
                                ;;CX=0
                                ;;DX=offset of new JFT
                                ;;DI=offset of new JFT
;-------------------------------
                                ;;ES=DS=segment of PSP and data
CHA  1E6B 1E                    ; push    ds
CHA  1E6C 8B-0E-EB-11           ; mov     cx,[11EBh]         ;CX=new JFT size
CHA  1E70 8B-1E-D7-11           ; mov     bx,[11D7h]         ;BX=PSP
CHA  1E74 8E-DB                 ; mov     ds,bx              ;DS=PSP
CHA  1E76 C5-3E-34-00           ; lds     di,[0034h]         ;DS:DI=&old JFT
CHA  1E7A 8B-05                 ; mov     ax,[di]            ;AX=old JFN(0,1)
CHA  1E7C 8E-DB                 ; mov     ds,bx              ;DS=PSP
CHA  1E7E 26-8B-16-ED-11        ; mov     dx,es:[11EDh]      ;DX=ofs new JFT
CHA  1E83 89-0E-32-00           ; mov     [0032h],cx         ;PSP:=new JFT size
CHA  1E87 89-16-34-00           ; mov     [0034h],dx         ;PSP:=new JFT
CHA  1E8B 8C-06-36-00           ; mov     [0036h],es         ;        address
CHA  1E8F 1F                    ; pop     ds                 ;DS=seg new JFT
CHA  1E90 89-D7                 ; mov     di,dx              ;ES:DI=&new JFT
CHA  1E92 FC                    ; cld
CHA  1E93 AB                    ; stosw                      ;copy JFN(0,1)
CHA  1E94 88-EC                 ; mov     ah,ch              ;???useless???
CHA  1E96 B0-FF                 ; mov     al,-1              ;-1=unused JFN
CHA  1E98 49                    ; dec     cx
CHA  1E99 49                    ; dec     cx
CHA  1E9A F3-AA                 ; rep     stosb              ;fill new JFT w/-1
CHA  1E9C 89-D7                 ; mov     di,dx
CHA  1E9E C3                    ; ret
CHA  1E9F 90                    ; nop
CHA  1EA0 90                    ; nop
                                ;;ES=DS=segment of PSP and data
                                ;;AH=junk (upper half of new JFT size)
                                ;;AL=-1
                                ;;BX=PSP
                                ;;CX=0
                                ;;DX=offset of new JFT
                                ;;DI=offset of new JFT
;-------------------------------

