.TH SETL2 Local "9 September 1990" "New York University" "Setl2 Version 2.2" 
.SH NAME
.B stll
- library utility program
.br
.B stlc
- SETL2 compiler
.br
.B stlx
- SETL2 executor
.SH DESCRIPTIONS
There are three general steps to be performed before you can use SETL2:
.RS 4n
.PP
Your PATH environment string must include the directory where SETL2's
executable files are installed (/usr/local/bin on this system).
.PP
You need to create an empty SETL2 library to hold the SETL2 objects
you'll make.
.PP
You need to create an environment string pointing to this library.
.RE

.SS USING THE LIBRARY UTILITY
One of the command files distributed with SETL2 is 
.B stll,
a library utility
program.  Eventually, this should perform a variety of functions, but at
the moment it is only used to create empty libraries.  To do that, change
to any directory where you keep data files and enter the following command:
.IP "" 4n
.B   stll -c 
.I ``library name''
.PP
A normal
.I ``library name''
is
.I setl2.lib.
.PP
Finally, you should set the environment string
.B SETL2_LIB
to tell
SETL2 where your default library is.  The command to do this,
.B setenv SETL2_LIB ~setl2.lib,
is best
placed in your .login file.

.SS EXECUTING THE COMPILER

The command to compile a SETL2 source program is:
.IP "" 4n
.B   stlc <options> <file specifier> [<file specifier> ...]
.PP
You may use wild cards in specifying the files to be compiled.  The
following options are recognized:
.RS 4n
.IP \fB-s\fR 14n
Produce a listing of the program with line numbers and error messages.  By
default errors will be printed on standard output.  If this option is
given a listing file with the extension
.B .lis
will be produced.
.IP "\fB-t \fIn\fR" 14n
Set tab width to
.I n.
This is generally an unnecessary option.  Error
messages include both line and column numbers, and the column numbers will
be incorrect if the source file uses tabs not set at eight column
intervals.  If an editor is used which can move the cursor to the line and
column of an error, it will need that information.  By setting this option
any tab interval may be used.  If line number information is sufficient
(which is generally the case) this option can be ignored.
.IP \fB-i\fR 14n
Disable implicit declarations.  SETL implicitly declared any names for
which it did not find an explicit declaration.  SETL2 continued this by
default, but for other than quick and dirty programs that may not be
desirable.  When this option is set all variables must be declared.
.IP
We do make implicit declarations by default, since we feel that the
compile commands for larger programs will generally be in
.I make
files, which do not have to be changed very often.  The compile
command should be convenient for short programs, in which case implicit
declarations will probably be desired.  If you disagree with this
philosophy, you can set the environment string to your own desired
defaults.
.IP \fB-f\fR 14n
Toggle use of intermediate files.  By default, the compiler stores
intermediate forms of the program on disk for MS-DOS systems and in core
on Unix systems.  This option reverses that setting.  If you are using an
operating system with virtual memory, you will probably find it faster to
compile in core only.  If you are using a PC, this is
.I not
recommended, since at present the compiler does not make use of extended
or expanded memory and there is not much extra memory in a PC.  The best
thing you can do with expanded or extended memory is to use a RAM disk,
and set the environment option to force intermediate files to be stored
there.
.IP "\fB-l \fIfile name\fR" 14n
Updated library name.  This string must be a valid file name on the system
you are using.  If there are embedded spaces you must use quotes to make
the file name a single string.
.IP "\fB-p \fIfile path\fR" 14n
Library search path.  This is a list of semicolon-delimited file
specifiers which describe a list of files to be searched for any imported
packages.  Each specifier may contain wildcards if desired.  You should
note that the compiler will search only until it finds a package with the
name given in a
.B use
clause.  It will not check for duplicates.
When wildcards are used, the order of search will depend on the disk
subsystem (system calls are used to expand the file specifiers).
.RE

.SS EXECUTING THE INTERPRETER

After the program is successfully compiled it may be executed with the
command:
.IP "" 4n
.B   stlx <options> <program name> [<argument> ...]
.PP
.B CAUTION:
When you execute a program, you give the name of the
.I program,
not the name of the file which contained it.  For example: if
the following program:
.IP "" 4n
.nf
.B   program this_is_a_junk_program;
.B      var some_trash;
.B          ...
.B   end this_is_a_junk_program;
.fi
.PP
is in the file
.B junk.stl,
then you would compile that program with the
command
.IP "" 4n
.B   stlc junk
.PP
but you would execute the program with the command
.IP "" 4n
.B   stlx this_is_a_junk_program
.PP
The arguments after the program name will be gathered into a tuple, and
will be available to the SETL2 program as
.B command_line".
.PP
The options available are:

.RS 4n
.IP "\fB-a \fImode\fR" 14n
This sets the assert mode.  There are two possible values for
.I mode:
.B f
is used if failing assertions should stop the program but
succeeding assertions should be skipped, and
.B l
is used if
succeeding assertions should be logged.

.IP "\fB-l \fIfile name\fR" 14n
Updated library name.  The library is not actually updated, this is
provided for consistency with the compiler.  This library will be searched
before those in the search path.

.IP "\fB-p \fIfile path\fR" 14n
Library search path.  This is a list of semicolon delimited file
specifiers which describe a list of files to be searched for any imported
packages.  Each specifier may contain wildcards if desired.  You should
note that the compiler will search only until it finds a package with the
name given in a
.B use
clause.  It will not check for duplicates.
When wildcards are used, the order of search will depend on the disk
subsystem (system calls are used to expand the file specifiers).
.RE
.SH ENVIRONMENT STRINGS

The following is a list of useful environment strings recognized by the
SETL2 compiler and interpreter.
.RS 4n
.IP \fBSETL2_LIB\fR 18n
This lets you place the name of your update library in the environment,
rather than specifying it on the command line.  You should probably place
a command in your
.B .login
script to set this for you when you log on.
.IP \fBSETL2_LIBPATH\fR 18n
This is a list of libraries which will be searched for imported packages.
The default is empty, which will probably be OK generally.  It is just a
string of comma-delimited file specifiers, which may include wildcards.
.IP \fBSETL2_TMP\fR 18n
This string is a prefix used to specify where temporary files should be
stored.  It is primarily useful on a PC, where you should use this to hold
the letter of your RAM disk, if you have one.  For example, if your RAM
disk is logical drive
.B d,
you would place in your
.B autoexec.bat
file the command
.B set SETL2_TMP d:.
.IP \fBSTLC_OPTIONS\fR 18n
This is a string of options which will be read in front of the command
line by the compiler.  You can use this to change the default for implicit
declarations, tab width, or anything else.
.IP \fBSTLX_OPTIONS\fR 18n
This is a used just like the previous string, but is used by the
interpreter.
.RE
.SH ACKNOWLEDGEMENTS

Many of the changes made in SETL2 were motivated by comments and ideas
voiced in the SETL meetings at New York University.  I would like to
thank all who attended those meetings and participated in the discussions,
in particular Robert Dewar, Fritz Henglein, Bob Paige, Ed Schonberg, and
Matthew Smosna.
.PP
I would also like to thank Jack Schwartz, who offered many helpful
comments and suggestions, and gave the system its most thorough test.
