
	'Example drawing program for Liberty BASIC for OS/2

    lineThickness$ = "1"
    color$ = "black"

    button #1, "red", [colorRed], UL, 5, 5
    button #1, "yellow", [colorYellow], UL, 40, 5
    button #1, "green", [colorGreen], UL, 95, 5
    button #1, "blue", [colorBlue], UL, 143, 5
    button #1, "circle", [setForEllipse], UR, 75, 5
    button #1, "square", [setForBox], UR, 20, 5
    button #1, "line", [setForLine], UR, 125, 5
    button #1, "size", [lineThickness], UR, 165, 5

    open "Liberty Draw" for graphics_fs_nsb as #1
    print #1, "when leftButtonDown [startDraw]"
    print #1, "when rightButtonUp [cls]"
    print #1, "down"
    print #1, "color black"
    goto [setForLine]

[inputLoop]
    input r$
    goto [inputLoop]

[startDraw]
    startX = MouseX
    startY = MouseY
    print #1, "place "; startX; " "; startY
    goto [inputLoop]

[firstLine]
    print #1, "when leftButtonMove [trackLine]"
    print #1, "line "; startX; " "; startY; " "; MouseX; " "; MouseY
    oMouseY = MouseY
    oMouseX = MouseX
    goto [inputLoop]

[firstFrame]
    print #1, "when leftButtonMove [trackBox]"
    print #1, "box "; MouseX; " "; MouseY
    oMouseY = MouseY
    oMouseX = MouseX
    goto [inputLoop]

[trackBox]
    print #1, "color white"
    print #1, "box "; oMouseX; " "; oMouseY
    print #1, "color black"
    print #1, "place "; startX; " "; startY
    print #1, "box "; MouseX; " "; MouseY
    oMouseY = MouseY
    oMouseX = MouseX
    goto [inputLoop]

[trackLine]
    print #1, "color white"
    print #1, "line "; startX; " "; startY; " "; oMouseX; " "; oMouseY
    print #1, "color black"
    print #1, "place "; startX; " "; startY
    print #1, "line "; startX; " "; startY; " "; MouseX; " "; MouseY
    oMouseY = MouseY
    oMouseX = MouseX
    goto [inputLoop]

[finishLine]
    print #1, "when leftButtonMove [firstLine]"
    print #1, "discard"
    print #1, "color "; color$; " ; line "; startX; " "; startY; " "; MouseX; " "; MouseY
    print #1, "flush ; redraw"
    goto [inputLoop]

[finishBox]
    print #1, "when leftButtonMove [firstFrame]"
    print #1, "discard"
    print #1, "color "; color$; " ; boxfilled "; MouseX; " "; MouseY
    print #1, "flush ; redraw"
    goto [inputLoop]

[finishEllipse]
    print #1, "when leftButtonMove [firstFrame]"
    print #1, "discard"
    print #1, "place "; int((startX+MouseX)/2); " ";  int((startY+MouseY)/2)
    print #1, "color "; color$; " ; ellipsefilled "; abs(MouseX-startX); " "; abs(MouseY-startY)
    print #1, "flush ; redraw"
    goto [inputLoop]

[cls]
    print #1, "cls"
    goto [inputLoop]


[setForLine]

    print #1, "when leftButtonMove [firstLine]"
    print #1, "when leftButtonUp [finishLine]"
    goto [inputLoop]

[setForBox]

    print #1, "when leftButtonMove [firstFrame]"
    print #1, "when leftButtonUp [finishBox]"
    goto [inputLoop]

[setForEllipse]

    print #1, "when leftButtonMove [firstFrame]"
    print #1, "when leftButtonUp [finishEllipse]"
    goto [inputLoop]


[colorRed]

    color$ = "red"
    goto [inputLoop]


[colorYellow]

    color$ = "yellow"
    goto [inputLoop]


[colorGreen]

    color$ = "green"
    goto [inputLoop]


[colorBlue]

    color$ = "blue"
    goto [inputLoop]


[lineThickness]

    prompt "Line Thickness"; lineThickness$
    print #1, "size "; lineThickness$
    goto [inputLoop]


[printIt]

    print #1, "print"
    goto [inputLoop]


	'end of program
    end