#define INCL_PM
#define INCL_DOS

#include <os2.h>
#include <string.h>
#include "scroll2.h"

MRESULT EXPENTRY ScrollWndProc(HWND,USHORT,MPARAM,MPARAM);
VOID GetFontData(HWND,SHORT *,SHORT *,SHORT *);
VOID  ReadTextFile(VOID);
SHORT GetScrollBar(SHORT,SHORT,SHORT,SHORT,SHORT);
VOID DisplayText(HPS,SHORT,SHORT,SHORT,SHORT,SHORT);
CHAR szDisplay[50][81];
SHORT TotalLines = 0;

int main(void)
     {
     static CHAR szClass [] = "Scroll2";
     HAB         hab;
     HMQ         hmq;
     HWND        hwndClient, hwndFrame;
     QMSG        qmsg;
     ULONG       ctlData =  FCF_TITLEBAR | FCF_SYSMENU
                  | FCF_SIZEBORDER | FCF_MINMAX | FCF_VERTSCROLL
                  | FCF_SHELLPOSITION | FCF_TASKLIST;


     hab = WinInitialize(NULL);
     hmq = WinCreateMsgQueue(hab, 0);

     WinRegisterClass(hab, szClass, ScrollWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow(
                               HWND_DESKTOP,
                               WS_VISIBLE,
                               &ctlData,
                               szClass,
                               NULL,
                               0L,
                               NULL,
                               0,
                               &hwndClient);

     while(WinGetMsg(hab, &qmsg, NULL, 0, 0))
          WinDispatchMsg(hab, &qmsg);

     WinDestroyWindow(hwndFrame);
     WinDestroyMsgQueue(hmq);
     WinTerminate(hab);

     return(0);
     }

MRESULT EXPENTRY ScrollWndProc(hwnd, msg, mp1, mp2)
HWND hwnd;
USHORT msg;
MPARAM mp1, mp2;
{

     HPS  hps;
     SHORT  i=0;
     static HWND   hwndVscroll;
     static SHORT  sVscroll=0, cx, cy;
     static SHORT  AveChar, MaxBase, MaxDesc;


     switch(msg)
          {
          case WM_CREATE:
               GetFontData(hwnd, &AveChar, &MaxBase, &MaxDesc);
               ReadTextFile();
               hwndVscroll = WinWindowFromID(
                                   WinQueryWindow(hwnd, QW_PARENT, FALSE),
                                   FID_VERTSCROLL);

               WinSendMsg(hwndVscroll, SBM_SETSCROLLBAR,
                                   MPFROM2SHORT(sVscroll, 0),
                                   MPFROM2SHORT(0, TotalLines - 1));
               return(FALSE);


          case WM_SIZE:
               cx = SHORT1FROMMP(mp2);
               cy = SHORT2FROMMP(mp2);
               return(NULL);

          case WM_VSCROLL:
               sVscroll = GetScrollBar(sVscroll, SHORT2FROMMP(mp2),
                                       SHORT1FROMMP(mp2), cx, AveChar);

               WinSendMsg(hwndVscroll, SBM_SETPOS,
                          MPFROM2SHORT(sVscroll, 0), NULL);
               WinInvalidateRect(hwnd, NULL, FALSE);
               return(NULL);

          case WM_PAINT:
               hps = WinBeginPaint(hwnd, NULL, NULL);
               GpiErase(hps);
               DisplayText(hps, cy, sVscroll,
                              AveChar, MaxBase, MaxDesc);
               WinEndPaint(hps);
               return(NULL);
          }
     return(WinDefWindowProc(hwnd, msg, mp1, mp2));
}


VOID GetFontData(hwnd, AveChar, MaxBase, MaxDesc)
HWND hwnd;
SHORT *AveChar, *MaxBase, *MaxDesc;
{
     HPS hps;

     FONTMETRICS   fm;

     hps = WinGetPS(hwnd);
     GpiQueryFontMetrics(hps,(LONG) sizeof fm, &fm);
     *AveChar =(SHORT) fm.lAveCharWidth;
     *MaxBase =(SHORT) fm.lMaxBaselineExt;
     *MaxDesc =(SHORT) fm.lMaxDescender;
     WinReleasePS(hps);
}

SHORT GetScrollBar(sVscroll, sScroll, sSlider, cy, AveChar)
SHORT sVscroll, sScroll, sSlider, cy, AveChar;
{

       switch(sScroll)
         {
            case SB_SLIDERPOSITION:
                 sVscroll = sSlider;
                 break;

            case SB_PAGEDOWN:
                 sVscroll += cy / AveChar;
                 break;

            case SB_PAGEUP:
                 sVscroll -= cy / AveChar;
                 break;

            case SB_LINEUP:
                 sVscroll--;
                 break;

            case SB_LINEDOWN:
                 sVscroll++;
                 break;

         }

       return(sVscroll);
}


VOID ReadTextFile()
{
     CHAR     szText[50][BUFLENGTH+1];
     USHORT   usAction, usBytes;
     HFILE    hf;
     ULONG    ulSize = 0;
     SHORT    i=0, j=0, k=0, n=0;


     DosOpen("TESTFILE", &hf, &usAction, ulSize,
                     ATTRIBUTE, OPENFLAG, OPENMODE, 0L);

     do {
          DosRead(hf, szText[i], BUFLENGTH, &usBytes);
          szText[i][usBytes] = 0;
          i++;
     } while(usBytes == BUFLENGTH);
     TotalLines = i;
     i=0;

     while(j <= TotalLines )

          switch(szText[j][i])
             {
                 case 10:
                   szDisplay[k][n] = 0;
                   k++;
                   n=0;
                   i++;
                   break;

                 case 13:
                   i++;
                   break;

                 case 0:
                    j++;
                    i=0;
                    break;

                 default:
                    szDisplay[k][n] = szText[j][i];
                    i++;
                    n++;
             }

     TotalLines = k;

     DosClose(hf);
}


VOID DisplayText(hps, cy, sVscroll, AveChar, MaxBase, MaxDesc)
HPS hps;
SHORT cy, sVscroll;
SHORT AveChar, MaxBase, MaxDesc;
{

      SHORT i, sNewPos;
      POINTL ptl;

      sNewPos = (sVscroll < 0) ? 0 : sVscroll;

      for(i=0; i < TotalLines; i++)
        {
            ptl.x = AveChar;
            ptl.y = cy - MaxBase * (i + 1 - sNewPos) + MaxDesc;

            GpiCharStringAt(hps, &ptl,
                            (LONG) strlen(szDisplay[i]),
                            szDisplay[i]);
        }
}

