/*---------------------------------
   CLOCK.C -- Analog Clock w/ Alarm
  ----------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include "clock2.h"

#define ID_TIMER 1

char     alarm_status = 0x00;
INITDATA init;
HBITMAP  hbm;
HAB      hab ;
HWND     hwndFrame, hwndClient ;

MRESULT EXPENTRY AlarmSet(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ClientWndProc (HWND, USHORT, MPARAM, MPARAM) ;

int cdecl main (void)
     {
     static CHAR  szClientClass[] = "Clock" ;
     static ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU | FCF_ACCELTABLE |
                                 FCF_SIZEBORDER    | FCF_MINMAX  |
                                 FCF_SHELLPOSITION | FCF_TASKLIST | FCF_MENU ;
     HMQ          hmq ;
     QMSG         qmsg ;
     SHORT        i = sizeof(init);

     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;

     WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0) ;

     if ( ! WinQueryProfileData(hab, szClientClass, "Clock Data", &init, &i))
       {
       init.background = CLR_WHITE;
       init.text_color = CLR_BLACK;
       init.wp.x       = 50;
       init.wp.y       = 100;
       init.wp.cx      = 365;
       init.wp.cy      = 300;
       }
     
     hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_DISABLED, 
                                     &flFrameFlags, szClientClass, NULL,
				     0L, NULL, ID_CLOCK, &hwndClient) ;

     WinSetWindowPos(hwndFrame, HWND_TOP, init.wp.x,
                     init.wp.y, init.wp.cx, init.wp.cy, 
                     SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW);

     WinEnableWindow(hwndFrame, TRUE);
     
     if (WinStartTimer (hab, hwndClient, ID_TIMER, 1000))
       {
       while (WinGetMsg (hab, &qmsg, NULL, 0, 0)) 
         WinDispatchMsg (hab, &qmsg) ;

       WinStopTimer (hab, hwndClient, ID_TIMER) ;
       }
     else
       WinMessageBox (HWND_DESKTOP, hwndClient,
                      "Too many clocks or timers",
                      szClientClass, 0, MB_OK | MB_ICONEXCLAMATION) ;

     WinQueryWindowPos(hwndFrame, &init.wp);
     WinWriteProfileData(hab, szClientClass, "Clock Data", &init, sizeof(init));
     WinDestroyWindow (hwndFrame) ;
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

VOID RotatePoint (POINTL aptl[], SHORT sNum, SHORT sAngle)
     {
     static SHORT sSin [60] =
                    {
                       0,  105,  208,  309,  407,  500,  588,  669,  743,  809,
                     866,  914,  951,  978,  995, 1000,  995,  978,  951,  914,
                     866,  809,  743,  669,  588,  500,  407,  309,  208,  105,
                       0, -104, -207, -308, -406, -499, -587, -668, -742, -808,
                    -865, -913, -950, -977, -994, -999, -994, -977, -950, -913,
                    -865, -808, -742, -668, -587, -499, -406, -308, -207, -104
                    } ;
     POINTL       ptlTemp ;
     SHORT        sIndex ;

     for (sIndex = 0 ; sIndex < sNum ; sIndex++)
          {
          ptlTemp.x = (aptl[sIndex].x * sSin [(sAngle + 15) % 60] +
                       aptl[sIndex].y * sSin [sAngle]) / 1000 ;

          ptlTemp.y = (aptl[sIndex].y * sSin [(sAngle + 15) % 60] -
                       aptl[sIndex].x * sSin [sAngle]) / 1000 ;

          aptl[sIndex] = ptlTemp ;
          }
     }

VOID ScalePoint (POINTL aptl[], SHORT sNum, PWINDOWINFO pwi)
     {
     SHORT sIndex ;

     for (sIndex = 0 ; sIndex < sNum ; sIndex++)
          {
          aptl[sIndex].x = aptl[sIndex].x * pwi->cxPixelDiam / 200 ;
          aptl[sIndex].y = aptl[sIndex].y * pwi->cyPixelDiam / 200 ;
          }
     }

VOID TranslatePoint (POINTL aptl[], SHORT sNum, PWINDOWINFO pwi)
     {
     SHORT sIndex ;

     for (sIndex = 0 ; sIndex < sNum ; sIndex++)
          {
          aptl[sIndex].x += pwi->cxClient / 2 ;
          aptl[sIndex].y += pwi->cyClient / 2 ;
          }
     }

VOID DrawHand (HPS hps, POINTL aptlIn[], SHORT sNum, SHORT sAngle,
               PWINDOWINFO pwi)
     {
     POINTL aptl [5] ;
     SHORT  sIndex ;

     for (sIndex = 0 ; sIndex < sNum ; sIndex++)
          aptl [sIndex] = aptlIn [sIndex] ;

     RotatePoint    (aptl, sNum, sAngle) ;
     ScalePoint     (aptl, sNum, pwi) ;
     TranslatePoint (aptl, sNum, pwi) ;

     GpiMove (hps, aptl) ;
     GpiPolyLine (hps, sNum - 1L, aptl + 1) ;
     }

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
     {
     static DATETIME   dtPrevious ;
     static HDC        hdc ;
     static LONG       xPixelsPerMeter, yPixelsPerMeter ;
     static POINTL     aptlHour   [5] = { 0,-15, 10,0, 0,60, -10,0, 0,-15 },
                       aptlMinute [5] = { 0,-20,  5,0, 0,80,  -5,0, 0,-20 },
                       aptlSecond [2] = { 0,  0,  0,80 } ;
     static WINDOWINFO wi ;
     DATETIME          dt ;
     HPS               hps ;
     SHORT             sDiamMM;
     USHORT            color;
     RECTL             PArea;
     LONG              x, y;

     switch (msg)
          {
          case WM_CREATE:
               hdc = WinOpenWindowDC (hwnd) ;

               DevQueryCaps (hdc, CAPS_VERTICAL_RESOLUTION,
                                  1L, &yPixelsPerMeter) ;
               DevQueryCaps (hdc, CAPS_HORIZONTAL_RESOLUTION,
                                  1L, &xPixelsPerMeter) ;

               DosGetDateTime (&dtPrevious) ;
               dtPrevious.hours = (dtPrevious.hours * 5) % 60 +
                                   dtPrevious.minutes / 12 ;

               hps = WinGetPS (hwnd) ;
               hbm = GpiLoadBitmap(hps, NULL, ID_BITMAP, 0L, 0L);
               WinReleasePS (hps) ;
               return 0 ;

          case WM_SIZE:
               wi.cxClient = SHORT1FROMMP (mp2) ;
               wi.cyClient = SHORT2FROMMP (mp2) ;

               sDiamMM = (SHORT) min (wi.cxClient * 1000L / xPixelsPerMeter,
                                      wi.cyClient * 1000L / yPixelsPerMeter) ;

               wi.cxPixelDiam = (SHORT) (xPixelsPerMeter * sDiamMM / 1000) ;
               wi.cyPixelDiam = (SHORT) (yPixelsPerMeter * sDiamMM / 1000) ;
               return 0 ;

          case WM_TIMER:
               DosGetDateTime (&dt);
               if (init.on_off)
                 if ((dt.hours == (UCHAR)init.alarm_time.hours) &&
                     (dt.minutes == (UCHAR)init.alarm_time.mins))
                   {
                   if ( ! alarm_status)
                     {
                     alarm_status = 0xff;  WinFlashWindow(hwndFrame, TRUE);
                     }
                   }
                 else
                   if (alarm_status) 
                     {
                     alarm_status = 0;  WinFlashWindow(hwndFrame, FALSE);
                     }

               dt.hours = (dt.hours * 5) % 60 + dt.minutes / 12 ;

               hps = WinGetPS (hwnd) ;
               GpiSetColor(hps, ((init.on_off) ? init.text_color 
                                               : init.background));

               DrawHand (hps, aptlSecond, 2, dtPrevious.seconds, &wi) ;

               if (dt.hours   != dtPrevious.hours ||
                   dt.minutes != dtPrevious.minutes)
                    {
                    DrawHand (hps, aptlHour,   5, dtPrevious.hours,   &wi) ;
                    DrawHand (hps, aptlMinute, 5, dtPrevious.minutes, &wi) ;
                    }

               GpiSetColor(hps, ((init.on_off) ? init.background
                                               : init.text_color));

               DrawHand (hps, aptlHour,   5, dt.hours,   &wi) ;
               DrawHand (hps, aptlMinute, 5, dt.minutes, &wi) ;
               DrawHand (hps, aptlSecond, 2, dt.seconds, &wi) ;

               WinReleasePS (hps) ;
               dtPrevious = dt ;
               return 0 ;

          case WM_PAINT: 
               hps = WinBeginPaint (hwnd, NULL, NULL) ;
               WinQueryWindowRect(hwnd, (PRECTL)&PArea);
   
               WinFillRect(hps, (PRECTL)&PArea, 
                      ((init.on_off) ? init.text_color : init.background));
               if ((y = (PArea.yTop - PArea.yBottom)) >= 
                   (x = (PArea.xRight - PArea.xLeft)))
                 {
                 PArea.yTop    -= ((y - x) / 2);
                 PArea.yBottom += ((y - x) / 2);
                 }
               else
                 {
                 PArea.xLeft   += ((x - y) / 2);
                 PArea.xRight  -= ((x - y) / 2);
                 }

               if (init.on_off)
                 WinDrawBitmap(hps, hbm, NULL, (PPOINTL)&PArea, 
                    init.background, init.text_color, DBM_STRETCH);
               else
                 WinDrawBitmap(hps, hbm, NULL, (PPOINTL)&PArea,
                    init.text_color, init.background, DBM_STRETCH);   

               DrawHand (hps, aptlHour,   5, dtPrevious.hours,   &wi) ;
               DrawHand (hps, aptlMinute, 5, dtPrevious.minutes, &wi) ;
               DrawHand (hps, aptlSecond, 2, dtPrevious.seconds, &wi) ;

               WinEndPaint (hps) ; 
               return 0 ;
             
          case WM_COMMAND:
            switch (color = LOUSHORT(mp1))
              {
              case IDM_STOP: 
                WinPostMsg(hwnd, WM_QUIT, 0L, 0L);
                return(0);

              case IDM_FCOLOR: 
              case IDM_BCOLOR:
                if (((color == IDM_FCOLOR) && ( ! init.on_off)) ||
                    ((color == IDM_BCOLOR) && (init.on_off)))
                  {
                  if (++(init.text_color) > 15) init.text_color = 0;
                  }
                else
                  {
                  if (++(init.background) > 15) init.background = 0;
                  }
                WinInvalidateRect(hwnd, NULL, TRUE);
                return(0);

              case IDM_ALARM_ON:
                WinInvalidateRect(hwnd, NULL, TRUE);
                init.on_off = 0xff;  return(0);

              case IDM_ALARM_OFF: 
                init.on_off = 0;  WinInvalidateRect(hwnd, NULL, TRUE);
                if (alarm_status) 
                  {
                  alarm_status = 0;  WinFlashWindow(hwndFrame, FALSE);
                  }
                return(0);
                 
              case IDM_ALARM_SET: 
                WinDlgBox(HWND_DESKTOP, hwndFrame, (PFNWP)AlarmSet,
                          NULL, IDD_ALARM_SET, (PCH)NULL);
                WinInvalidateRect(hwnd, NULL, TRUE);
                return(0);
              }
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }

static UCHAR    OldOnOff;
static TIMEINFO OldTime;
char            wstr[11];
int    hh, mm;

MRESULT EXPENTRY AlarmSet(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
switch (msg)
  {
  case WM_INITDLG: 
    OldOnOff = init.on_off;
    OldTime  = init.alarm_time;
    sprintf(wstr, "%2.2u:%2.2u", OldTime.hours, OldTime.mins);

    if (init.on_off)
      WinPostMsg(WinWindowFromID(hwnd, IDD_ALARM_ONOFF), 
                 BM_SETCHECK, MPFROM2SHORT(TRUE, 0), 0L);

    WinSendDlgItemMsg(hwnd, IDD_ALARM_TIME, EM_SETTEXTLIMIT, MPFROM2SHORT(5, 0), (MPARAM)0 );
  	 WinSetWindowText(WinWindowFromID(hwnd, IDD_ALARM_TIME), wstr);
    return(FALSE);

  case WM_COMMAND: 
    switch (COMMANDMSG(&msg)->cmd)
      {
      case DID_OK:
        WinQueryDlgItemText(hwnd, IDD_ALARM_TIME, 9, (PSZ)&wstr[0]);
        if (sscanf(wstr, "%u:%u", &hh, &mm) == 2)
          if ((hh >= 0) && (mm >= 0) && (hh < 24) && (mm < 60))
            {
            init.alarm_time.hours = hh;
            init.alarm_time.mins  = mm;  
            return((MRESULT)WinDismissDlg(hwnd, TRUE));
            }
        sprintf(wstr, "%2.2u:%2.2u", OldTime.hours, OldTime.mins);
  	     WinSetWindowText(WinWindowFromID(hwnd, IDD_ALARM_TIME), wstr);
        WinAlarm(hwnd, WA_ERROR);
        return(FALSE);

      case DID_CANCEL:
        init.on_off = OldOnOff;
        init.alarm_time = OldTime;
        return((MRESULT)WinDismissDlg(hwnd, FALSE));
      }
    return(0);

  case WM_CONTROL: 
    if (SHORT2FROMMP(mp1) == BN_CLICKED)
      switch (SHORT1FROMMP(mp1))
        {
        case IDD_ALARM_ONOFF: 
           init.on_off ^= 0xff;  WinInvalidateRect(hwndClient, NULL, TRUE);
           if ((! init.on_off) && (alarm_status))
             {
             alarm_status = 0;  WinFlashWindow(hwndFrame, FALSE);
             }
         }
    return(FALSE);

  default: return(WinDefDlgProc(hwnd, msg, mp1, mp2));
  }
return(MRFROMLONG(NULL));
}
