ARCHCFLAGS	=	-DSYSVSIGNAL -DSYSVSTR -DNOGETDTBLSIZ -DNOTMPNAM -DNOWAIT3 -DNOSOCKOPT -DNOWAITPID
ARCHDLIB	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a -los2
ARCHDOBJ	=
ARCHLIB 	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a -los2
HASRANLIB	=	f
PVM_ARCH	=	OS2

#
# Custom section
# Set PVM_ARCH to your architecture type (SUN4, HP9K, RS6K, SGI, etc)
# if PVM_ARCH = BSD386 then set ARCHLIB = -lrpc
# if PVM_ARCH = SGI    then set ARCHLIB = -lsun
# if PVM_ARCH = I860   then set ARCHLIB = -lrpc -lsocket
# if PVM_ARCH = IPSC2  then set ARCHLIB = -lrpc -lsocket
# otherwise leave ARCHLIB blank
#
# PVM_ARCH and ARCHLIB are set for you if you use 'aimk'.
#
# END of custom section - leave this line here
#
PVMDIR	=	../..
SDIR	=	..
BDIR	=	$(PVMDIR)/bin
XDIR	=	$(BDIR)/$(PVM_ARCH)

CC	=	gcc
CFLAGS	=	-O2 -I../../include
PVMLIB	=../../lib/os2/libpvm3.a
LIBS	=	$(PVMLIB) $(ARCHLIB)
XLIBS	=	../../lib/os2/libgpvm3.a $(PVMLIB) $(ARCHLIB)

F77     =	f2c
FFLAGS	=	-w
FLIBS	=	../../lib/os2/libfpvm3.a -lf2c $(LIBS)

default:	hello.exe hello_ot.exe

all:	hello.exe hello_ot.exe timing.exe timings.exe spmd.exe fspmd.exe master.exe slave.exe fmaster.exe fslave.exe testall.exe

$(XDIR):
	- mkdir $(BDIR)
	- mkdir $(XDIR)

clean:
	rm -f *.o timing.exe timings.exe spmd.exe fspmd.exe master.exe slave.exe fmaster.exe fslave.exe testall.exe

hello.exe: $(SDIR)/hello.c  $(XDIR)
	$(CC) $(CFLAGS) -o hello.exe $(SDIR)/hello.c $(LIBS)
	emxbind -s hello.exe
	mv hello.exe $(XDIR)

hello_ot.exe: $(SDIR)/hello_ot.c  $(XDIR)
	$(CC) $(CFLAGS) -o hello_ot.exe $(SDIR)/hello_ot.c $(LIBS)
	emxbind -s hello_ot.exe
	mv hello_ot.exe $(XDIR)

timings.exe: $(SDIR)/timings.c  $(XDIR)
	$(CC) $(CFLAGS) -o timings.exe $(SDIR)/timings.c  $(LIBS)
	emxbind -s timings.exe
	mv timings.exe $(XDIR)

timing.exe: $(SDIR)/timing.c  $(XDIR)
	$(CC) $(CFLAGS) -o timing.exe $(SDIR)/timing.c $(LIBS)
	emxbind -s timing.exe
	mv timing.exe $(XDIR)

spmd.exe: $(SDIR)/spmd.c  $(XDIR)
	$(CC) $(CFLAGS) -o spmd.exe $(SDIR)/spmd.c $(LIBS)
	emxbind -s spmd.exe
	mv spmd.exe $(XDIR)

fspmd.exe: $(SDIR)/spmd.f  $(XDIR)
	$(F77) $(FFLAGS) $(SDIR)/spmd.f
	$(CC) $(CFLAGS) -o fspmd.exe spmd.c  $(FLIBS)
	emxbind -s fspmd.exe
	mv fspmd.exe $(XDIR)

master.exe: $(SDIR)/master1.c  $(XDIR)
	$(CC) $(CFLAGS) -o master.exe $(SDIR)/master1.c  $(LIBS)
	emxbind -s master.exe
	mv master.exe $(XDIR)

slave.exe: $(SDIR)/slave1.c  $(XDIR)
	$(CC) $(CFLAGS) -o slave.exe $(SDIR)/slave1.c  $(LIBS)
	emxbind -s slave.exe
	mv slave.exe $(XDIR)

fmaster.exe: $(SDIR)/master1.f  $(XDIR)
	$(F77) $(FFLAGS) $(SDIR)/master1.f
	$(CC) $(CFLAGS) -o fmaster.exe master1.c $(FLIBS)
	emxbind -s fmaster.exe
	mv fmaster.exe $(XDIR)

fslave.exe: $(SDIR)/slave1.f  $(XDIR)
	$(F77) $(FFLAGS) $(SDIR)/slave1.f
	$(CC) $(CFLAGS) -o fslave.exe slave1.c  $(FLIBS)
	emxbind -s fslave.exe
	mv fslave.exe $(XDIR)

testall.exe: $(SDIR)/testall.f  $(XDIR)
	$(F77) $(FFLAGS) $(SDIR)/testall.f
	$(CC) $(CFLAGS) -o testall.exe testall.c $(FLIBS)
	emxbind -s testall.exe
	mv testall.exe $(XDIR)

