


AG(1)                    USER COMMANDS                      AG(1)



NAME
     ag - generator for attribute evaluators

SYNOPSIS
     ag [-options] [-l dir] [file]

DESCRIPTION
     Ag generates a program module to evaluate an attribute  com-
     putation  specified  by  an  attribute  grammar.   A typical
     application is the semantic analysis phase  in  a  compiler.
     The input file contains an attribute grammar which describes
     the structure of all possible trees, the attributes, and the
     attribute  computations.   Ag  checks  whether the attribute
     grammar is ordered (OAG) and generates an evaluator consist-
     ing  out  of  recursive  procedures.  If file is omitted the
     specification is read from standard input.

OPTIONS
     A    generate all, same as -DI (default)

     D    generate definition module

     I    generate implementation module

     L    generate a (lazy) evaluator for WAG (default OAG)

     W    suppress warnings

     B    allow missing attribute computations in extended node types

     V    print visit sequences

     M    print summary of all node types (rules) from source

     P    print dependency relations DP

     S    print dependency relations SNC

     N    print dependency relations DNC

     O    print dependency relations OAG

     G    print attribute instances sorted by declaration

     E    print attribute instances sorted by evaluation order

     C    print dependencies introduced for total order (completion)

     T    generate evaluator with trace output (all actions, T = XZ)

     U    trace only node types specified in file TraceTab




GMD-Forschungsstelle-Karlsruhe    Last change:                  1






AG(1)                    USER COMMANDS                      AG(1)



     X    trace attribute evaluation actions with values

     Y    trace attribute evaluation actions without values

     Z    trace visit actions

     J    start dialog system

     Q    browse internal data structure

     0    optimize attribute storage

     1    print inserted copy rules

     2    print inherited attribute computation rules

     3    print attribute storage assignment

     6    generate # line directives

     7    touch output files only if necessary

     8    report storage consumption

     9    generate code to measure stack size

     c    generate C code (default is Modula-2)

     H    print help information for evaluator module

     ldir dir is the directory where ag finds its table files

FILES
     if output is in C:

     <module>.h          specification of the generated evaluator module
     <module>.c          body of the generated evaluator module
     yy<module>.w        macro definitions
     if output is in Modula-2:

     <module>.md         definition module of the generated evaluator module
     <module>.mi         implementation module of the generated evaluator module

SEE ALSO
     J. Grosch: "Ast - A Generator for  Abstract  Syntax  Trees",
     GMD Forschungsstelle an der Universitaet Karlsruhe, Compiler
     Generation Report No. 15
     J. Grosch: "Ag -  An  Attribute  Evaluator  Generator",  GMD
     Forschungsstelle  an  der  Universitaet  Karlsruhe, Compiler
     Generation Report No. 16

     J. Grosch: "Object-Oriented Attribute Grammars", in:  A.  E.
     Harmanci,  E.  Gelenbe  (Eds.):  Proceedings  of  the  Fifth



GMD-Forschungsstelle-Karlsruhe    Last change:                  2





AG(1)                    USER COMMANDS                      AG(1)



     International Symposium on Computer and Information Sciences
     (ISCIS V), Cappadocia, Nevsehir, Turkey, 807-816, Oct .1990





















































GMD-Forschungsstelle-Karlsruhe    Last change:                  3



