
(*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)
(*                                                                   *)
(*     Borland Pascal OS/2 API                                       *)
(*                                                                   *)
(*     DOSPROCS - Dos system API                                     *)
(*                                                                   *)
(*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)

unit DosProcs;

interface

uses
  OS2Def, DosTypes;

function DosAllocHuge(NumSeg, Size : Word; var Selector : SEL;
  MaxNumSeg, AllocFlags : Word) : Word;
function DosAllocSeg(Size : Word; var Selector : SEL; AllocFlags : Word) : Word;
function DosAllocShrSeg(Size : Word; Name : PChar; var Selector : SEL) : Word;
function DosBeep(ulFrequency, ulDuration : Word) : Word;
function DosBufReset(hf : HFILE) : Word;
procedure DosCallback(Ring3Routine : PFN);
function DosCallNPipe(pszName : CONSTPSZ; var pInbuf; ulInbufLength : Word;
  var pOutbuf; ulOutbufSize : Word; var pulActualLength : Word;
  ulTimeout : Longint) : Word;
function DosCaseMap(Length : Word; var Country : TCountryCode; BinaryString : PChar) : Word;
function DosChDir(DirName : PChar; Reserved : Longint) : Word;
function DosChgFilePtr(hf : HFILE; ulOffset : Longint; MoveType : Word;
  var NewPointer : Longint) : Longint;
function DosCLIAccess : Word;
function DosClose(hf : HFILE) : Word;
function DosCloseQueue(hq : HQUEUE) : Word;
function DosCloseSem(hsem : HSEM) : Word;
function DosConnectNmPipe(hp : HPIPE) : Word;
function DosCopy(SrcName, TargetName : PChar; OpMode : Word;
  Reserved : Longint) : Word;
function DosCreateCSAlias(DataSelector, CodeSelector : Word) : Word;
function DosCreateQueue(var RWHandle : HQUEUE; QueuePrty : Word;
  QueueName : PChar) : Word;
function DosCreateSem(NoExclusive : Word; var SemHandle : HSYSSEM;
  SemName : PChar) : Word;
function DosCreateThread(Address : pointer; var ThreadIDWord : TID;
  NewThreadStack : Pointer) : Word;
function DosCwait(ActionCode : Word; WaitOption : Word; var ReturnCodes : TRESULTCODES;
  var ProcessIDWord : PID; ProcessID : PID) : Word;
function DosDelete(FileName : PChar; Reserved : Longint) : Word;
function DosDevConfig(var DeviceInfo; Item, Parm : Word) : Word;
function DosDevIOCtl(var Data, ParmList; Funct, Category : Word;
  DevHandle : HFILE) : Word;
function DosDevIOCtl2(var Data; DataLength : Word; var ParmList;
  ParmListLength : Word; Funct, Category : Word; DevHandle : HFILE) : Word;
function DosDisConnectNmPipe(hp : HPIPE) : Word;
function DosDupHandle(OldHandle : HFILE; NewHandle : PHFILE) : Word;
function DosEditName(EditLevel : Word; SourceString, EditString : PChar;
  var TargetBuf; TargetBufLen : Word) : Word;
function DosEnterCritSec : Word;
function DosEnumAttribute(RefType : Word; FileRef : pointer; EntryNum : Longint;
  var EnumBuf; EnumBufSize : Longint; var EnumCnt : Longint;
  InfoLevel : Longint; Reserved : Longint) : Word;
function DosErrClass(Code : Word; var Class, Action, Locus : Word) : Word;
function DosError(Flags : Word) : Word;
function DosExecPgm(ObjNameBuf : PChar; ObjNameBufLen : Word;
  var ExecFlags : Word; ArgPointer, EnvPointer : PChar;
  var ReturnCodes : TResultCodes; PgmPointer : PChar) : Word;
procedure DosExit(ActionCode, ResultCode : Word);
function DosExitCritSec : Word;
function DosExitList(FcnCode_Order : Word; RtnAddress : TFNEXITLIST) : Word;
function DosFileIO(hf : HFILE; var CommandList; CommandListLen : Word;
  var ErrorOffset : Longint) : Word;
function DosFileLocks(hf : HFILE; var UnlockRange, LockRange : TQWORD) : Word;
function DosFindClose(DirHandle : HDIR) : Word;
function DosFindFirst(FileName : PChar; var DirHandle : HDIR; Attribute : Word;
  var ResultBuf : TFileFindBuf; ResultBufLen : Word; var SearchCount : Word;
  Reserved : Longint) : Word;
function DosFindFirst2(FileName : PChar; var DirHandle : HDIR; Attribute : Word;
  var ResultBuf : TFileFindBuf; ResultBufLen : Word; var SearchCount : Word;
  FileInfoLevel : Word; Reserved : Longint) : Word;
function DosFindNext(DirHandle : HDIR; var ResultBuf : TFileFindBuf;
  ResultBufLen : Word; var SearchCount : Word) : Word;
function DosFlagProcess(ProcessID : PID; ActionCode, FlagNum, FlagArg : Word) : Word;
function DosFreeModule(ModuleHandle : HModule) : Word;
function DosFreeResource(ResAddr : pointer) : Word;
function DosFreeSeg(Selector : SEL) : Word;
function DosFSAttach(DeviceName : PChar; FSDName : PChar; var DataBuffer;
  DataBufferLen, OpFlag : Word; Reserved : Longint) : Word;
function DosFSCtl(var DataArea; DataLengthMax : Word; var DataLength : Word;
  var ParmList; ParmLengthMax : Word; ParmLength : PWord;
  FunctionCode : Word; RouteName : PChar; hf : HFILE;
  RouteMethod : Word; Reserved : Longint) : Word;
function DosFSRamSemClear(var FSRamSemStructure : TDOSFSRSEM) : Word;
function DosFSRamSemRequest(var FSRamSemStructure : TDOSFSRSEM; TimeOut : Longint) : Word;
function DosGetCollate(Length : Word; var Country : TCountryCode;
  var MemoryBuffer; var DataLength : Word) : Word;
function DosGetCp(Length : Word; var CodePageList : Word; var DataLength : Word) : Word;
function DosGetCtryInfo(Length : Word; var Country : TCountryCode;
  var MemoryBuffer : TCountryInfo; var DataLength : Word) : Word;
procedure DosGetDateTime(var DTime : TDateTime);
function DosGetDBCSEv(Length : Word; Country : TCountryCode;
  var MemoryBuffer) : Word;
function DosGetEnv(var Sel : Word; var Cmd : Word) : Word;
procedure DosGetHugeShift(var ShiftCount : Word);
function DosGetInfoSeg(var GlobalSeg, LocalSeg : SEL) : Word;
procedure DosGetMachineMode(var MachineMode : Byte);
function DosGetMessage(var lvTable; lvCount : Word; DataArea : PChar;
  Datalen : Word; MsgNum : Word; FileName : PChar; var MsgLen : Word) : Word;
function DosGetModHandle(ModuleName : PChar; var ModHandle : HMODULE) : Word;
function DosGetModName(ModHandle : HMODULE; BufLen : Word; Buffer : PChar) : Word;
procedure DosGetPID(var ProcessIDs : TPIDINFO);
function DosGetPPID(PID : Word; var PPID : Word) : Word;
function DosGetProcAddr(hmod : HMODULE; ProcName : PChar; ProcAdr : PFN) : Word;
function DosGetPrty(Scope : Word; var Priority : Word; ID : Word) : Word;
function DosGetResource(hmod : HMODULE; TypeID, NameID : Word; Selector : SEL) : Word;
function DosGetResource2(hmod : HMODULE; TypeID, NameID : Word;
  var ResAddr : pointer) : Word;
function DosGetSeg(Selector : Sel) : Word;
function DosGetShrSeg(Name : PChar; var Selector : Sel) : Word;
procedure DosGetVersion(var VersionWord : Word);
function DosGiveSeg(CallerSelector : Sel; ProcessID : PID;
  RecipientSelector : Sel) : Word;
function DosHoldSignal(EnableSignals : boolean) : Word;
function DosInsMessage(var lvTable; lvCount : Word; MsgInput : PChar;
  MsgInLength : Word; DataArea : PChar; DataLength : Word;
  var MsgLength : Word) : Word;
function DosKillProcess(KillDescendants : boolean; ProcessID : Word) : Word;
function DosLoadModule(ObjNameBuf : PChar; ObjNameBufLen : Word;
  ModuleName : PChar; var ModuleHandle : HModule) : Word;
function DosLockSeg(Selector : Sel) : Word;
function DosMakeNmPipe(PipeName : PChar; var hp : HPipe; OpenMode, PipeMode
  : Word; OutBufSize, InBufSize : Word; TimeOut : Longint) : Word;
function DosMakePipe(var ReadHandle, WriteHandle : HFile; PipeSize : Word) : Word;
function DosMemAvail(var MemAvailSize : Longint) : Word;
function DosMkDir(DirName : PChar; Reserved : Longint) : Word;
function DosMkDir2(DirName : PChar; var EABuf : TEAOP; Reserved : Longint) : Word;
function DosMonClose(Handle : HMonitor) : Word;
function DosMonOpen(Devname : PChar; var Handle : HMonitor) : Word;
function DosMonRead(var InputBuffer; Block : boolean; var DataBuffer;
  var ByteCnt : Word) : Word;
function DosMonReg(Handle : HMonitor; var InputBuffer, OutputBuffer;
  PosFlag : Word; Index : Word) : Word;
function DosMonWrite(var OutputBuffer, DataBuffer; Bytecnt : Word) : Word;
function DosMove(OldPathName, NewPathName : PChar; Reserved : Longint) : Word;
function DosMuxSemWait(var IndexNbr : Word; var ListAddr; Timeout : Longint) : Word;
function DosNewSize(FileHandle : HFile; FileSize : Longint) : Word;
function DosOpen(FileName : PChar; var FileHandle : HFile;
  var ActionTaken : Word; FileSize : Longint; FileAttr : Word;
  OpenFlag, OpenMode : Word; Reserved : Longint) : Word;
function DosOpen2(FileName : PChar; var FileHandle : HFile;
  var ActionTaken : Word; FileSize : Longint; FileAttr : Word;
  OpenFlag, OpenMode : Word; var EABuf : TEAOp; Reserved : Longint) : Word;
function DosOpenQueue(var OwnerPID : Word; var hqueue : HQueue;
  QueueName : PChar) : Word;
function DosOpenSem(var hs : HSem; SemName : PChar) : Word;
function DosPeekNmPipe(Handle : HPipe; var Buffer; BufferLen : Word;
  var BytesRead, BytesAvail, PipeState : Word) : Word;
function DosPeekQueue(hq : HQueue; var Request : Longint;
  var DataLength : Word; var DataAdr : Longint; Specified, NoWait : boolean;
  var ElemPriority: Byte; SemaphoreHandle : Longint) : Word;
{
function DosPFSActivate(var SplHandle; var BytesWritten : Longint;
  PrinterName : PChar; CodePage, FontID, SFN : Word; Reserved : Longint) : Word;
function DosPFSCloseUser(PrinterName : PChar; SFN : Word; Reserved : Longint) : Word;
function DosPFSInit(var CPHdw : Word; FontFileName, PrinterType, PrinterName : PChar;
  Instances : Word; Reserved : Longint) : Word;
function DosPFSQueryAct(PrinterName : PChar; var CodePage, FontID : Word;
   SFN : Word; Reserved : Longint) : Word;
function DosPFSVerifyFont(PrinterName : PChar; CodePage, FontID : Word;
   Reserved : Longint) : Word;
}
function DosPhysicalDisk(Funct : Word; var Data; DataLen : Word;
  var Parm; ParmLen : Word) : Word;
function DosPortAccess(Reserved, TypeOfAccess, FirstPort, LastPort : Word) : Word;
{
function DosPTrace(PtraceB : pointer) : Word;
}
function DosPurgeQueue(hq : HQueue) : Word;
function DosPutMessage(hf : Word; MessageLen : Word; MessageBuf : PChar) : Word;
function DosQAppType(ExeFileName : PChar; var AppType : Word) : Word;
function DosQCurDir(DriveNum : Word; DirPath : PChar; var DirPathLen : Word) : Word;
procedure DosQCurDisk(var DriveNum : Word; var LogicalDriveMap : Longint);
function DosQFHandState(hf : HFile; var FileHandleState : Word) : Word;
function DosQFileInfo(hf : HFile; FileInfoLevel : Word; var FileInfoBuf;
  FileInfoBufSize : Word) : Word;
function DosQFileMode(FilePathName : PChar; var CurrentAttr : Word;
  Reserved : Longint) : Word;
function DosQFSAttach(DeviceName : PChar; Ordinal, FSAInfoLevel : Word;
  var DataBuffer; var DataBufferLen : Word; Reserved : Longint) : Word;
function DosQFSInfo(DriveNum : Word; FSInfolevel : Word; var FSInfoBuf;
  FSInfoBufSize : Word) : Word;
function DosQHandType(hf : HFile; var HandType : Word; FlagWord : PWord) : Word;
function DosQNmPHandState(Handle : HPipe; var PipeHandleState : Word) : Word;
function DosQNmPipeInfo(Handle : HPipe; InfoLevel : Word; var InfoBuf;
  InfoBufSize : Word) : Word;
function DosQNmPipeSemState(hs : HSem; var InfoBuf; InfoBufLen : Word) : Word;
function DosQPathInfo(PathName : PChar; PathInfoLevel : Word; var PathInfoBuf;
  PathInfoBufSize : Word; Reserved : Longint) : Word;
function DosQSysInfo(Index : Word; var DataBuf; DataBufLen : Word) : Word;
function DosQueryQueue(hq : HQueue; var NumElements : Word) : Word;
function DosQVerify(var Active : Word) : Word;
function DosR2StackRealloc(NewSize : Word) : Word;
function DosRead(hf : HFile; var BufferArea; BufferLength : Word;
  var BytesRead : Word) : Word;
function DosReadAsync(hf : HFile; var RamSemaphore : Longint;
  var ReturnCode : Word; var Buffer; BufferLen : Word; var BytesRead : Word) : Word;
function DosReadQueue(hq : HQUEUE; var Request : Longint;
  var DataLength : Word; var DataAddress : Longint; ElementCode : Word;
  NoWait : boolean; var ElemPriority : Byte; SemaphoreHandle : HSEM) : Word;
function DosReallocHuge(NumSeg : Word; Size : Word; Selector : SEL) : Word;
function DosReallocSeg(Size : Word; Selector : SEL) : Word;
function DosResumeThread(ThreadID : TID) : Word;
function DosRmDir(DirName : PChar; Reserved : Longint) : Word;
function DosScanEnv(EnvVarName : PChar; ResultPointer : pointer) : Word;
function DosSearchPath(Control : Word; PathRef, FileName : PChar;
  var ResultBuffer; ResultBufferLen : Word) : Word;
function DosSelectDisk(DriveNumber : Word) : Word;
function DosSelectSession(SessID : Word; Reserved : Longint) : Word;
function DosSemClear(hs : HSEM) : Word;
function DosSemRequest(hs : HSEM; Timeout : Longint) : Word;
function DosSemSet(hs : HSEM) : Word;
function DosSemSetWait(hs : HSEM; Timeout : Longint) : Word;
function DosSemWait(hs : HSEM; Timeout : Longint) : Word;
function DosSendSignal(PID : Word; SigNumber : Word) : Word;
function DosSetCp(CodePage : Word; Reserved : Word) : Word;
function DosSetDateTime(var DTime : TDateTime) : BOOL;
function DosSetFHandState(hf : HFILE; FileHandleState : Word) : Word;
function DosSetFileInfo(hf : HFILE; FileInfoLevel : Word;
  var FileInfoBuf; FileInfoBufSize : Word) : Word;
function DosSetFileMode(FileName : PChar; NewAttrib : Word; Reserved : Longint) : Word;
function DosSetFSInfo(DriveNum : Word; FSInfoLevel : Word; var FSInfoBuf;
  FSInfoBufSize : Word) : Word;
function DosSetMaxFH(NumberHandles : Word) : Word;
function DosSetNmPHandState(hp : HPIPE; PipeHandleState : Word) : Word;
function DosSetNmPipeSem(hp : HPIPE; hs : HSEM; KeyHandle : Word) : Word;
function DosSetPathInfo(PathName : PChar; PathInfoLevel : Word; var PathInfoBuf;
  PathInfoBufSize, PathInfoFlags : Word; Reserved : Longint) : Word;
function DosSetProcCp(CodePage : Word; Reserved : Word) : Word;
function DosSetPrty(Scope, Class : Word; Delta : Integer; ID : Word) : Word;
function DosSetSession(SessID : Word; var StatData : TStatusData) : Word;
function DosSetSigHandler(Routine : pointer; PrevAddress : pointer;
  PrevAction : PWord; Action : Word; SigNumber : Word) : Word;
function DosSetVec(VecNum : Word; Routine : pointer; PrevAddress : pointer) : Word;
function DosSetVerify(Setting : boolean) : Word;
function DosSizeSeg(Selector : SEL; var Size : Longint) : Word;
function DosShutdown(Reserved : Longint) : Word;
function DosSleep(TimeInterval : Longint) : Word;
function DosSMRegisterDD(RegData : pointer) : Word;
function DosStartSession(var StData : TStartData; SessID, ProcID : PWord) : Word;
function DosStopSession(TargetOption : Word; SessID : Word; Reserved : Longint) : Word;
function DosSubAlloc(SegSel : SEL; var BlockOfs : Word; Size : Word) : Word;
function DosSubFree(SegSel : SEL; BlockOfs : Word; Size : Word) : Word;
function DosSubSet(SegSel : SEL; Init : boolean; Size : Word) : Word;
function DosSuspendThread(ThreadID : TID) : BOOL;
function DosTimerAsync(TimeInterval : Longint; hs : HSEM; var Handle : HTIMER) : Word;
function DosTimerStart(TimeInterval : Longint; hs : HSEM; var Handle : HTIMER) : Word;
function DosTimerStop(Handle : HTIMER) : Word;
function DosTransactNmPipe(hp : HPipe; var InBuffer; InBufferLen : Word;
  var OutBuffer; OutBufferLen : Word; var BytesOut : Word) : Word;
function DosUnlockSeg(Selector : Sel) : Word;
function DosWaitNmPipe(FileName : PChar; TimeOut : Longint) : Word;
function DosWrite(hf : HFile; var Buffer; BufferLen : Word;
  var BytesWritten : Word) : Word;
function DosWriteAsync(hf : HFile; var RamSemaphore : Longint;
  var ReturnCode : Word; var Buffer; BufferLen : Word;
  var BytesWritten: Word) : Word;
function DosWriteQueue(hq : HQueue; Request : Word; DataLen : Word;
  var DataBuffer; ElemPriority : Byte) : Word;

implementation

function DOSALLOCHUGE; external 'DOSCALLS' index 40;
function DOSALLOCSEG; external 'DOSCALLS' index 34;
function DOSALLOCSHRSEG; external 'DOSCALLS' index 35;
function DOSBEEP; external 'DOSCALLS' index 50;
function DOSBUFRESET; external 'DOSCALLS' index 56;
function DOSCALLNPIPE; external 'DOSCALLS' index 240;
procedure DOSCALLBACK; external 'DOSCALLS' index 157;
function DOSCASEMAP; external 'NLS' index 1;
function DOSCHDIR; external 'DOSCALLS' index 57;
function DOSCHGFILEPTR; external 'DOSCALLS' index 58;
function DOSCLIACCESS; external 'DOSCALLS' index 51;
function DOSCLOSE; external 'DOSCALLS' index 59;
function DOSCLOSEQUEUE; external 'QUECALLS' index 3;
function DOSCLOSESEM; external 'DOSCALLS' index 23;
function DOSCONNECTNMPIPE; external 'NAMPIPES' index 3;
function DOSCOPY; external 'DOSCALLS' index 201;
function DOSCREATECSALIAS; external 'DOSCALLS' index 43;
function DOSCREATEQUEUE; external 'QUECALLS' index 8;
function DOSCREATESEM; external 'DOSCALLS' index 24;
function DOSCREATETHREAD; external 'DOSCALLS' index 145;
function DOSCWAIT; external 'DOSCALLS' index 2;
function DOSDELETE; external 'DOSCALLS' index 60;
function DOSDEVCONFIG; external 'DOSCALLS' index 52;
function DOSDEVIOCTL; external 'DOSCALLS' index 53;
function DOSDEVIOCTL2; external 'DOSCALLS' index 99;
function DOSDISCONNECTNMPIPE; external 'NAMPIPES' index 4;
function DOSDUPHANDLE; external 'DOSCALLS' index 61;
function DOSEDITNAME; external 'DOSCALLS' index 191;
function DOSENTERCRITSEC; external 'DOSCALLS' index 3;
function DOSENUMATTRIBUTE; external 'DOSCALLS' index 204;
function DOSERRCLASS; external 'DOSCALLS' index 139;
function DOSERROR; external 'DOSCALLS' index 120;
function DOSEXECPGM; external 'DOSCALLS' index 144;
procedure DOSEXIT; external 'DOSCALLS' index 5;
function DOSEXITCRITSEC; external 'DOSCALLS' index 6;
function DOSEXITLIST; external 'DOSCALLS' index 7;
function DOSFILEIO; external 'DOSCALLS' index 186;
function DOSFILELOCKS; external 'DOSCALLS' index 62;
function DOSFINDCLOSE; external 'DOSCALLS' index 63;
function DOSFINDFIRST; external 'DOSCALLS' index 64;
function DOSFINDFIRST2; external 'DOSCALLS' index 184;
function DOSFINDNEXT; external 'DOSCALLS' index 65;
function DOSFLAGPROCESS; external 'DOSCALLS' index 15;
function DOSFREEMODULE; external 'DOSCALLS' index 46;
function DOSFREERESOURCE; external 'DOSCALLS' index 208;
function DOSFREESEG; external 'DOSCALLS' index 39;
function DOSFSATTACH; external 'DOSCALLS' index 181;
function DOSFSCTL; external 'DOSCALLS' index 183;
function DOSFSRAMSEMCLEAR; external 'DOSCALLS' index 162;
function DOSFSRAMSEMREQUEST; external 'DOSCALLS' index 161;
function DOSGETCOLLATE; external 'NLS' index 2;
function DOSGETCP; external 'DOSCALLS' index 130;
function DOSGETCTRYINFO; external 'NLS' index 3;
procedure DOSGETDATETIME; external 'DOSCALLS' index 33;
function DOSGETDBCSEV; external 'NLS' index 4;
function DOSGETENV; external 'DOSCALLS' index 91;
procedure DOSGETHUGESHIFT; external 'DOSCALLS' index 41;
function DOSGETINFOSEG; external 'DOSCALLS' index 8;
procedure DOSGETMACHINEMODE; external 'DOSCALLS' index 49;
function DOSGETMESSAGE; external 'MSG' index 2;
function DOSGETMODHANDLE; external 'DOSCALLS' index 47;
function DOSGETMODNAME; external 'DOSCALLS' index 48;
procedure DOSGETPID; external 'DOSCALLS' index 94;
function DOSGETPPID; external 'DOSCALLS' index 156;
function DOSGETPROCADDR; external 'DOSCALLS' index 45;
function DOSGETPRTY; external 'DOSCALLS' index 9;
function DOSGETRESOURCE; external 'DOSCALLS' index 155;
function DOSGETRESOURCE2; external 'DOSCALLS' index 207;
function DOSGETSEG; external 'DOSCALLS' index 121;
function DOSGETSHRSEG; external 'DOSCALLS' index 36;
procedure DOSGETVERSION; external 'DOSCALLS' index 92;
function DOSGIVESEG; external 'DOSCALLS' index 37;
function DOSHOLDSIGNAL; external 'DOSCALLS' index 13;
function DOSINSMESSAGE; external 'MSG' index 3;
function DOSKILLPROCESS; external 'DOSCALLS' index 10;
function DOSLOADMODULE; external 'DOSCALLS' index 44;
function DOSLOCKSEG; external 'DOSCALLS' index 122;
function DOSMAKENMPIPE; external 'NAMPIPES' index 1;
function DOSMAKEPIPE; external 'DOSCALLS' index 16;
function DOSMEMAVAIL; external 'DOSCALLS' index 127;
function DOSMKDIR; external 'DOSCALLS' index 66;
function DOSMKDIR2; external 'DOSCALLS' index 185;
function DOSMONCLOSE; external 'MONCALLS' index 3;
function DOSMONOPEN; external 'MONCALLS' index 4;
function DOSMONREAD; external 'MONCALLS' index 2;
function DOSMONREG; external 'MONCALLS' index 5;
function DOSMONWRITE; external 'MONCALLS' index 1;
function DOSMOVE; external 'DOSCALLS' index 67;
function DOSMUXSEMWAIT; external 'DOSCALLS' index 22;
function DOSNEWSIZE; external 'DOSCALLS' index 68;
function DOSOPEN; external 'DOSCALLS' index 70;
function DOSOPEN2; external 'DOSCALLS' index 95;
function DOSOPENQUEUE; external 'QUECALLS' index 7;
function DOSOPENSEM; external 'DOSCALLS' index 25;
function DOSPEEKNMPIPE; external 'NAMPIPES' index 7;
function DOSPEEKQUEUE; external 'QUECALLS' index 5;
function DOSPHYSICALDISK; external 'DOSCALLS' index 129;
function DOSPORTACCESS; external 'DOSCALLS' index 69;
function DOSPURGEQUEUE; external 'QUECALLS' index 2;
function DOSPUTMESSAGE; external 'MSG' index 1;
function DOSQAPPTYPE; external 'DOSCALLS' index 163;
function DOSQCURDIR; external 'DOSCALLS' index 71;
procedure DOSQCURDISK; external 'DOSCALLS' index 72;
function DOSQFHANDSTATE; external 'DOSCALLS' index 73;
function DOSQFILEINFO; external 'DOSCALLS' index 74;
function DOSQFILEMODE; external 'DOSCALLS' index 75;
function DOSQFSATTACH; external 'DOSCALLS' index 182;
function DOSQFSINFO; external 'DOSCALLS' index 76;
function DOSQHANDTYPE; external 'DOSCALLS' index 77;
function DOSQNMPHANDSTATE; external 'NAMPIPES' index 5;
function DOSQNMPIPEINFO; external 'NAMPIPES' index 2;
function DOSQNMPIPESEMSTATE; external 'NAMPIPES' index 14;
function DOSQPATHINFO; external 'DOSCALLS' index 98;
function DOSQSYSINFO; external 'DOSCALLS' index 166;
function DOSQUERYQUEUE; external 'QUECALLS' index 4;
function DOSQVERIFY; external 'DOSCALLS' index 78;
function DOSR2STACKREALLOC; external 'DOSCALLS' index 160;
function DOSREAD; external 'DOSCALLS' index 137;
function DOSREADASYNC; external 'DOSCALLS' index 149;
function DOSREADQUEUE; external 'QUECALLS' index 1;
function DOSREALLOCHUGE; external 'DOSCALLS' index 42;
function DOSREALLOCSEG; external 'DOSCALLS' index 38;
function DOSRESUMETHREAD; external 'DOSCALLS' index 26;
function DOSRMDIR; external 'DOSCALLS' index 80;
function DOSSCANENV; external 'DOSCALLS' index 152;
function DOSSEARCHPATH; external 'DOSCALLS' index 151;
function DOSSELECTDISK; external 'DOSCALLS' index 81;
function DOSSELECTSESSION; external 'SESMGR' index 9;
function DOSSEMCLEAR; external 'DOSCALLS' index 141;
function DOSSEMREQUEST; external 'DOSCALLS' index 140;
function DOSSEMSET; external 'DOSCALLS' index 143;
function DOSSEMSETWAIT; external 'DOSCALLS' index 20;
function DOSSEMWAIT; external 'DOSCALLS' index 142;
function DOSSENDSIGNAL; external 'DOSCALLS' index 134;
function DOSSETCP; external 'DOSCALLS' index 153;
function DOSSETDATETIME; external 'DOSCALLS' index 28;
function DOSSETFHANDSTATE; external 'DOSCALLS' index 82;
function DOSSETFILEINFO; external 'DOSCALLS' index 83;
function DOSSETFILEMODE; external 'DOSCALLS' index 84;
function DOSSETFSINFO; external 'DOSCALLS' index 97;
function DOSSETMAXFH; external 'DOSCALLS' index 85;
function DOSSETNMPHANDSTATE; external 'NAMPIPES' index 6;
function DOSSETNMPIPESEM; external 'NAMPIPES' index 13;
function DOSSETPATHINFO; external 'DOSCALLS' index 104;
function DOSSETPROCCP; external 'DOSCALLS' index 164;
function DOSSETPRTY; external 'DOSCALLS' index 11;
function DOSSETSESSION; external 'SESMGR' index 14;
function DOSSETSIGHANDLER; external 'DOSCALLS' index 14;
function DOSSETVEC; external 'DOSCALLS' index 89;
function DOSSETVERIFY; external 'DOSCALLS' index 86;
function DOSSHUTDOWN; external 'DOSCALLS' index 206;
function DOSSIZESEG; external 'DOSCALLS' index 126;
function DOSSLEEP; external 'DOSCALLS' index 32;
function DOSSMREGISTERDD; external 'SESMGR' index 29;
function DOSSTARTSESSION; external 'SESMGR' index 17;
function DOSSTOPSESSION; external 'SESMGR' index 8;
function DOSSUBALLOC; external 'DOSCALLS' index 147;
function DOSSUBFREE; external 'DOSCALLS' index 148;
function DOSSUBSET; external 'DOSCALLS' index 146;
function DOSSUSPENDTHREAD; external 'DOSCALLS' index 27;
function DOSTIMERASYNC; external 'DOSCALLS' index 29;
function DOSTIMERSTART; external 'DOSCALLS' index 30;
function DOSTIMERSTOP; external 'DOSCALLS' index 31;
function DOSTRANSACTNMPIPE; external 'NAMPIPES' index 9;
function DOSUNLOCKSEG; external 'DOSCALLS' index 123;
function DOSWAITNMPIPE; external 'NAMPIPES' index 8;
function DOSWRITE; external 'DOSCALLS' index 138;
function DOSWRITEASYNC; external 'DOSCALLS' index 150;
function DOSWRITEQUEUE; external 'QUECALLS' index 6;

end.
