/**********************************************************************/
/* Install Problem Determination package for OS/2 2.x                 */
/**********************************************************************/

ECHO OFF;

/**********************************************************************/
/* Variable Dictionary                                                */
/*                                                                    */
/* BootDrive       User's boot drive                                  */
/* ConfigPopDrive  SuppressPopUps= drive from the CONFIG.SYS file     */
/* ConfigProcDrive DumpProcess= drive from the CONFIG.SYS file        */
/* ConfigTrapDrive TrapDump= drive from the CONFIG.SYS file           */
/* DelFiles        Delete installation files? (Y=Yes)                 */
/* DiskNum         Diskette sequence number                           */
/* FileFound       File name found during file search                 */
/* FileOS2KRNL     OS2KRNL file                                       */
/* FileSearch      File name to search for on disk/diskette           */
/* InFileConfig    CONFIG.SYS file used as an input file              */
/* InstPath        Path where the problem det code is installed       */
/* KRNLDate        Date of OS2KRNL file                               */
/* KRNLTS          Date/time of OS2KRNL file                          */
/* Line            Input statement from the CONFIG.SYS file           */
/* LineBuf.n       TraceBuf= stmt from the CONFIG.SYS file            */
/* LineDDInfo.n    Device=DDInfo.SYS stmt from the CONFIG.SYS file    */
/* LineLength      Length of the input statement from CONFIG.SYS file */
/* LinePopUp.n     SuppressPopUps= stmt from the CONFIG.SYS file      */
/* LineProc.n      DumpProcess= stmt from the CONFIG.SYS file         */
/* LineTrace.n     Trace= stmt from the CONFIG.SYS file               */
/* LineTrap.n      TrapDump= stmt from the CONFIG.SYS file            */
/* Medium          Install code is on diskette, hard file, CD ROM?    */
/* ok              "Pull" variable to allow user to continue          */
/* Option          OS2KRNL option selected by user                    */
/* OutFileLog      Run-time log for PDP install/de-install            */
/* PathCheck.n     Does install path exist?                           */
/*                                                                    */
/**********************************************************************/

CALL RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
CALL SysLoadFuncs;

Env = "OS2ENVIRONMENT";

SAY " ";
SAY "Initializing...";


/**********************************************************************/
/* Determine boot drive, dump drive, and PopUpSuppression Log drive   */
/**********************************************************************/

BootDrive       = SUBSTR(value('SYSTEM_INI',,Env),1,1);
InFileConfig    = BootDrive || ":\Config.SYS";

OutFileLog      = BootDrive || ":\PDPRun.LOG";
rc = SysFileDelete(OutFileLog);   /* Erase any old versions of log    */

Line = LINEOUT(OutFileLog, "----- START OF PDPInst -----");
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, Date(Language) Time());
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, "This is the run-time log for the   ");
Line = LINEOUT(OutFileLog, "OS/2 Problem Determination install ");
Line = LINEOUT(OutFileLog, "and de-install.  It can be deleted ");
Line = LINEOUT(OutFileLog, "at any time without affecting the  ");
Line = LINEOUT(OutFileLog, "Problem Determination functions.   ");

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Search CONFIG.SYS for keywords:");

LineTrap        = " ";
ConfigTrapDrive = " ";
LinePopUp       = " ";
ConfigPopDrive  = " ";
LineProc        = " ";
ConfigProcDrive = " ";


CALL SysFileSearch 'TrapDump',       InFileConfig, 'LineTrap.';
CALL SysFileSearch 'DumpProcess',    InFileConfig, 'LineProc.';
CALL SysFileSearch 'SuppressPopUps', InFileConfig, 'LinePopUp.';

Line = LINEOUT(OutFileLog,,
   "  TrapDump       " LineTrap.0  LineTrap.1);
Line = LINEOUT(OutFileLog,,
   "  DumpProcess    " LineProc.0  LineProc.1);
Line = LINEOUT(OutFileLog,,
   "  SuppressPopUps " LinePopUp.0 LinePopUp.1);

If LineTrap.0 > 0 then do;
   LineTrap.1= STRIP(LineTrap.1); /* Remove leading & trailing blanks */
   If SUBSTR(LineTrap.1, 1, 3) = "REM" then do;
      LineTrap.0 = 0;
      Line = LINEOUT(OutFileLog,,
         "TRAPDUMP assignment statement is commented out in",
         "the CONFIG.SYS file.");
   End;
   Else do;
      LineLength = LENGTH(LineTrap.1);
      If SUBSTR(LineTrap.1, LineLength, 1) <> ':' then do;
         LineTrap.0 = 0;
         Line = LINEOUT(OutFileLog,,
            "TRAPDUMP assignment does not have format of 'x:',",
            "where x is the drive letter.");
      End;
      Else
         If (SUBSTR(LineTrap.1, LineLength-1,1) = 'A',
            | SUBSTR(LineTrap.1, LineLength-1,1) = 'B') then do;
            LineTrap.0 = 0;
            Line = LINEOUT(OutFileLog,,
               "TRAPDUMP assignment is A or B");
         End;
         Else ConfigTrapDrive = SUBSTR(LineTrap.1, LineLength-1,1);
   End;                           /* End Else do                      */
End;                              /* End If LineTrap.0 > 0            */

If LinePopUp.0 > 0 then do;
   LinePopUp.1 = STRIP(LinePopUp.1); /* Remove lead & trailing blanks */
   If SUBSTR(LinePopUp.1, 1, 3) = "REM" then do;
      LinePopUp.0 = 0;
      Line = LINEOUT(OutFileLog,,
         "SuppressPopUps assignment statement is commented out",
         "in the CONFIG.SYS file.");
   End;
   Else do;
      LineLength = LENGTH(LinePopUp.1);
      If SUBSTR(LinePopUp.1, LineLength, 1) = ':' then
         ConfigPopDrive = SUBSTR(LinePopUp.1, LineLength-1,1);
      Else do;
         LinePopUp.0 = 0;
         Line = LINEOUT(OutFileLog,,
            "SuppressPopUps assignment does not have format",
            "of 'x:', where x is the drive letter.");
      End;                        /* End Else do                      */
   End;                           /* End Else do                      */
End;                              /* End If LinePopUp.0 > 0           */

If LineProc.0 > 0 then do;
   LineProc.1 = STRIP(LineProc.1);   /* Remove lead & trailing blanks */
   If SUBSTR(LineProc.1, 1, 3) = "REM" then do;
      LineProc.0 = 0;
      Line = LINEOUT(OutFileLog,,
         "DumpProcess assignment statement is commented out",
         "in the CONFIG.SYS file.");
   End;
   Else do;
      LineLength = Length(LineProc.1);
      If SUBSTR(LineProc.1, LineLength, 1) = ':' then
         ConfigProcDrive = SUBSTR(LineProc.1, LineLength-1,1);
      Else do;
         LineProc.0 = 0;
         Line = LINEOUT(OutFileLog,,
            "DumpProcess assignment does not have format",
            "of 'x:', where x is the drive letter.");
      End;                        /* End Else do                      */
   End;                           /* End Else do                      */
End;                              /* End If LineProc.0 > 0            */


/**********************************************************************/
/* Ensure user is in the path with the install code                   */
/**********************************************************************/

FileSearch   = "PDPInst.CMD";
FileFound    = STREAM(FileSearch, "c", "query exists");

If FileFound = " " then do;       /* User is not in install path      */
   BEEP(262, 250);                /* Alert user with a beep           */
   SAY " ";
   SAY "If you are installing from the command line, you must";
   SAY "be in the path that contains the install code.  Please";
   SAY "change directories and try again.";
   SAY " ";
   SAY "Done...";
   SAY " ";
   CALL SysSleep 2;
   Line = LINEOUT(OutFileLog, " ");
   Line = LINEOUT(OutFileLog, "User is not in the install path.");
   Line = LINEOUT(OutFileLog, "FileSearch          = " FileSearch);
   Line = LINEOUT(OutFileLog, "FileFound           = " FileFound);
   Line = LINEOUT(OutFileLog, " ");
   Line = LINEOUT(OutFileLog, "----- END OF PDPInst -----");
   EXIT;
End;                              /* End If FileFound = null          */


/**********************************************************************/
/* Get PDP Install path from user                                     */
/**********************************************************************/

Do forever;
   SAY " ";
   SAY " ";
   SAY "Install path default is '" || BootDrive || ":\OS2\PDPSI'.";
   SAY " ";
   SAY "Please tell me the new install drive and path (x:[\path])...";
   SAY "or type 'E' to exit...";
   SAY "or press Enter to set it to '" || BootDrive || ":\OS2\PDPSI'.";
   SAY " ";

   Pull InstPath;

   If (InstPath = "E" | InstPath = "EXIT") then do;
      Line = LINEOUT(OutFileLog, "User typed EXIT.");
      Line = LINEOUT(OutFileLog, "----- END OF PDPInst -----");
      EXIT;
   End;

   If InstPath = " " then do;
      InstPath = BootDrive || ":\OS2\PDPSI";
      LEAVE;
   End;                           /* End If InstPath = " "            */
   Else do;
      InstPath = STRIP(InstPath, "t", "\");
      If SUBSTR(InstPath, 2, 1) <> ":" then do;
         BEEP(262, 250);          /* Alert user with a beep           */
         SAY " ";
         SAY "ERROR:  format of install path must be x:[\path]";
      End;                        /* End Else do                      */
      Else
         If (LENGTH(InstPath)) > 2 then
            If SUBSTR(InstPath, 3, 1) <> "\" then do;
               BEEP(262, 250);    /* Alert user with a beep           */
               SAY " ";
               SAY "ERROR:  format of install path must be x:\path";
            End;                  /* End If LENGTH(InstPath) > 2      */
            Else
               If (POS("\", InstPath, 4)) > 0 then do;
                  Call SysFileTree InstPath, 'PathCheck.', 'SD';
                  If PathCheck.0 = 0 then do;
                     BEEP(262, 250); /* Alert user with a beep        */
                     SAY " ";
                     SAY "ERROR:  cannot find specified directory.";
                     SAY "        Please create the directory, then",
                        "try again";
                  End;
                  Else LEAVE;
               End;               /* End If POS > 0                   */
               Else LEAVE;
         Else LEAVE;
   End;                           /* End Else do                      */
End;                              /* End Do forever                   */


/**********************************************************************/
/* Remind user to re-boot after installation is complete              */
/**********************************************************************/

SAY " ";
SAY " ";
SAY "**********";
SAY " ";
SAY "WARNING:  you must re-boot after installation is complete";
SAY "in order for OS2DUMP changes to take effect!";
SAY " ";
SAY "Prior to re-booting, please review the instructions in the";
SAY "ReadMe file regarding the PMMLE.DLL and CONFIG.PDP files.";
SAY " ";
SAY "Please press Enter to continue.";
SAY " ";
SAY "**********";
SAY " ";
Pull ok;

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Path/Drive values:");
Line = LINEOUT(OutFileLog, "BootDrive           = " BootDrive);
Line = LINEOUT(OutFileLog, "InstPath            = " InstPath);
Line = LINEOUT(OutFileLog, "ConfigPopDrive      = " ConfigPopDrive);
Line = LINEOUT(OutFileLog, "ConfigProcDrive     = " ConfigProcDrive);
Line = LINEOUT(OutFileLog, "ConfigTrapDrive     = " ConfigTrapDrive);

SAY "Installing Problem Determination package for OS/2 2.x...";


/**********************************************************************/
/* See if user is installing w/diskettes or not                       */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Ask for diskettes if needed:");

Medium = 2;                       /* Set initial value to "hardfile"  */

FileSearch = "ReadMe";
FileFound  = STREAM(FileSearch, "c", "query exists");
Line = LINEOUT(OutFileLog, "ReadMe FileFound = " || FileFound);

If FileFound = " " then do;       /* Assume user has diskettes        */
   Medium    = 1;                 /* Change to "diskette"             */
   DiskNum   = 1;
   Line = LINEOUT(OutFileLog,,
      "ReadMe file not found... assume user has diskettes.");
   Do forever;
      SAY " ";
      SAY "Please insert OS2PDP diskette #" || DiskNum ||,
          ", then press Enter...";
      SAY "or type 'E' to exit (abort installation).";
      Pull ok;
      If (ok = "E" | ok = "EXIT") then do;
         Line = LINEOUT(OutFileLog, "User typed EXIT.");
         Line = LINEOUT(OutFileLog, "----- END OF PDPInst -----");
         Line = LINEOUT(OutFileLog); /* Close the file                */
         EXIT;
      End;                        /* End If FileFound = EXIT          */
      FileFound = STREAM(FileSearch, "c", "query exists");
      If FileFound <> "" then LEAVE;
   End;                           /* End Do forever                   */
   SAY "Installing...";
End;                              /* End If FileFound = null          */


/**********************************************************************/
/* Create directories                                                 */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Create directories:");

rc = SysMkDir(InstPath);
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath                 RC = " rc);

rc = SysMkDir(InstPath || "\PMDF");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\PMDF            RC = " rc);

rc = SysMkDir(InstPath || "\PMDF\GA21");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\PMDF\GA21       RC = " rc);

rc = SysMkDir(InstPath || "\PMDF\GA21MR1");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\PMDF\GA21MR1    RC = " rc);

rc = SysMkDir(InstPath || "\PMDF\GA21S3");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\PMDF\GA21S3     RC = " rc);

rc = SysMkDir(InstPath || "\Trace");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\Trace           RC = " rc);

rc = SysMkDir(InstPath || "\Trace\GA21");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\Trace\GA21      RC = " rc);

rc = SysMkDir(InstPath || "\Trace\GA21MR1");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\Trace\GA21MR1   RC = " rc);

rc = SysMkDir(InstPath || "\Trace\GA21S3");
Line = LINEOUT(OutFileLog,,
   "SysMkDir InstPath\Trace\GA21S3    RC = " rc);


/**********************************************************************/
/* Install files                                                      */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Install files:");

/*-------------------------*/
/* Copy ReadMe             */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   "Copy ReadMe InstPath\OS2PDP.RME");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD,
   "Copy ReadMe" InstPath || "\OS2PDP.RMe",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Copy UnPack2            */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   "Copy UnPack2.Exe InstPath\*.*");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD,
   "Copy UnPack2.Exe" InstPath || "\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Unpack Misc files       */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack Misc.Pk@ into install dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   Misc.Pk@"       InstPath,
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Copy PDPKill to BootDr  */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\PDPKill.CMD BootDrive:\*.*");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD,
   "Copy" InstPath||"\PDPKill.CMD"  BootDrive||":\*.*",
   "1>>" OutFileLog "2>>&1";

/*-------------------------*/
/* Unpack Trace files      */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack Trace.Pk@ into Trace dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   Trace.Pk@"      InstPath||"\Trace",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack TRGA21.Pk@ into GA21 dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   TRGA21.Pk@"     InstPath||"\Trace\GA21",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack TRGA21MR.Pk@ into GA21MR1 dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   TRGA21MR.Pk@"   InstPath||"\Trace\GA21MR1",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack TRGA21S3.Pk@ into GA21MS3 dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   TRGA21S3.Pk@"   InstPath||"\Trace\GA21S3",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Unpack PMDF files       */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack DFGA21.Pk@ into GA21 dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   DFGA21.Pk@"     InstPath||"\PMDF\GA21",
   "1>>" OutFileLog "2>>&1";

/*-------------------------*/
/* Diskette #2             */
/*-------------------------*/
FileSearch = "PMDF.Pk@";
FileFound  = STREAM(FileSearch, "c", "query exists");
Line = LINEOUT(OutFileLog, "PMDF.Pk@ FileFound = " || FileFound);

If FileFound = " " then do;       /* Assume user has diskettes        */
   Medium    = 1;
   DiskNum   = 2;
   Line = LINEOUT(OutFileLog,,
      "PMDF.Pk@ file not found... assume user has diskettes.");
   Do forever;
      SAY " ";
      SAY "Please insert OS2PDP diskette #" || DiskNum ||,
         ", then press Enter...";
      SAY "or type 'E' to exit (abort installation).";
      Pull ok;
      If (ok = "E" | ok = "EXIT") then do;
         Line = LINEOUT(OutFileLog, "User typed EXIT.");
         CALL Cleanup InstPath;
         Line = LINEOUT(OutFileLog, "----- END OF PDPInst -----");
         Line = LINEOUT(OutFileLog); /* Close the file               */
         ADDRESS CMD "CALL",
            BootDrive || ":\PDPKill.CMD",
            InstPath BootDrive "ABEND";
         EXIT;
      End;                        /* End If FileFound = EXIT          */
      FileFound  = STREAM(FileSearch, "c", "query exists");
      If FileFound <> "" then LEAVE;
   End;                           /* End Do forever                   */
   SAY "Installing...";
End;                              /* End If FileFound = null          */

/*-------------------------*/
/* Unpack more PMDF files  */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack PMDF.Pk@ into PMDF dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   PMDF.Pk@"       InstPath||"\PMDF",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack DFGA21MR.Pk@ into GA21MR1 dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   DFGA21MR.Pk@"   InstPath||"\PMDF\GA21MR1",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack DFGA21S3.Pk@ into GA21MS3 dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL ",
   InstPath||"\UnPack2   DFGA21S3.Pk@"   InstPath||"\PMDF\GA21S3",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Unpack SysLog files     */
/*-------------------------*/
Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Unpack SysLog.Pk@ into install dir:");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD "CALL "
   InstPath||"\UnPack2   SysLog.Pk@"     InstPath,
   "1>>" OutFileLog "2>>&1";

Line = LINEOUT(OutFileLog,,
   "1:Diskette 2:HardFile 3:CDRom =" Medium);


/**********************************************************************/
/* Install PMDF files                                                 */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Install PMDF files:");

/*-------------------------*/
/* Remove old PMDFVers.Lst */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\PMDF\PMDFVers.Lst InstPath\PMDF\PMDFVers.Old");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath||"\PMDF\PMDFVers.Lst",
   InstPath||"\PMDF\PMDFVers.Old",
   "1>>" OutFileLog "2>>&1";

rc = SysFileDelete(InstPath || "\PMDF\PMDFVers.Lst");
Line = LINEOUT(OutFileLog,,
   "SysFileDelete PMDF\PMDFVers.Lst     RC = " rc);

/*-------------------------*/
/* Copy PMDF Trace file    */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\PMDF\Trc000A.TFF BootDrive\OS2\System\Trace\*.*");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath||"\PMDF\TRC000A.TFF",
   BootDrive||":\OS2\System\Trace\*.*",
   "1>>" OutFileLog "2>>&1";

/**********************************************************************/
/* Install SysLog files                                               */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Install SysLog files:");
/*-------------------------*/
/* Make backups            */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy OS2\SysLog.EXE OS2\SysLog.PDP");
Line = LINEOUT(OutFileLog);       /* Close the file                   */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\SysLog.PDP ",
   "Copy" BootDrive || ":\OS2\SysLog.EXE",
   BootDrive || ":\OS2\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy OS2\SysLogPM.EXE OS2\SysLogPM.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\SysLogPM.PDP",
   "Copy" BootDrive || ":\OS2\SysLogPM.EXE",
   BootDrive || ":\OS2\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy OS2\DLL\SysLog.DLL OS2\DLL\SysLog.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\DLL\SysLog.PDP",
   "Copy" BootDrive || ":OS2\DLL\SysLog.DLL",
   BootDrive || ":\OS2\DLL\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy OS2\HELP\SysLogH.HLP OS2\HELP\SysLogH.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\HELP\SysLogH.PDP",
   "Copy" BootDrive || ":OS2\HELP\SysLogH.HLP",
   BootDrive || ":\OS2\HELP\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Update files            */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\SysLog.EXE OS2\SysLog.EXE");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\SysLog.EXE",
   BootDrive || ":\OS2\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\SysLogPM.EXE OS2\SysLogPM.EXE");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\SysLogPM.EXE",
   BootDrive || ":\OS2\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\SysLog.DLL OS2\DLL\SysLog.DLL");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\SysLog.DLL",
   BootDrive || ":\OS2\DLL\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\SysLogH.HLP OS2\HELP\SysLogH.HLP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\SysLogH.HLP",
   BootDrive || ":\OS2\HELP\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Hide files              */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\SysLog.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\SysLog.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\SysLogPM.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\SysLogPM.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\DLL\SysLog.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\DLL\SysLog.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\HELP\SysLogH.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\HELP\SysLogH.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/


/**********************************************************************/
/* Install Trace files                                                */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, ">> Install Trace files:");
/*-------------------------*/
/* Backup files            */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy \OS2\Trace.EXE \OS2\*.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\Trace.PDP",
   "Copy" BootDrive || ":\OS2\Trace.EXE",
   BootDrive || ":\OS2\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy \OS2\TraceFMT.EXE \OS2\*.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\TraceFMT.PDP",
   "Copy" BootDrive || ":\OS2\TraceFMT.EXE",
   BootDrive || ":\OS2\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy \OS2\DLL\TraceFMT.DLL \OS2\DLL\*.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\DLL\TraceFMT.PDP",
   "Copy" BootDrive || ":\OS2\DLL\TraceFMT.DLL",
   BootDrive || ":\OS2\DLL\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy \OS2\HELP\TraceFMT.HLP \OS2\HELP\*.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2\HELP\TraceFMT.PDP",
   "Copy" BootDrive || ":\OS2\HELP\TraceFMT.HLP",
   BootDrive || ":\OS2\HELP\*.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Update files            */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\Trace\Trace.EXE OS2\Trace.EXE");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\Trace\Trace.EXE",
   BootDrive || ":\OS2\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\Trace\TraceFMT.EXE OS2\TraceFMT.EXE");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\Trace\TraceFMT.EXE",
   BootDrive || ":\OS2\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\Trace\TraceFMT.DLL OS2\DLL\TraceFMT.DLL");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\Trace\TraceFMT.DLL",
   BootDrive || ":\OS2\DLL\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\Trace\TraceFMT.HLP OS2\HELP\TraceFMT.HLP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\Trace\TraceFMT.HLP",
   BootDrive || ":\OS2\HELP\*.*",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
/* Hide files              */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\Trace.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\Trace.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\TraceFMT.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\TraceFMT.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\DLL\TraceFMT.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\DLL\TraceFMT.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide BootDrive:\OS2\HELP\TraceFMT.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2\HELP\TraceFMT.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/


/**********************************************************************/
/* Install Trace Customization files                                  */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   ">> Install Trace CUSTOMIZATION files:");
/*-------------------------*/
/* Un-hide OS2KRNL         */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Un-hide OS2KRNL file and get timestamp.");
Line = LINEOUT(OutFileLog); /* Close the file                         */

/* Query the Date of the OS2 Kernal file to determine release level  */

ADDRESS CMD,
   "Attrib -h       " BootDrive || ":\OS2KRNL",
   "1>>" OutFileLog "2>>&1";

FileOS2KRNL = BootDrive || ":\OS2KRNL";
KRNLTS = STREAM(FileOS2KRNL, "c", "query datetime");
/*-------------------------*/
/* Hide OS2KRNL            */
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Re-hide OS2KRNL file.");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2KRNL",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/

If KRNLTS = "" then do;
   SAY "OS2KRNL file does not exist!";
   Line = LINEOUT(OutFileLog,,
      "File" BootDrive || ":\OS2KRNL does not exist! ");
   CALL Cleanup InstPath;
   Line = LINEOUT(OutFileLog, "----- ABEND OF PDPInst -----");
   Line = LINEOUT(OutFileLog); /* Close the file                      */
   ADDRESS CMD "CALL",
      BootDrive || ":\PDPKill.CMD" InstPath BootDrive "ABEND";
   EXIT;
End;                      /* If KRNLTS = null                         */

KRNLDate = SUBSTR(KRNLTS,1,8);
Line = LINEOUT(OutFileLog,,
   "OS2KRNL file date = " KRNLDate);

/*-------------------------*/
If KRNLDate = "05-06-93" then Option = 1;             /* GA21         */
Else If KRNLDate = "02-12-94" then Option = 2;        /* GA21MR1      */
   Else If KRNLDate = "10-20-93" then Option = 3;     /* GA21S3       */
      Else do;                            /* Unrecognizable version   */
         BEEP(262, 250);                  /* Alert user with a beep   */
         SAY  "*****";
         SAY  " ";
         SAY  "OS2 release level is not recognized!";
         SAY  " ";
         SAY  "Please tell me your OS/2 release level (1-3 below).";
         SAY  "If you do not choose 1, 2, or 3, you must install";
         SAY  "the trace files manually or abort the installation.";
         Option = 0;
         Do forever;
            SAY  " ";
            SAY  "Please choose an option...";
            SAY  "  1. OS/2 GA21";
            SAY  "  2. OS/2 GA21 Service Pack (SP) or ";
            SAY  "     Manufacturing Refresh (MR1)";
            SAY  "  3. OS/2 GA21 S3 Video";
            SAY  "  4. Manually install trace files",
                "(continue installation)";
            SAY  "  5. Abort installation";
            SAY  " ";
            Pull Option;
            If (Option = 1 |,
               Option  = 2 |,
               Option  = 3 |,
               Option  = 4 |,
               Option  = 5) then LEAVE;
         End;                             /* End Do forever           */
         Line = LINEOUT(OutFileLog, " ");
         Line = LINEOUT(OutFileLog,,
            "OS2KRNL is not recognizable based on the file date");
         Line = LINEOUT(OutFileLog,,
            "User chose option " Option);
         If Option = 5 then do;
            CALL Cleanup InstPath;
            Line = LINEOUT(OutFileLog, " ");
            Line = LINEOUT(OutFileLog, "----- ABEND OF PDPInst -----");
            Line = LINEOUT(OutFileLog);   /* Close the file           */
            ADDRESS CMD "CALL",
               BootDrive || ":\PDPKill.CMD",                            ||,
               InstPath BootDrive "ABEND";
            EXIT;
         End;                             /* End If option = 5        */
      End;                                /* End Else do (?version)   */
/*-------------------------*/

If (Option = 1 | Option = 4) then NOP;    /* GA21 or manually install */
Else do;
   /*-------------------------*/
   Line = LINEOUT(OutFileLog,,
      "If not exist Copy BootDrive:\OS2\system\trace\SYSTEM.TDF");
   Line = LINEOUT(OutFileLog,,
      "   BootDrive:\OS2\system\trace\SYS_TDF.PDP");
   Line = LINEOUT(OutFileLog); /* Close the file                      */

   ADDRESS CMD,
      "If not exist" BootDrive || ":\OS2\system\trace\SYS_TDF.PDP",
      "Copy" BootDrive || ":\OS2\system\trace\SYSTEM.TDF",
      BootDrive || ":\OS2\system\trace\SYS_TDF.PDP",
      "1>>" OutFileLog "2>>&1";
   /*-------------------------*/
   Line = LINEOUT(OutFileLog,,
      "If not exist Copy BootDrive:\OS2\system\trace\SYSTEM.TFF");
   Line = LINEOUT(OutFileLog,,
      "   BootDrive:\OS2\system\trace\SYS_TFF.PDP");
   Line = LINEOUT(OutFileLog); /* Close the file                      */

   ADDRESS CMD,
      "If not exist" BootDrive || ":\OS2\system\trace\SYS_TFF.PDP",
      "Copy" BootDrive || ":\OS2\system\trace\SYSTEM.TFF",
      BootDrive || ":\OS2\system\trace\SYS_TFF.PDP",
      "1>>" OutFileLog "2>>&1";
   /*-------------------------*/
   Line = LINEOUT(OutFileLog,,
      "If not exist Copy BootDrive:\OS2\system\trace\SYSTEMD.TDF");
   Line = LINEOUT(OutFileLog,,
      "   BootDrive:\OS2\system\trace\SYSD_TDF.PDP");
   Line = LINEOUT(OutFileLog); /* Close the file                      */

   ADDRESS CMD,
      "If not exist" BootDrive || ":\OS2\system\trace\SYSD_TDF.PDP",
      "Copy" BootDrive || ":\OS2\system\trace\SYSTEMD.TDF",
      BootDrive || ":\OS2\system\trace\SYSD_TDF.PDP",
      "1>>" OutFileLog "2>>&1";
   /*-------------------------*/
   Line = LINEOUT(OutFileLog,,
      "If not exist Copy BootDrive:\OS2\system\trace\SYSTEMD.TFF");
   Line = LINEOUT(OutFileLog,,
      "   BootDrive:\OS2\system\trace\SYSD_TFF.PDP");
   Line = LINEOUT(OutFileLog); /* Close the file                      */

   ADDRESS CMD,
      "If not exist" BootDrive || ":\OS2\system\trace\SYSD_TFF.PDP",
      "Copy" BootDrive || ":\OS2\system\trace\SYSTEMD.TFF",
      BootDrive || ":\OS2\system\trace\SYSD_TFF.PDP",
      "1>>" OutFileLog "2>>&1";
   /*-------------------------*/

   If Option = 2 then do;                 /* GA21MR1                  */
      /*-------------------------*/
      Line = LINEOUT(OutFileLog,,
         "Copy InstPath\Trace\GA21MR1\SYSTEM.TDF",
         "BootDrive:\OS2\SYSTEM\Trace\*.*");
      Line = LINEOUT(OutFileLog); /* Close the file                   */

      ADDRESS CMD,
         "Copy" InstPath || "\Trace\GA21MR1\SYSTEM.TDF",
         BootDrive || ":\OS2\system\trace\*.*",
         "1>>" OutFileLog "2>>&1";
      /*-------------------------*/
      Line = LINEOUT(OutFileLog,,
         "Copy InstPath\Trace\GA21MR1\SYSTEM.TFF",
         "BootDrive:\OS2\SYSTEM\Trace\*.*");
      Line = LINEOUT(OutFileLog); /* Close the file                   */

      ADDRESS CMD,
         "Copy" InstPath || "\Trace\GA21MR1\SYSTEM.TFF",
         BootDrive || ":\OS2\system\trace\*.*",
         "1>>" OutFileLog "2>>&1";
      /*-------------------------*/
      Line = LINEOUT(OutFileLog,,
         "Copy InstPath\Trace\GA21MR1\SYSTEMD.TDF",
         "BootDrive:\OS2\SYSTEM\Trace\*.*");
      Line = LINEOUT(OutFileLog); /* Close the file                   */

      ADDRESS CMD,
         "Copy" InstPath || "\Trace\GA21MR1\SYSTEMD.TDF",
         BootDrive || ":\OS2\system\trace\*.*",
         "1>>" OutFileLog "2>>&1";
      /*-------------------------*/
      Line = LINEOUT(OutFileLog,,
         "Copy InstPath\Trace\GA21MR1\SYSTEMD.TFF",
         "BootDrive:\OS2\SYSTEM\Trace\*.*");
      Line = LINEOUT(OutFileLog); /* Close the file                   */

      ADDRESS CMD,
         "Copy" InstPath || "\Trace\GA21MR1\SYSTEMD.TFF",
         BootDrive || ":\OS2\system\trace\*.*",
         "1>>" OutFileLog "2>>&1";
      /*-------------------------*/
   End;

   Else
      If Option = 3 then do;              /* GA21S3                   */
         /*-------------------------*/
         Line = LINEOUT(OutFileLog,,
            "Copy InstPath\Trace\GA21S3\SYSTEM.TDF",
            "BootDrive:\OS2\SYSTEM\Trace\*.*");
         Line = LINEOUT(OutFileLog); /* Close the file                */

         ADDRESS CMD,
            "Copy" InstPath || "\Trace\GA21S3\SYSTEM.TDF",
            BootDrive || ":\OS2\system\trace\*.*",
            "1>>" OutFileLog "2>>&1";
         /*-------------------------*/
         Line = LINEOUT(OutFileLog,,
            "Copy InstPath\Trace\GA21S3\SYSTEM.TFF",
            "BootDrive:\OS2\SYSTEM\Trace\*.*");
         Line = LINEOUT(OutFileLog); /* Close the file                */

         ADDRESS CMD,
            "Copy" InstPath || "\Trace\GA21S3\SYSTEM.TFF",
            BootDrive || ":\OS2\system\trace\*.*",
            "1>>" OutFileLog "2>>&1";
         /*-------------------------*/
         Line = LINEOUT(OutFileLog,,
            "Copy InstPath\Trace\GA21S3\SYSTEMD.TDF",
            "BootDrive:\OS2\SYSTEM\Trace\*.*");
         Line = LINEOUT(OutFileLog); /* Close the file                */

         ADDRESS CMD,
            "Copy" InstPath || "\Trace\GA21S3\SYSTEMD.TDF",
            BootDrive || ":\OS2\system\trace\*.*",
            "1>>" OutFileLog "2>>&1";
         /*-------------------------*/
         Line = LINEOUT(OutFileLog,,
            "Copy InstPath\Trace\GA21S3\SYSTEMD.TFF",
            "BootDrive:\OS2\SYSTEM\Trace\*.*");
         Line = LINEOUT(OutFileLog); /* Close the file                */

         ADDRESS CMD,
            "Copy" InstPath || "\Trace\GA21S3\SYSTEMD.TFF",
            BootDrive || ":\OS2\system\trace\*.*",
            "1>>" OutFileLog "2>>&1";
         /*-------------------------*/
      End;
End;


/**********************************************************************/
/*  Install OS2DUMP file                                              */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   ">> Install OS2DUMP file:");
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Un-hide OS2DUMP file.");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib -h -r -s " BootDrive || ":\OS2DUMP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Un-hide OS2DUMP.PDP file in case it exists.");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib -h       " BootDrive || ":\OS2DUMP.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "If not exist Copy BootDrive:\OS2DUMP BootDrive:\OS2DUMP.PDP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "If not exist" BootDrive || ":\OS2DUMP.PDP",
   "Copy" BootDrive || ":\OS2DUMP",
   BootDrive || ":\OS2DUMP.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy InstPath\TESTDUMP BootDrive:\OS2DUMP");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" InstPath || "\TESTDUMP" BootDrive || ":\OS2DUMP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Re-hide OS2DUMP file.");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +r +s +h " BootDrive || ":\OS2DUMP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Hide OS2DUMP.PDP file.");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Attrib +h       " BootDrive || ":\OS2DUMP.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/


/**********************************************************************/
/*  Create CONFIG.SYS file for the user                               */
/**********************************************************************/

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog,,
   ">> Create CONFIG.PDP file:");
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Copy BootDrive:\Config.SYS BootDrive:\Config.PDP.");
Line = LINEOUT(OutFileLog); /* Close the file                         */

ADDRESS CMD,
   "Copy" BootDrive || ":\Config.SYS",
   BootDrive || ":\Config.PDP",
   "1>>" OutFileLog "2>>&1";
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Echo some lines onto the end of the Config.PDP file:");
Line = LINEOUT(OutFileLog, "  TraceBuf=63");
Line = LINEOUT(OutFileLog, "  Trace=ON");
Line = LINEOUT(OutFileLog, "  TrapDump=OFF,A:");
Line = LINEOUT(OutFileLog, "  DumpProcess=" || BootDrive || ":");
Line = LINEOUT(OutFileLog, "  SuppressPopUps=" || BootDrive || ":");
Line = LINEOUT(OutFileLog, "  Device=" || InstPath || "\DDInfo.SYS");
/*-------------------------*/
Line = LINEOUT(OutFileLog,,
   "Search CONFIG.SYS for keywords:");

CALL SysFileSearch 'TraceBuf', InFileConfig, 'LineBuf.';
CALL SysFileSearch 'Trace=', InFileConfig, 'LineTrace.';
CALL SysFileSearch 'DDInfo.SYS', InFileConfig, 'LineDDInfo.';

Line = LINEOUT(OutFileLog,,
   "  TraceBuf       " LineBuf.0    LineBuf.1);
Line = LINEOUT(OutFileLog,,
   "  Trace =        " LineTrace.0  LineTrace.1);
Line = LINEOUT(OutFileLog,,
   "  TrapDump       " LineTrap.0   LineTrap.1);
Line = LINEOUT(OutFileLog,,
   "  DumpProcess    " LineProc.0   LineProc.1);
Line = LINEOUT(OutFileLog,,
   "  SuppressPopUps " LinePopUp.0  LinePopUp.1);
Line = LINEOUT(OutFileLog,,
   "  DDInfo.SYS     " LineDDInfo.0 LineDDInfo.1);
Line = LINEOUT(OutFileLog); /* Close the file                         */
/*-------------------------*/
If LineBuf.0 = 0 then ADDRESS CMD,
   "Echo TraceBuf=63           >>" BootDrive || ":\Config.PDP",
   "2>>" OutFileLog;

If LineTrace.0 = 0 then ADDRESS CMD,
   "Echo Trace=ON              >>" BootDrive || ":\Config.PDP",
   "2>>" OutFileLog;

If LineTrap.0 = 0 then ADDRESS CMD,
   "Echo TrapDump=OFF,A:       >>" BootDrive || ":\Config.PDP",
   "2>>" OutFileLog;

If LineProc.0 = 0 then ADDRESS CMD,
   "Echo DumpProcess=" || BootDrive || ":",
   ">>" BootDrive || ":\Config.PDP",
   "2>>" OutFileLog;

If LinePopUp.0 = 0 then ADDRESS CMD,
   "Echo SuppressPopUps=" || BootDrive || ":",
   ">>" BootDrive || ":\Config.PDP",
   "2>>" OutFileLog;

If LineDDInfo.0 = 0 then ADDRESS CMD,
   "Echo Device=" || InstPath || "\DDInfo.SYS",
   ">>" BootDrive || ":\Config.PDP",
   "2>>" OutFileLog;
/*-------------------------*/


/**********************************************************************/
/* Create Problem Determination folder on the desktop                 */
/**********************************************************************/

SAY " ";
SAY "Installing desktop objects...";

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, "Create DESKTOP folders & objects:");

rc = SysCreateObject("WPFolder","Problem^Determination","<WP_DESKTOP>",,
   "ICONVIEW    = NONGRID,NORMAL;"                                   ||,
   "TREEVIEW    = LINES,NORMAL;"                                     ||,
   "DETAILSVIEW = MINI;"                                             ||,
   "ICONFONT    = 8.Helv;"                                           ||,
   "TREEFONT    = 14.System;"                                        ||,
   "DETAILSFONT = 8.Helv;"                                           ||,
   "ICONFILE    = " || InstPath || "\Dump2.ICO;"                     ||,
   "HELPPANEL   = 1277;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "OBJECTID=<PDP_FOLDER>",,
   "r");

If rc <> 1 then do;
   SAY "Folder: PROBLEM DETERMINATION could not be created/updated!";
   Line = LINEOUT(OutFileLog,,
          "Folder:  PROBLEM DETERMINATION could not be "             ||,
          "created/updated!  RC = " rc);
   CALL Cleanup InstPath;
   Line = LINEOUT(OutFileLog, "----- ABEND OF PDPInst -----");
   Line = LINEOUT(OutFileLog); /* Close the file                      */
   ADDRESS CMD "CALL " ||,
      BootDrive || ":\PDPKill.CMD " || InstPath BootDrive || " ABEND";
   EXIT;
End;                      /* If rc <> 1                               */

Line = LINEOUT(OutFileLog,,
       "Folder:  PROBLEM DETERMINATION created/updated ok.");


/**********************************************************************/
/* Create De-Install Object                                           */
/**********************************************************************/

rc = SysCreateObject("WPProgram","De-Install","<PDP_FOLDER>",,
   "ICONFILE    = " || InstPath || "\BoltTrq.ICO;"                   ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || BootDrive || ":\PDPKill.CMD;"                 ||,
   "PARAMETERS  = " || InstPath BootDrive || ";"                     ||,
   "STARTUPDIR  = " || BootDrive || ":;"                             ||,
   "NOAUTOCLOSE = YES;"                                              ||,
   "OBJECTID    = <PDP_DEINSTALL>",,
   'r');

If rc <> 1 then do;
   SAY "Program: DE-INSTALL could not be created/updated!";
   Line = LINEOUT(OutFileLog,,
          "Program: DE-INSTALL could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: DE-INSTALL created/updated ok.");


/**********************************************************************/
/* Create READ ME object                                              */
/**********************************************************************/

rc = SysCreateObject("WPProgram","READ ME",,
   "<PDP_FOLDER>",,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = NO;"                                               ||,
   "EXENAME     = " || E.EXE || ";"                                  ||,
   "PARAMETERS  = " || InstPath || "\OS2PDP.RME;"                    ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_README>",,
   'r');

If rc <> 1 then do;
   SAY "Program: READ ME could not be "                              ||,
       "created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: READ ME "                                        ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: READ ME "                                      ||,
            "created/updated ok.");


/**********************************************************************/
/* Create DDInfo Help                                                 */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Dev Driver^Doc",,
   "<PDP_FOLDER>",,
   "ICONFILE    = " || InstPath || "\EditPur.ICO;"                   ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = NO;"                                               ||,
   "EXENAME     = " || E.EXE || ";"                                  ||,
   "PARAMETERS  = " || InstPath || "\DDInfo.Rme;"                    ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_DDINFODOC>",,
   'r');

If rc <> 1 then do;
   SAY "Program: DDINFO DOCUMENT could not be "                      ||,
       "created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: DDINFO DOCUMENT "                                ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: DDINFO DOCUMENT "                              ||,
            "created/updated ok.");


/**********************************************************************/
/* Create DDINFO Executable                                           */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Dev Driver^Info",,
   "<PDP_FOLDER>",,
   "ICONFILE    = " || InstPath || "\Arrow.ICO;"                     ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || InstPath || "\DDInfo.CMD;"                    ||,
   "PARAMETERS  = " || InstPath || ";"                               ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_DDINFO>",,
   'r');

If rc <> 1 then do;
   SAY "Program: DDINFO could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: DDINFO "                                         ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: DDINFO created/updated ok.");


/**********************************************************************/
/* Create PDP Document                                                */
/**********************************************************************/

rc = SysCreateObject("WPProgram","PDP Doc",,
   "<PDP_FOLDER>",,
   "ICONFILE    = " || InstPath || "\Book.ICO;"                      ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = NO;"                                               ||,
   "EXENAME     = " || InstPath || "\PDPDOC.CMD;"                    ||,
   "PARAMETERS  = " || InstPath || ";"                               ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_PDPDOC>",,
   'r');

If rc <> 1 then do;
   SAY "Program: PDP DOCUMENT could not be "                         ||,
       "created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: PDP DOCUMENT "                                   ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: PDP DOCUMENT "                                 ||,
            "created/updated ok.");


/**********************************************************************/
/* Copy Dump to Diskette                                              */
/**********************************************************************/

If ConfigTrapDrive = " " then ConfigTrapDrive = "BLANK";

rc = SysCreateObject("WPProgram","Copy Dump^to Diskette",,
   "<PDP_FOLDER>",,
   "ICONFILE    = " || InstPath || "\35Disk.ICO;"                    ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || InstPath || "\COPYDUMP.CMD;"                  ||,
   "PARAMETERS  = " || ConfigTrapDrive BootDrive || ";"              ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_COPYDUMP>",,
   'r');

If rc <> 1 then do;
   SAY "Program: COPY DUMP TO DISKETTE could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: COPY DUMP TO DISKETTE "                          ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: COPY DUMP TO DISKETTE created/updated ok.");


/**********************************************************************/
/* Create SysLog Executable                                           */
/**********************************************************************/

rc = SysCreateObject("WPProgram","System Log","<PDP_FOLDER>",,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || BootDrive || ":\OS2\SysLogPM.EXE;"            ||,
   "PARAMETERS  = ;"                                                 ||,
   "STARTUPDIR  = " || BootDrive || ":\OS2;"                         ||,
   "PROGTYPE    = PM;"                                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_SYSLOG>",,
   'r');

If rc <> 1 then do;
   SAY "Program: SYSTEM LOG could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: SYSTEM LOG could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: SYSTEM LOG created/updated ok.");


/**********************************************************************/
/* View Pop-up Supression Log                                         */
/**********************************************************************/

If ConfigPopDrive <> " " then do;

   rc = SysCreateObject("WPProgram","View PopUpLog","<PDP_FOLDER>",,
      "ICONFILE    = " || InstPath || "\EDITGRN.ICO;"                ||,
      "HELPPANEL   = 4083;"                                          ||,
      "NOPRINT     = NO;"                                            ||,
      "EXENAME     = " || E.EXE || ";"                               ||,
      "PARAMETERS  = " || ConfigPopDrive || ":\POPUPLOG.OS2;"        ||,
      "STARTUPDIR  = " || ConfigPopDrive || ":;"                     ||,
      "OBJECTID    = <PDP_POPUPLOG>",,
      'r');

   If rc <> 1 then do;
      SAY "Program: VIEW POP-UP SUPPRESSION LOG "                    ||,
          "could not be created/updated !";
      Line = LINEOUT(OutFileLog,,
             "Program: VIEW POP-UP SUPPRESSION LOG "                 ||,
             "could not be created/updated!");
   End;

   Else do;
      Line = LINEOUT(OutFileLog,,
             "Program: VIEW POP-UP SUPPRESSION LOG "                 ||,
             "created/updated ok.");
      ADDRESS CMD "If not exist " ConfigPopDrive || ":\POPUPLOG.OS2 "||,
         "echo Pop-up Suppression Log created by PDP install. > "    ||,
         ConfigPopDrive || ":\POPUPLOG.OS2";
   End;

End;                      /* End If ConfigPopDrive <> " "             */


/**********************************************************************/
/* Create PopUpLog OFF Executable                                     */
/**********************************************************************/

/*
If ConfigPopDrive <> " " then do;
*/

   rc = SysCreateObject("WPProgram","Suppress^PopUps OFF",,
      "<PDP_FOLDER>",,
      "ICONFILE    = " || InstPath || "\LogOfGrn.ICO;"               ||,
      "HELPPANEL   = 4083;"                                          ||,
      "NOPRINT     = YES;"                                           ||,
      "EXENAME     = " || InstPath || "\TRAPLOG.EXE;"                ||,
      "PARAMETERS  = OFF;"                                           ||,
      "STARTUPDIR  = " || InstPath || ";"                            ||,
      "NOAUTOCLOSE = NO;"                                            ||,
      "OBJECTID    = <PDP_POPUPOFF>",,
      'r');

   If rc <> 1 then do;
      SAY "Program: POP-UP LOG OFF could not be created/updated !";
      Line = LINEOUT(OutFileLog,,
             "Program: POP-UP LOG OFF could not be created/updated!");
   End;

   Else Line = LINEOUT(OutFileLog,,
               "Program: POP-UP LOG OFF created/updated ok.");

/*
End;                      /* End If ConfigPopDrive <> " "             */
*/


/**********************************************************************/
/* Create PopUpLog ON Executable                                      */
/**********************************************************************/

If ConfigPopDrive = " " then ConfigPopDrive = "BLANK";

rc = SysCreateObject("WPProgram","Suppress^PopUps ON","<PDP_FOLDER>",,
   "ICONFILE    = " || InstPath || "\LogOnGrn.ICO;"                  ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || InstPath || "\POPUPON.CMD;"                   ||,
   "PARAMETERS  = " || ConfigPopDrive InstPath BootDrive || ";"      ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_POPUPON>",,
   'r');

If rc <> 1 then do;
   SAY "Program: POP-UP LOG ON could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: POP-UP LOG ON could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: POP-UP LOG ON created/updated ok.");


/**********************************************************************/
/* Create Process Dump OFF Executable                                 */
/**********************************************************************/

/*
If ConfigProcDrive <> then do;
*/

   rc = SysCreateObject("WPProgram","Dump Process^OFF","<PDP_FOLDER>",,
      "ICONFILE    = " || InstPath || "\LogOfBlu.ICO;"               ||,
      "HELPPANEL   = 4083;"                                          ||,
      "NOPRINT     = YES;"                                           ||,
      "EXENAME     = " || InstPath || "\PROCDUMP.EXE;"               ||,
      "PARAMETERS  = OFF;"                                           ||,
      "STARTUPDIR  = " || InstPath || ";"                            ||,
      "NOAUTOCLOSE = NO;"                                            ||,
      "OBJECTID    = <PDP_PRDUMPOFF>",,
      'r');

   If rc <> 1 then do;
      SAY "Program: PROCESS DUMP OFF could not be created/updated !";
      Line = LINEOUT(OutFileLog,,
             "Program: PROCSS DUMP OFF could not be created/updated!");
   End;

   Else Line = LINEOUT(OutFileLog,,
               "Program: PROCESS DUMP OFF created/updated ok.");

/*
End;                      /* End If ConfigProcDrive <> " "            */
*/

/**********************************************************************/
/* Create Process Dump ON Executable                                  */
/**********************************************************************/

If ConfigProcDrive = " " then ConfigProcDrive = "BLANK";

rc = SysCreateObject("WPProgram","Dump Process^ON","<PDP_FOLDER>",,
   "ICONFILE    = " || InstPath || "\LogOnBlu.ICO;"                  ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || InstPath || "\PRDUMPON.CMD;"                  ||,
   "PARAMETERS  = " || ConfigProcDrive InstPath || ";"               ||,
   "STARTUPDIR  = " || InstPath || ";"                               ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_PRDUMPON>",,
   'r');

If rc <> 1 then do;
   SAY "Program: PROCESS DUMP ON could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: PROCESS DUMP ON could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: PROCESS DUMP ON created/updated ok.");


/**********************************************************************/
/* Create Trace Options folder on the desktop                         */
/**********************************************************************/

rc = SysCreateObject("WPFolder","Trace Options","<PDP_FOLDER>",,
   "ICONVIEW    = NONGRID,NORMAL;"                                   ||,
   "TREEVIEW    = LINES,NORMAL;"                                     ||,
   "DETAILSVIEW = MINI;"                                             ||,
   "ICONFONT    = 8.Helv;"                                           ||,
   "TREEFONT    = 14.System;"                                        ||,
   "DETAILSFONT = 8.Helv;"                                           ||,
   "ICONFILE    = " || InstPath || "\ClueYlw.ICO;"                   ||,
   "HELPPANEL   = 1277;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "OBJECTID    = <PDP_TRACE_FOLDER>",,
   'r');

If rc <> 1 then do;
   SAY "Folder: Trace OPTIONS could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Folder:  Trace OPTIONS could not be created/updated!");
End;


Else do;

   Line = LINEOUT(OutFileLog,,
          "Folder:  Trace OPTIONS created/updated ok.");


/**********************************************************************/
/* Create Trace Customization Help                                    */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace Custom^Help",,
   "<PDP_TRACE_FOLDER>",,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = NO;"                                               ||,
   "EXENAME     = " || VIEW.EXE || ";"                               ||,
   "PARAMETERS  = " || InstPath || "\Trace\TRCUST.INF;"              ||,
   "STARTUPDIR  = " || InstPath || "\Trace;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_TRACE_CUSTDOC>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace CUSTOMIZATION HELP could not be "             ||,
       "created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace CUSTOMIZATION HELP "                       ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace CUSTOMIZATION HELP "                     ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace Help                                                  */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace Help",,
   "<PDP_TRACE_FOLDER>",,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = NO;"                                               ||,
   "EXENAME     = " || VIEW.EXE || ";"                               ||,
   "PARAMETERS  = " || InstPath || "\Trace\Trace.INF;"               ||,
   "STARTUPDIR  = " || InstPath || "\Trace;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "OBJECTID    = <PDP_TRACE_DOC>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace HELP could not be "                           ||,
       "created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace HELP "                                     ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace HELP "                                   ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace Formatter Executable                                  */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace Formatter",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\Maze1.ICO;"                     ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || BootDrive || ":\OS2\TraceFMT.EXE;"            ||,
   "STARTUPDIR  = " || BootDrive || ":\OS2;"                         ||,
   "NOAUTOCLOSE = YES;"                                              ||,
   "PROGTYPE    = PM;"                                               ||,
   "OBJECTID    = <PDP_TRACE_FMT>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace FORMATTER could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace FORMATTER could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace FORMATTER created/updated ok.");


/**********************************************************************/
/* Create Trace Customization Executable: combine TFF files           */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace Custom^Combine",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\OS2Ylw.ICO;"                    ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || InstPath || "\Trace\TrcCombn.CMD;"            ||,
   "PARAMETERS  = " || InstPath || ";"                               ||,
   "STARTUPDIR  = " || InstPath || "\Trace;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_CUSTCOMBN>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace CUSTOMIZATION COMBINE could not be "          ||,
       "created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace CUSTOMIZATION COMBINE "                    ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace CUSTOMIZATION COMBINE "                  ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace Customization Executable: create TDF/TFF files        */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace Custom^Create",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\OS2Ylw.ICO;"                    ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || InstPath || "\Trace\TrcCreat.CMD;"            ||,
   "PARAMETERS  = " || InstPath BootDrive || ";"                     ||,
   "STARTUPDIR  = " || InstPath || "\Trace;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_CUSTCREAT>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace CUSTOMIZATION CREATE could not be "           ||,
       "created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace CUSTOMIZATION CREATE "                     ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace CUSTOMIZATION CREATE "                   ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace OFF Executable w/Clear Buffer option                  */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace OFF^Clear Buffer",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\LogOfYlw.ICO;"                  ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || Bootdrive || ":\OS2\Trace.EXE;"               ||,
   "PARAMETERS  = OFF /C;"                                           ||,
   "STARTUPDIR  = " || Bootdrive || ":\OS2;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_OFFCLEAR>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace OFF /CLEAR could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace OFF /CLEAR "                               ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace OFF /CLEAR "                             ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace OFF Executable                                        */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace OFF",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\LogOfRed.ICO;"                  ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || Bootdrive || ":\OS2\Trace.EXE;"               ||,
   "PARAMETERS  = OFF;"                                              ||,
   "STARTUPDIR  = " || Bootdrive || ":\OS2;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_OFF>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace OFF could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace OFF "                                      ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace OFF "                                    ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace ON Executable w/Suspend Tracing option                */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Suspend Trace",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\TRFRED.ICO;"                    ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || Bootdrive || ":\OS2\Trace.EXE;"               ||,
   "PARAMETERS  = ON /S;"                                            ||,
   "STARTUPDIR  = " || Bootdrive || ":\OS2;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_ONSUSPEND>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace ON /SUSPEND could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace ON /SUSPEND "                              ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace ON /SUSPEND "                            ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace ON Executable w/Resume Tracing option                 */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Resume Trace",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\TRFGRN.ICO;"                    ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || Bootdrive || ":\OS2\Trace.EXE;"               ||,
   "PARAMETERS  = ON /R;"                                            ||,
   "STARTUPDIR  = " || Bootdrive || ":\OS2;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_ONRESUME>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace ON /RESUME could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace ON /RESUME "                               ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace ON /RESUME "                             ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace ON Executable w/Clear Buffer option                   */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace ON^Clear Buffer",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\LogOnYlw.ICO;"                  ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || Bootdrive || ":\OS2\Trace.EXE;"               ||,
   "PARAMETERS  = ON /C;"                                            ||,
   "STARTUPDIR  = " || Bootdrive || ":\OS2;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_ONCLEAR>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace ON /CLEAR could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace ON /CLEAR "                                ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace ON /CLEAR "                              ||,
            "created/updated ok.");


/**********************************************************************/
/* Create Trace ON Executable                                         */
/**********************************************************************/

rc = SysCreateObject("WPProgram","Trace ON",,
   "<PDP_TRACE_FOLDER>",,
   "ICONFILE    = " || InstPath || "\LogOnRed.ICO;"                  ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "EXENAME     = " || Bootdrive || ":\OS2\Trace.EXE;"               ||,
   "PARAMETERS  = ON;"                                               ||,
   "STARTUPDIR  = " || Bootdrive || ":\OS2;"                         ||,
   "NOAUTOCLOSE = NO;"                                               ||,
   "PROGTYPE    = WINDOWABLEVIO;"                                    ||,
   "OBJECTID    = <PDP_TRACE_ON>",,
   'r');

If rc <> 1 then do;
   SAY "Program: Trace ON could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: Trace ON "                                       ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: Trace ON "                                     ||,
            "created/updated ok.");

End;                      /* End Else do (if Trace FOLDER created ok) */

/**********************************************************************/
/* Create PM Dump Facility Executable                                 */
/**********************************************************************/

rc = SysCreateObject("WPProgram","PM Dump Facility","<PDP_FOLDER>",,
   "EXENAME     = " || InstPath || "\PMDF\PMDF.EXE;"                 ||,
   "STARTUPDIR  = " || InstPath || "\PMDF;"                          ||,
   "PROGTYPE    = PM;"                                               ||,
   "HELPPANEL   = 4083;"                                             ||,
   "NOPRINT     = YES;"                                              ||,
   "OBJECTID    = <PDP_PMDF>",,
   'r');

If rc <> 1 then do;
   SAY "Program: PMDF could not be created/updated !";
   Line = LINEOUT(OutFileLog,,
          "Program: PMDF "                                           ||,
          "could not be created/updated!");
End;

Else Line = LINEOUT(OutFileLog,,
            "Program: PMDF "                                         ||,
            "created/updated ok.");


/**********************************************************************/
/*  Clean-up Procedure                                                */
/**********************************************************************/

CALL Cleanup InstPath;


/**********************************************************************/
/*  EXIT                                                              */
/**********************************************************************/

SAY " ";
SAY " ";
SAY "Done...";
SAY " ";
SAY " ";
SAY "***** Please REBOOT for OS2DUMP to take effect! *****";
SAY " ";
SAY " ";
SAY " ";
SAY " ";
SAY " ";

CALL SysSleep 2;

Line = LINEOUT(OutFileLog, " ");
Line = LINEOUT(OutFileLog, "----- END OF PDPInst -----");

Exit rc


/**********************************************************************/
/*  Clean-up Procedure                                                */
/**********************************************************************/

Cleanup:

   Arg InstPath;
   Line = LINEOUT(OutFileLog, " ");
   Line = LINEOUT(OutFileLog, ">> Start of Clean-up procedure:");

   rc = SysFileDelete(InstPath || "\Dump2.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Dump2.ICO             RC = " rc);

   rc = SysFileDelete(InstPath || "\Book.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Book.ICO              RC = " rc);

   rc = SysFileDelete(InstPath || "\BoltTrq.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete BoltTrq.ICO           RC = " rc);

   rc = SysFileDelete(InstPath || "\35Disk.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete 35Disk.ICO            RC = " rc);

   rc = SysFileDelete(InstPath || "\Arrow.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Arrow.ICO             RC = " rc);

   rc = SysFileDelete(InstPath || "\EditPur.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete EditPur.ICO           RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOfGrn.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOfGrn.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOnGrn.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOnGrn.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOfBlu.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOfBlu.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOnBlu.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOnBlu.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\ClueYlw.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete ClueYlw.ICO           RC = " rc);

   rc = SysFileDelete(InstPath || "\Maze1.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Maze1.ICO             RC = " rc);

   rc = SysFileDelete(InstPath || "\OS2Ylw.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete OS2Ylw.ICO            RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOfRed.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOfRed.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOfYlw.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOfYlw.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\TRFRED.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete TRFRED.ICO            RC = " rc);

   rc = SysFileDelete(InstPath || "\TRFGRN.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete TRFGRN.ICO            RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOnRed.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOnRed.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\LogOnYlw.ICO");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete LogOnYlw.ICO          RC = " rc);

   rc = SysFileDelete(InstPath || "\TESTDUMP");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete TESTDUMP              RC = " rc);

   rc = SysFileDelete(InstPath || "\PDPKill.CMD");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete PDPKill.CMD           RC = " rc);

   rc = SysFileDelete(InstPath || "\PMDF\TRC000A.TFF");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete PMDF\TRC000A.TFF      RC = " rc);

   rc = SysFileDelete(InstPath || "\SysLog.EXE");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete SysLog.EXE            RC = " rc);

   rc = SysFileDelete(InstPath || "\SysLogPM.EXE");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete SysLogPM.EXE          RC = " rc);

   rc = SysFileDelete(InstPath || "\SysLog.DLL");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete SysLog.DLL            RC = " rc);

   rc = SysFileDelete(InstPath || "\SysLogH.HLP");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete SysLogH.HLP           RC = " rc);

   rc = SysFileDelete(InstPath || "\Trace\Trace.EXE");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Trace\Trace.EXE       RC = " rc);

   rc = SysFileDelete(InstPath || "\Trace\TraceFMT.EXE");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Trace\TraceFMT.EXE    RC = " rc);

   rc = SysFileDelete(InstPath || "\Trace\TraceFMT.DLL");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Trace\TraceFMT.DLL    RC = " rc);

   rc = SysFileDelete(InstPath || "\Trace\TraceFMT.HLP");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete Trace\TraceFMT.HLP    RC = " rc);

   rc = SysFileDelete(InstPath || "\UnPack2.EXE");
   Line = LINEOUT(OutFileLog,,
      "SysFileDelete InstPath\UnPack2.EXE  RC = " rc);

   If Medium = 2 then do;
      SAY " ";
      SAY "Would you like to delete the installation files (Y=Yes):";
      SAY "  ReadMe";
      SAY "  PDPInst.CMD";
      SAY "  *.Pk@";
      SAY "  UnPack2.EXE";
      SAY " ";
      Pull DelFiles;

      If (DelFiles = "Y" | DelFiles = "YES") then do;
         rc = SysFileDelete("Misc.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete Misc.Pk@              RC = " rc);

         rc = SysFileDelete("SysLog.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete SysLog.Pk@            RC = " rc);

         rc = SysFileDelete("PMDF.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete PMDF.Pk@              RC = " rc);

         rc = SysFileDelete("DFGA21.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete DFGA21.Pk@            RC = " rc);

         rc = SysFileDelete("DFGA21MR.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete DFGA21MR.Pk@          RC = " rc);

         rc = SysFileDelete("DFGA21S3.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete DFGA21S3.Pk@          RC = " rc);

         rc = SysFileDelete("Trace.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete Trace.Pk@             RC = " rc);

         rc = SysFileDelete("TRGA21.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete TRGA21.Pk@            RC = " rc);

         rc = SysFileDelete("TRGA21MR.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete TRGA21MR.Pk@          RC = " rc);

         rc = SysFileDelete("TRGA21S3.Pk@");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete TRGA21S3.Pk@          RC = " rc);

         rc = SysFileDelete("ReadMe");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete ReadMe                RC = " rc);

         rc = SysFileDelete("UnPack2.EXE");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete UnPack2.EXE           RC = " rc);

         rc = SysFileDelete("PDPInst.CMD");
         Line = LINEOUT(OutFileLog,,
            "SysFileDelete PDPInst.CMD           RC = " rc);
      End;
   End;

   Line = LINEOUT(OutFileLog, "Clean-up procedure has Executed.");

Return;


