/* REXX NTP Client
   (C) 1993 by Steve Luzynski

   Revision history:
   V.1 - Initial Release

   This program requires the rxSock dll function library, available
   anywhere IBM EWS is found.
*/

trace on

/* setup socket package */
if RxFuncQuery("SockLoadFuncs") then
do
  rc = RxFuncAdd("SockLoadFuncs", "RxSock", "SockLoadFuncs")
  rc = SockLoadFuncs()
end

/* get ntp server address */
rc = SockGetHostByName("slc13.ins.cwru.edu", "host.!")
if (rc = 0) then
do
  say "Unable to resolve name of ntp server."
  exit
end

server = host.!addr

/* open a socket to the server */
sock = SockSocket("AF_INET", "SOCK_STREAM", "IPPROTO_TCP")
if (sock = -1) then
do
  say "Error opening socket: " errno
  exit
end

/* connect to server */
server.!family = "AF_INET"
server.!port   = 13
server.!addr   = server

rc = SockConnect(sock, "server.!")
if (sock = -1) then
do
  say "Error connecting socket: " errno
  exit
end

rc = SockRecv(sock, "data", 8000)

parse var data d1 d2 d3 d4 d5

say "Time set to" d4

time d4

rc = SockSend(sock, "quit")
rc = SockSoClose(sock)
exit




