import java.io.*;
import java.net.*;

class toprog{

  Socket socketA, socketB; 
  BufferedInputStream inputStreamA, inputStreamB;
  BufferedOutputStream outputStreamA, outputStreamB;
  Thread proxyA, proxyB;

  public static void main(String args[]){

    String info; // for uins ip and port
    int index1, index2;
    String ipA, ipB;
    int portA, portB;

    try{
      System.out.println("\r\nToprog 1.0\nAn Eyewitness\nAutumn98\r\n");
      if(args.length<4){
	System.out.println("Usage: toprog <localUIN> <localUIN password> <UIN A> <UIN B> \r\n");
	System.exit(1);
      }
      
      String uins[] = new String[2];
      uins[0] = args[2];
      uins[1] = args[3];

      System.out.print("Getting IPs and Ports...");
      upsilonprog upsilon = new upsilonprog(uins, args[0], args[1]);
      info = upsilon.getIP_Port();
      
      index1 = info.indexOf(':');
      index2 = info.lastIndexOf(':');
      if(index2 ==-1 || index1 == index2){
	System.err.println("\r\nAt least one UIN is offline/invisible, can't get IP and port");
	System.exit(1);
      }
      ipA = info.substring(info.indexOf(' ')+1, index1);
      portA = Integer.parseInt(info.substring(index1+1, info.indexOf('\r')));
      ipB = info.substring(info.lastIndexOf(' ')+1, index2);
      portB = Integer.parseInt(info.substring(index2+1, info.lastIndexOf('\r')));
      System.out.println("Done");

      toprog to = new toprog(args[2], ipA, portA, args[3], ipB, portB);
      System.out.println("Connections established");
    }
    catch(IOException ex){
      System.err.println("Well, a fatal error occured... Here's the error stack trace:");
      ex.printStackTrace();
    }
  }
 

  public toprog(String uinA, String ipA, int portA, String uinB, String ipB, int portB) throws IOException{

    System.out.print("Sending Channels init...");
    initChannel(uinB, ipA, portA, 'A'); // open connection with UIN A
    initChannel(uinA, ipB, portB, 'B'); // open connection with UIN B
    System.out.println("Done");
    System.out.print("Starting connection...");
    getMessage(uinB, 'A'); // get UIN A away/dnd message
    getMessage(uinA, 'B'); // get UIN B away/dnd message
    System.out.println("Done.");

    // from uinA to uinB
    proxyA = new Thread(new toprogProxy(outputStreamB, inputStreamA));
    proxyA.start();

    // from uinB to uinA
    proxyB = new Thread(new toprogProxy(outputStreamA, inputStreamB));
    proxyB.start();

  }

  void initChannel(String uin, String ip, int port, char id) throws IOException{
    
    byte initPacket[] = new byte[28];
    byte uinBytes[] = new byte[4];
    int index, index2;
    String portHex;
    int portlen;

    initPacket[0] = (byte) 0x1A;
    initPacket[2] = (byte) 0xFF;
    initPacket[3] = (byte) 0x02;

    uinBytes = UIN.toBytes(uin);
    for(int i=0;i<4;i++)
      initPacket[i+ 11] = uinBytes[i];
   
    //converts ip
    
    index = ip.indexOf('.');
    initPacket[15] = (byte) Integer.parseInt(ip.substring(0, index));
    index2 = ip.indexOf('.', index+1);
    initPacket[16] = (byte) Integer.parseInt(ip.substring(index+1, index2));
    index = ip.indexOf('.', index2+1);
    initPacket[17] = (byte) Integer.parseInt(ip.substring(index2+1, index));
    index = ip.lastIndexOf('.');
    initPacket[18] = (byte) Integer.parseInt(ip.substring(index+1));

    initPacket[19] = initPacket[15];
    initPacket[20] = initPacket[16];
    initPacket[21] = initPacket[17];
    initPacket[22] = initPacket[18];

    initPacket[23] = (byte) 0x04;

    // converts port

      portHex = Integer.toHexString(port);
      portlen = portHex.length();
      initPacket[24] = (byte) Integer.parseInt(portHex.substring(portlen-2), 16);
      if(portlen==3)
        initPacket[25] = (byte) Integer.parseInt(portHex.substring(portlen-3,portlen-2), 16);
      else
        initPacket[25] = (byte) Integer.parseInt(portHex.substring(portlen-4,portlen-2), 16);


    if(id=='A'){
      socketA = new Socket(ip, port);
      inputStreamA = new BufferedInputStream(socketA.getInputStream());
      outputStreamA = new BufferedOutputStream(socketA.getOutputStream());
      outputStreamA.write(initPacket);
      outputStreamA.flush();
    }
    else{
      socketB = new Socket(ip, port);
      inputStreamB = new BufferedInputStream(socketB.getInputStream());
      outputStreamB = new BufferedOutputStream(socketB.getOutputStream());
      outputStreamB.write(initPacket);
      outputStreamB.flush();
    }
  }

  void getMessage(String uin, char id) throws IOException{

    int readable;
    byte mesgPacket[] = new byte[1024];
    byte reply[] = new byte[1024];
    Byte length;
    String temp;

    byte uinBytes[] = new byte[4];

    mesgPacket[0] = (byte) (41);

    uinBytes = UIN.toBytes(uin);
    for(int i=0;i<4;i++)
      mesgPacket[i+2] = uinBytes[i];

    mesgPacket[6] = (byte) 0x02; // version
    mesgPacket[8] = (byte) 0xEE; // cmd
    mesgPacket[9] = (byte) 0x07;

    for(int i=0;i<4;i++)
      mesgPacket[i+12] = uinBytes[i];

    mesgPacket[16] = (byte) 0xEA; // msg type (get away/dnd message)
    mesgPacket[17] = (byte) 0x03;
    mesgPacket[18] = (byte) (0x01); // length of message (0) + NULL
      

    mesgPacket[35 + 1] = (byte) 0x10;
    if(id=='A'){
      outputStreamA.write(mesgPacket, 0, 43);
      outputStreamA.flush();
      inputStreamA.read(reply, 0, 1);
      inputStreamA.read(reply, 1, 1);
    }
    else if(id=='B'){
      outputStreamB.write(mesgPacket, 0, 43);
      outputStreamB.flush();
      inputStreamB.read(reply, 0, 1);
      inputStreamB.read(reply, 1, 1);
    }

    length = new Byte(reply[0]);
    temp = Integer.toHexString(length.intValue());
    if(temp.length()>2)
      temp = temp.substring(temp.length()-2);
    readable = Integer.parseInt(temp, 16);
    length = new Byte(reply[1]);
    temp = Integer.toHexString(length.intValue());
    if(temp.length()>2)
      temp = temp.substring(temp.length()-2);
    readable += 256 * Integer.parseInt(temp, 16);

    if(id=='A'){
      inputStreamA.read(reply, 2, readable); // read the complete auto reply
    }
    else if(id=='B'){
      inputStreamB.read(reply, 2, readable); // read the complete auto reply
    }
  }
}



class toprogProxy implements Runnable{
  
  /*
    Link two ICQ tcp connection and log what's passing through them
  */
  
  BufferedOutputStream writer;
  BufferedInputStream reader;
  PrintWriter log;

  public toprogProxy(BufferedOutputStream out, BufferedInputStream in) throws IOException{
    
    log = new PrintWriter(new FileWriter("toprog.log", true), true);
    writer = out;
    reader = in;
    
  }
  
  public void run(){
    
    byte buff[] = new byte[1028];
    byte uinBytes[] = new byte[4];
    int offset, readable, read;
    Byte length;
    String temp;

    log.println("//////////////////////////////////////////////////");

    while(true){
      try{
	offset = 2;
	if(reader.read(buff, 0, 1) == -1)
	  break;
	if(reader.read(buff, 1, 1) == -1)
	  break;
	length = new Byte(buff[0]);
	temp = Integer.toHexString(length.intValue());
	if(temp.length()>2)
	  temp = temp.substring(temp.length()-2);
	readable = Integer.parseInt(temp, 16);
	length = new Byte(buff[1]);
	
	temp = Integer.toHexString(length.intValue());
	if(temp.length()>2)
	  temp = temp.substring(temp.length()-2);
	readable += 256 * Integer.parseInt(temp, 16);
	// System.out.println(readable);
	offset = reader.read(buff, offset, readable) + 2;
	if(offset==1)
	  break;
	if(buff[35 + (readable - 39)] == (byte) 0x10){
	  for(int i=0;i<4;i++)
	    uinBytes[i] = buff[i+2];
	  synchronized(System.out){
	    if(buff[16] == (byte) 0x01){
	      System.out.println(UIN.toString(uinBytes) + " (message): ");
	      System.out.println(new String(buff, 20, (readable - 40)));
	      System.out.println();
	      log.println(UIN.toString(uinBytes) + " (message): ");
	      log.println(new String(buff, 20, (readable - 40)));
	      log.println();
	    }
	    else if(buff[16] == (byte) 0x04){
	      System.out.println(UIN.toString(uinBytes) + " (URL): ");
	      for(int i=0;i<readable - 40;i++){
		if(buff[i +20] == (byte) 0xFE){
		  System.out.println("Description: " + new String(buff, 20, i));
		  System.out.println("URL: " + new String(buff, 20 + i + 1, readable-40 - i));
		  System.out.println();
		  log.println("Description: " + new String(buff, 20, i));
		  log.println("URL: " + new String(buff, 20 + i + 1, readable-40 - i));
		  log.println();
		}
	      }
	    }
	    else{
	      System.out.println(UIN.toString(uinBytes) + " (Unknown Packet)");
	      System.out.println("Message code: " + buff[16] + " " + buff[17]);
	      System.out.println("Length = " + readable);
	      System.out.println();
	      log.println(UIN.toString(uinBytes) + " (Unknown Packet)");
	      log.println("Message code: " + buff[16] + " " + buff[17]);
	      log.println("Length = " + readable);
	      log.println();
	    }	    
	  }
	}
	
        writer.write(buff, 0, offset);
        writer.flush();
      }    
      catch(IOException ex){
	System.err.println("IOException in proxy");
	ex.printStackTrace();
	try{
	  if(reader.available()>0)
	    reader.read(buff, 0, reader.available()); // trying to clear the buffer
	}
	catch(IOException ex2){
	  System.err.println("Fatal error with connection");
	  ex2.printStackTrace();
	  System.exit(1);
	}
      }
    }
    System.out.println("Connection lost");  
  }
}




class upsilonprog{

  /*
    Upsilonprog 1.0
    An Eyewitness
    aneyewitness@geocities.com
    Autumn 98
    Get IP and ICQ port from UIN
  */

  String uinString[];
  String localUin;
  String passwd;
  DatagramSocket socket;
  InetAddress ICQServer;

  public static void main(String args[]){

    String info;

    System.out.println("Upsilonprog 1.0 \nBy An Eyewitness\nAutumn 98\n");
    if(args.length<3){
      System.err.println("Usage: upsilonprog <localUIN> <localUin password> <UIN> [UIN] ...");
      System.exit(1);
    }
    
    try{
      String uin[] = new String[args.length-2];
      for(int i=0;i<args.length-2;i++)
	uin[i] = args[i+2];
      
      upsilonprog upsilon = new upsilonprog(uin, args[0], args[1]);
      info = upsilon.getIP_Port();
      if(info.length() == 0)
	System.out.println("All UIN are offline or invisible");
      else
	System.out.println(info);

    }
    catch(IOException ex){
      ex.printStackTrace();
    }
  }

  public upsilonprog(String uinString[], String localUin, String passwd) throws IOException{

    this.uinString = uinString;
    this.localUin = localUin;
    this.passwd = passwd;

    ICQServer = InetAddress.getByName("icq.mirabilis.com");

  }

  public String getIP_Port() throws IOException{

    login();
    sendContactList();
    return readReply();

  }

  void login() throws IOException{

    byte buff[] = new byte[128];
    byte abuff[] = new byte[128];
    byte acks[] = new byte[10];
    String port; // socket port number in Hex
    int portlen; // string port length
    byte passwdBytes[];
    DatagramPacket loginPacket, answer, ack;
    boolean ok = false;

    // filling buff

    buff[0] = (byte) 0x02; // version
    buff[1] = (byte) 0x00;
    buff[2] = (byte) 0xE8; // cmd
    buff[3] = (byte) 0x03;
    buff[4] = (byte) 0x00; // seq number
    buff[5] = (byte) 0x00;

    byte localUinBytes[] = UIN.toBytes(localUin);
    for(int i=0;i<4;i++)
      buff[6+i] = localUinBytes[i];
    

    socket = new DatagramSocket();
    socket.setSoTimeout(15000);
    port = Integer.toHexString(socket.getLocalPort());
    portlen = port.length();
    buff[10] = (byte) Integer.parseInt(port.substring(portlen-2), 16);
    if(portlen==3)
      buff[11] = (byte) Integer.parseInt(port.substring(portlen-3,portlen-2), 16);
    else
      buff[11] = (byte) Integer.parseInt(port.substring(portlen-4,portlen-2), 16);

    buff[14] = (byte) (passwd.length() + 1);
    passwdBytes = passwd.getBytes();
    for(int i=0;i<passwd.length();i++)
      buff[16 + i] = passwdBytes[i];
    buff[16 + passwd.length()] = (byte) 0x00;

    ICQServer = InetAddress.getByName("icq.mirabilis.com");

    loginPacket = new DatagramPacket(buff, passwd.length() + 17, ICQServer, 4000);
    socket.send(loginPacket);

    while(!ok){
      try{
	answer = new DatagramPacket(abuff, 128);
	socket.receive(answer);
	if(abuff[2] == (byte) 0x0A && abuff[3] == (byte) 0x00){
	  // ACK
	}
	else{
	  if(abuff[2] == (byte) 0x64 && abuff[3] == (byte) 0x00){
	    System.err.println("Can't login, wrong passwd");
	    System.exit(1);
	  }
	  else if(abuff[2] == (byte) 0x5A && abuff[3] == (byte) 0x00){
	    acks[0] = (byte) 0x02;
	    acks[2] = (byte) 0x0A;
	    acks[4] = abuff[4];
	    acks[5] = abuff[5];
	    for(int i=6;i<10;i++)
	      acks[i] = buff[i]; // copy localUin
	    ack = new DatagramPacket(acks, 10, ICQServer, 4000);
	    socket.send(ack);	    
	    ok = true;
	  }
	  else if(abuff[2] == (byte) 0xFA && abuff[3] == (byte) 0x00){
	    System.err.println("UIN is online, can't login.");
	    System.exit(1);
	  }   
	  else{
	    System.err.println("Unknown reply from ICQ server");
	    System.exit(1);
	  }
	}
      }
      catch(InterruptedIOException ex){
	System.out.println("Timeout during login. Resending packet");
	socket.send(loginPacket);
      }
    }   
  }


  void sendContactList() throws IOException{
    
    byte buff[] = new byte[128];
    DatagramPacket listPacket;

    buff[0] = (byte) 0x02; // version
    buff[1] = (byte) 0x00;
    buff[2] = (byte) 0x06; // cmd
    buff[3] = (byte) 0x04;
    buff[4] = (byte) 0x00; // seq number
    buff[5] = (byte) 0x00;

    byte localUinBytes[] = UIN.toBytes(localUin);
    for(int i=0;i<4;i++)
      buff[6+i] = localUinBytes[i];

    buff[10] = (byte) uinString.length; // Contacts number
    // buff[11] = (byte) 0x00;

    for(int i=0;i<uinString.length;i++){
      byte uinBytes[] = UIN.toBytes(uinString[i]);
      for(int j=0;j<4;j++)
	buff[11+i*4+j] = uinBytes[j];
    }

    listPacket = new DatagramPacket(buff, 11+4*uinString.length, ICQServer, 4000);
    socket.send(listPacket);

  }

  String readReply() throws IOException{

    byte abuff[] = new byte[128];
    byte acks[] = new byte[10];
    byte localUinBytes[];
    DatagramPacket answer = new DatagramPacket(abuff, 128);
    DatagramPacket ack;
    boolean ok = false;
    String info = new String("");

    acks[0] = (byte) 0x02;
    acks[2] = (byte) 0x0A;
    localUinBytes = UIN.toBytes(localUin);
    for(int i=0;i<4;i++)
      acks[i+6] = localUinBytes[i]; // copy localUin
    do{
      try{
	answer = new DatagramPacket(abuff, 128);
	socket.receive(answer);
	if(abuff[2] == (byte) 0x0A && abuff[3] == (byte) 0x00){
	  // ACK
	}
	else{
	  
	  String port = new String("");
	  String ipString = new String("");
	  
	  acks[4] = abuff[4];
	  acks[5] = abuff[5];
	  
	  ack = new DatagramPacket(acks, 10, ICQServer, 4000);
	  socket.send(ack);
	  
	  if(abuff[2] == (byte) 0x6E && abuff[3] == (byte) 0x00){
	    byte tmpbuff[] = new byte[4];
	    for(int i=0;i<4;i++)
	      tmpbuff[i] = abuff[i+6];
	    info = info.concat(UIN.toString(tmpbuff) + " ");
	  
	    for(int i=0;i<4;i++)
	      tmpbuff[i] = abuff[i+10];
	    
	    for(int i=0;i<4;i++){
	      Byte ipByte = new Byte(tmpbuff[i]);
	      String temp = Integer.toHexString(ipByte.intValue());
	      // to make sure we get a 2 number long number, not just 5 or fffffa
	    if(temp.length()==1)
	      temp = new String("0" + temp);
	    else if(temp.length()>2)
	      temp = temp.substring(temp.length()-2);
	    temp = Integer.toString(Integer.parseInt(temp, 16));
	    ipString = ipString.concat(temp);	    
	    if(i<3)
	      ipString = ipString.concat(".");
	    }
	    info = info.concat(ipString + ":");
	    
	    
	    for(int i=1;i>-1;i--){
	      Byte portByte = new Byte(abuff[14+i]);
	      String temp =  Integer.toHexString(portByte.intValue());
	      if(temp.length()==1)
		temp = new String("0" + temp);
	      else if(temp.length()>2)
		temp = temp.substring(temp.length()-2);
	      port = port.concat(temp);
	  }
	    port = Integer.toString(Integer.parseInt(port, 16));
	    info = info.concat(port + "\r\n");
	  }
	}
      }
      catch(InterruptedIOException ex){
	System.out.println("Timeout on socket. Resending packet");
	sendContactList();
	info = new String("");
      }
    }while(abuff[2] != (byte) 0x1C && abuff[3] != (byte) 0x02);
    
    return info;
  }
}

class UIN{
  /*
    convert UIN string to byte array and byte array to UIN
  */

  public static byte[] toBytes(String uinString){

    byte uinBytes[] = new byte[4];

    String uinHex = Integer.toHexString(Integer.parseInt(uinString));

    int uinLength = uinHex.length();

    uinBytes[0] = (byte) Integer.parseInt(uinHex.substring(uinLength-2), 16);
    uinBytes[1] = (byte) Integer.parseInt(uinHex.substring(uinLength-4,uinLength-2), 16);
    if(uinLength>4){
      if(uinLength==5)
	uinBytes[2] = (byte) Integer.parseInt(uinHex.substring(uinLength-5,uinLength-4), 16);
      else
	uinBytes[2] = (byte) Integer.parseInt(uinHex.substring(uinLength-6,uinLength-4), 16);
    }
    if(uinLength>6){
      if(uinLength==7)	 
	uinBytes[3] = (byte) Integer.parseInt(uinHex.substring(uinLength-7,uinLength-6), 16);
      else
	uinBytes[3] = (byte) Integer.parseInt(uinHex.substring(uinLength-8,uinLength-6), 16);
    }
    
    return uinBytes;
  }


  

  public static String toString(byte uinBytes[]){
    
    String uinHex = new String("");
    for(int i=3;i>-1;i--){
      Byte uinByte = new Byte(uinBytes[i]);
      String temp = Integer.toHexString(uinByte.intValue());
      // to make sure we get a 2 number long number, not just 5 or fffffa
      if(temp.length()==1)
	temp = new String("0" + temp);
      else if(temp.length()>2)
	temp = temp.substring(temp.length()-2);
      uinHex = uinHex.concat(temp);
    }
    return Integer.toString(Integer.parseInt(uinHex, 16));
  }
}







