#include "icq.h"

#include <stdio.h>

#define	ASCII_EOF	26

int		ReadFileToBuffer(char *filename, char *buf, int maxlen){
	int	i, filelen;
	FILE* file;
	file = fopen(filename, "rb");
	fseek(file, 0, SEEK_END);
	filelen = ftell(file);
	if (filelen>maxlen-1) filelen = maxlen-1;
	fseek(file, 0, SEEK_SET);
	i = fread (buf, filelen, 1, file);
	fclose (file);
	if (i<1) return 0;
	buf[filelen] = ASCII_EOF;
	return filelen;
}


int FetchLine(char **buffer, char *des, int maxlen){
	int  len = 0;
	char *ptr;
	for (ptr=(*buffer); len<maxlen-1; len++){
		if (ptr[len]==0x0D || ptr[len]==0x0A || ptr[len]==0 || ptr[len]==ASCII_EOF) break;
		des[len]=ptr[len];
	} des[len] = 0;
	*buffer = &ptr[len+1];
	if (len==0){
		if (ptr[0] == ASCII_EOF) return 0;
		else return FetchLine(buffer, des, maxlen);
	} return len;
}

void	StringUpper(char *str){
	int len;
	len = strlen(str);
	for (len--; len>=0; len--){
		if (str[len]>='a' && str[len]<='z') str[len] -= ('a'-'A');
	}
}

void	NoEndSpace(char *str){
	int len;
	len = strlen(str);
	for (len--; len>=0; len--){
		if (str[len]==' ') str[len] = 0;
		else break;
	}
}

void	DoRespond(ICQCONNECTION *conn, char *respondfile, int sender, int type, char *body){
	int		i, len, match;
	char	bigboy[65536];
	char	linebuf[512];
	char	*ptr;

	len = ReadFileToBuffer(respondfile, bigboy, 65536);
	if (len<=0) return;

	StringUpper(body);
	ptr = bigboy; match = 0;
	while (FetchLine(&ptr, linebuf, 508)>0){
		switch (0xFF&linebuf[0]){
		case '!':	// Begin With Word
			NoEndSpace(linebuf);
			StringUpper(linebuf);
			if (strstr (body, &linebuf[1])==body) match = 1;
			break;
		case '#':	// Contain The Word
			NoEndSpace(linebuf);
			StringUpper(linebuf);
			if (strstr (body, &linebuf[1])!=NULL) match = 1;
			break;
		}
		if (match){
			len = 0;
			while ((i = FetchLine(&ptr, &linebuf[len], 508-len))>0){
				if ((linebuf[len] == '!') || (linebuf[len] == '#') || (linebuf[len] == '?')) break;
				len += i;
				linebuf[len] = 0x0D;
				linebuf[len+1] = 0x0A; len+=2;
			} linebuf[len] = 0;
			ICQ_SendMessage (conn, sender, linebuf);
			break;
		}
	}
	if (!match){
		ptr = bigboy;
		while (FetchLine(&ptr, linebuf, 508)>0){
			if ((0xFF&linebuf[0])!='?') continue;
			len = 0;
			while ((i = FetchLine(&ptr, &linebuf[len], 508-len))>0){
				if ((linebuf[len] == '!') || (linebuf[len] == '#') || (linebuf[len] == '?')) break;
				len += i;
				linebuf[len] = 0x0D;
				linebuf[len+1] = 0x0A; len+=2;
			} linebuf[len] = 0;
			ICQ_SendMessage (conn, sender, linebuf);
			break;
		}
	}	
}
