#include <string.h>

char PacketBuffer[4096];

char	AckP[] = {
	0x02, 0x00,					// version
	0x0A, 0x00, 0x00, 0x00,		// ack
	0, 0, 0, 0					// UIN
};

char	AliveP[] = {
	0x02, 0x00,					// version
	0x2E, 0x04, 0x00, 0x00,		// Keep Alive
	0, 0, 0, 0					// UIN
};

char loginP00[] = {
	0x02, 0x00,					// version
	0xE8, 0x03,					// CMD
	0x01, 0x00,					// sequence #
	0, 0, 0, 0,					// UIN
	0x0A, 0x1A, 0x00, 0x00,		// port = 6666
	0, 0						// passwd length
};

char loginP01[]= {
	0x78, 0x00, 0x00, 0x00,		// unknown
	192, 168, 0, 1,				// local ip#
	0x04, 0x00, 0x00, 0x00,		// 0x01, 0x00 = invisible
	0x00,
	0x02, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x78, 0x00
};

char loginP11[] = {
	0x02, 0x00,					// version
	0x4C, 0x04, 0x02, 0x00,		// LOGIN1
	0, 0, 0, 0					// UIN
};
char loginP12[] = {
	0x02, 0x00,					// version
	0xF6, 0x04, 0x03, 0x00,
	0, 0, 0, 0,					// UIN
	0x00, 0x00, 0x00, 0x00
};
char loginP13[] = {
	0x02, 0x00,
	0xBA, 0x04, 0x05, 0x00,
	0, 0, 0, 0,					// UIN
	0, 0, 0, 0
};
char loginP14[] = {
	0x02, 0x00,					// version
	0x28, 0x05, 0x05, 0x00,		// LOGIN2
	0, 0, 0, 0,					// UIN
	0x01
};
char logoutP[] = {
	0x02, 0x00,					// version
	0x38, 0x04, 0x00, 0x00,		// CMD + SEQ
	0x00, 0x00, 0x00, 0x00,		// UIN
	0x14, 0x00, 'B', '_',
	'U', 'S', 'E', 'R', '_',
	'D', 'I', 'S', 'C', 'O', 'N', 'N', 'E', 'C', 'T', 'E', 'D',
	0x00, 0x05, 0x00
};
char	MessageP[] = {
	0x02, 0x00,						// version
	0x0E, 0x01,						// Message
	0x00, 0x00,						// sequence
	0, 0, 0, 0,						// Sender UIN
	0, 0, 0, 0,						// Receiver UIN
	0, 0,							// MsgType
	0, 0							// MsgLen
};

void GetUIN(char* buf, long uin){
	buf[0]=(char)(uin & 0xFF);
	buf[1]=(char)((uin >> 8) & 0xFF);
	buf[2]=(char)((uin >> 16) & 0xFF);
	buf[3]=(char)((uin >> 24) & 0xFF);
}

int	Packet_Ack(long uin){
   memcpy (PacketBuffer, AckP, 10);
   GetUIN(&PacketBuffer[6], uin);
   return 10;
}

int	Packet_KeepAlive(long uin){
   memcpy (PacketBuffer, AliveP, 10);
   GetUIN(&PacketBuffer[6], uin);
   return 10;
}

int Packet_LoginBegin (long uin, char* pass){
	int i;
	memcpy (PacketBuffer, loginP00, 16);
	GetUIN(&PacketBuffer[6], uin);
	i = strlen (pass)+1;
	PacketBuffer[14] = (char)(i&0xFF);
	PacketBuffer[15] = (char)(i>>8);
	memcpy (&PacketBuffer[16], pass, i);
	memcpy (&PacketBuffer[16+i], loginP01, 27);
	return 43+i;
}

int Packet_LoginEnd1 (long uin){
   memcpy (PacketBuffer, loginP11, 10);
   GetUIN(&PacketBuffer[6], uin);
   return 10;
}

int Packet_LoginEnd2 (long uin){
   memcpy (PacketBuffer, loginP12, 14);
   GetUIN(&PacketBuffer[6], uin);
   return 14;
}

int Packet_LoginEnd3 (long uin){
   memcpy (PacketBuffer, loginP13, 14);
   GetUIN(&PacketBuffer[6], uin);
   return 14;
}

int Packet_LoginEnd4 (long uin){
   memcpy (PacketBuffer, loginP14, 11);
   GetUIN(&PacketBuffer[6], uin);
   return 11;
}

int Packet_Logout(long uin){
   memcpy (PacketBuffer, logoutP, 34);
   GetUIN(&PacketBuffer[6], uin);
   return 34;
}

int Packet_Message(long SenderUIN, long ReceiverUIN, char *message){
	int len;
	len = strlen (message) + 1;
	memcpy (PacketBuffer, MessageP, 18);
	memcpy (&PacketBuffer[18], message, len);
	
	GetUIN(&PacketBuffer[6], SenderUIN);
	GetUIN(&PacketBuffer[10], ReceiverUIN);
	PacketBuffer[14] = 1;
	PacketBuffer[16] = (char)len;
	PacketBuffer[17] = (char)(len>>8);
	return len+18;
}
