#include "icq.h"
#include "sleep.h"

#include <stdio.h>
#include <signal.h>
#include <string.h>

// respond.c
void	DoRespond(ICQCONNECTION *conn, char *respondfile, int sender, int type, char *body);

char	*server_name = "icq.mirabilis.com";
int		server_port = 4000;
int		quiet = 0;
int		uid = 0;
char 	*pw = NULL;
char	*respond = "respond.txt";
char	pw_buf[16];
ICQCONNECTION *icq;

void	Welcome(void){
	printf ("ICQ Message Responder, by Calvin [http://i.am/devil]\r\n\n");
}

void	ParseParamenter(int argc, char *argv[]){
	int i, j=0;
	for (i=1; i<argc; i++){
		if (argv[i][0] == '/'){
			switch (argv[i][1]){
			case '?':
				printf ("USAGE: imr [/Sserver][/Pport][/Rrespondfile][/Q][icq#][passwd]\r\n"
						"   eg: imr /Sicq.mirabilie.com /P4000 /Rdefault.txt 123456 MYPASSWD\r\n");
				exit (0);			
			case 'S':
			case 's':
				server_name = strdup(&argv[i][2]); break;
			case 'p':
			case 'P':
				server_port = atoi(&argv[i][2]); break;
			case 'R':
			case 'r':
				respond = strdup(&argv[i][2]); break;
			case 'Q':
			case 'q':
				quiet = 1;
			}
		} else {
			if (j==0) uid =  atoi(argv[i]);
			else if (j==1) pw = strdup(argv[i]);
			j++;
		}
	}
	
	if (uid == 0){
		printf ("ICQ#: ");
		scanf ("%d", &uid);
	}
	if (pw == NULL){
		printf ("Password: ");
		scanf ("%10s", pw_buf);
		pw = pw_buf;
	}
}

void	BeforeQuit (void){
	ICQ_CloseConnection (icq);
#ifdef	_WIN32
	WSACleanup();
#endif
	exit(0);
}	


int main(int argc, char* argv[]){
	int msg, sender, type;
	char body[512];
#ifdef	_WIN32
	WSADATA wsaData;
	WSAStartup(MAKEWORD(1, 1), &wsaData);
#endif

	signal (SIGINT, (void(*)())BeforeQuit);
	
	Welcome();
	ParseParamenter(argc, argv);
	
	icq = ICQ_MakeConnection (server_name, server_port);
	if (!icq){
		printf ("Unable to make ICQ connection.\n"); return 0;
	}

	ICQ_SetLogin (icq, uid, pw);
	while ((msg=ICQ_GetMessage (icq))!=-1){
		if (msg==0xDC || msg == 0x104){	// ICQ Message
			if (ICQ_FetchMessage (&sender, &type, body, 512)>0){
				DoRespond (icq, respond, sender, type, body);
			}
		} usleep (250);
	}
	BeforeQuit(); return 0;
}