#include "icq.h"
#include "packet.h"

#include <stdio.h>
#include <stdlib.h>

extern int quiet;

int		ICQBUFFER_LEN;
char	ICQBUFFER[4096];

char *ICQ_GetCommandText(int cmd){
	switch (cmd){
	case	0xF0:
		return "Invalid Packet From Client";
	case	0x28:
		return "Server Replied An Error";
	case	0x0064:
		return "Wrong Password.";
	case	0x5A:
		return "Finalize Login";
	case 0x82:
		return "Internet Telephony / Games Info";
	case 0xE6:
		return "User Logon";
	case 0x6E:
		return "Friend Is Online";
	case	0x01A4:
		return "Friend Changed Status";
	case	0xDC:
	case	0x104:
		return "ICQ Mesage Arrival";
	case	0x0A:
		return "Ack";
	case	0x021C:
		return "Friend Goes Offline";
	case	0x01C2:
		return "Message From Server";
	case	0x03E8:
		return "Request To Login";
	case	0x044C:
		return "Finialize Login(1/4)";
	case	0x04F6:
		return "Finialize Login(2/4)";
	case	0x04BA:
		return "Finialize Login(3/4)";
	case	0x0528:
		return "Finialize Login(4/4)";
	case	0x042E:
		return "Keep Alive";
	case	0x010E:
		return "Outgoing Message";			
	default:
		return "";
	}
}

ICQCONNECTION* ICQ_MakeConnection (char*host, int port){
	ICQCONNECTION	*conn;
	int i;
	SOCKET fd;
	struct sockaddr addr;
	struct hostent	*hp;

	if ((hp = gethostbyname(host)) == NULL) return NULL;
	memcpy(&addr.sa_data[2], hp->h_addr, 4); //hp->h_length);

	addr.sa_family = AF_INET;
	addr.sa_data[0]= (char) (port>>8);
	addr.sa_data[1]= (char) (port&0xFF);
	fd = socket (PF_INET, SOCK_DGRAM, 0);
	if (connect (fd, &addr, sizeof(struct sockaddr))==-1){
		closesocket (fd); return NULL;
	}
	i=1; ioctlsocket (fd, FIONBIO, (unsigned long*)&i);
	conn = (ICQCONNECTION*)malloc(sizeof(ICQCONNECTION));
	conn->fd = fd;
	conn->uid = conn->seq = conn->logoned = 0;
	conn->alivetimer = time(NULL);
	return conn;
}


void	ICQ_CloseConnection (ICQCONNECTION *conn){
	int len;
	if (!conn) return;
	if (conn->logoned){
		len = Packet_Logout(conn->uid);
		send (conn->fd, PacketBuffer, len, 0);
	} closesocket (conn->fd);
	conn->fd = -1;
}


int		ICQ_SendPacket (ICQCONNECTION *conn, char*packet, int length){
	int type;
	if (!quiet){
		type = (0xFF&packet[2]) + ((0xFF&packet[3])<<8);
		if (type && !quiet) printf ("Send    : %04X : %s\n", type, ICQ_GetCommandText(type));
	} conn->seq++;
	packet[4] = (char)(conn->seq>>8);
	packet[5] = (char)(conn->seq);
	return send (conn->fd, packet, length, 0);
}


int		ICQ_GetMessage (ICQCONNECTION *conn){
	int type, len;
	time_t	thistime;
	thistime = time(NULL);
	if (thistime - conn->alivetimer >60){
		conn->alivetimer = thistime;
		len = Packet_KeepAlive(conn->uid);
		ICQ_SendPacket (conn, PacketBuffer, len);
	}		
	ICQBUFFER_LEN = recv ( conn->fd, ICQBUFFER, 4092, 0);
	if (ICQBUFFER_LEN<=0) return 0;
	type = (0xFF&ICQBUFFER[2]) + ((0xFF&ICQBUFFER[3])<<8);
	
	if (type && !quiet) printf ("Received: %04X : %s\n", type, ICQ_GetCommandText(type));
	
	switch (type){
	case	0xF0:	// Invalid Packet From Client
	case	0x28:	// Server Replied An Error
	case	0x64:	// Wrong Password
		return -1;
	case	0x5A:	// Finalize Login
		len = Packet_Ack(conn->uid);
		send (conn->fd, PacketBuffer, len, 0);
		len = Packet_LoginEnd1(conn->uid);
		ICQ_SendPacket (conn, PacketBuffer, len);
		len = Packet_LoginEnd2(conn->uid);
		ICQ_SendPacket (conn, PacketBuffer, len);
		len = Packet_LoginEnd3(conn->uid);
		ICQ_SendPacket (conn, PacketBuffer, len);
		len = Packet_LoginEnd4(conn->uid);
		ICQ_SendPacket (conn, PacketBuffer, len);
		break;
	case 0x82:		// Internet Telephony / Games Info (Induce successful login)
		if (conn->logoned) goto SendAck;
	case 0xE6:
		conn->logoned = 1;
		goto	SendAck;
	case 0x6E:		// Friend Is Online
		goto SendAck;
	case 0x01A4:	// Friend Changed Status
		len = Packet_Ack(conn->uid);
		PacketBuffer[4] = ICQBUFFER[4]; PacketBuffer[5] = ICQBUFFER[5];
		send (conn->fd, PacketBuffer, len, 0);
		len = Packet_Ack(conn->uid);
		ICQ_SendPacket (conn, PacketBuffer, len);
		break;
	case	0x0A:	// Server Ack Me
		break;
	case	0xDC:	// Old ICQ Message
		if (len<20) goto SendAck;
	case	0x104:	// New ICQ Message
		if (len<14) goto SendAck;
	case	0x021C:	// Friend Goes Offline
	case	0x78:	// Friend Goes Offline
	SendAck:
	default:
		len = Packet_Ack(conn->uid);
		PacketBuffer[4] = ICQBUFFER[4]; PacketBuffer[5] = ICQBUFFER[5];
		send (conn->fd, PacketBuffer, len, 0);
		break;
	}
	return type;
}


void	ICQ_SetLogin (ICQCONNECTION *conn, int uid, char *pw){
	int len;
	conn->uid = uid;
	len = Packet_LoginBegin (uid, pw);
	ICQ_SendPacket (conn, PacketBuffer, len);
}

int		ICQ_FetchMessage (int *sender, int *type, char *msg, int maxlen){
	int i, j, k, cmd;
	cmd = (0xFF&ICQBUFFER[2]) + ((0xFF&ICQBUFFER[3])<<8);
	if (cmd==0x104){ k=10; } else { k=16; }
	*sender = (0xFF&ICQBUFFER[6])      + ((0xFF&ICQBUFFER[7])<<8) +
			((0xFF&ICQBUFFER[8])<<16) + ((0xFF&ICQBUFFER[9])<<24);
	*type = (0xFF&ICQBUFFER[k]) + ((0xFF&ICQBUFFER[k+1])<<8);
	i = ((int)ICQBUFFER[k+2]&0xFF) + (((int)ICQBUFFER[k+3]&0xFF)<<8);
	k+=4;
	for (j=0; j<i; j++){
		if (j>=maxlen-1) break;
		if (j+k>=ICQBUFFER_LEN) break;
		msg[j] = ICQBUFFER[j+k];
	} msg[j] = 0;
	return j;
}

void	ICQ_SendMessage (ICQCONNECTION *conn, int target, char *body){
	int len = Packet_Message(conn->uid, target, body);
	ICQ_SendPacket (conn, PacketBuffer, len);
}


