#ifndef	__MY_ICQ_H__
#define	__MY_ICQ_H__

#include <time.h>
#include "network.h"

typedef struct	{
	SOCKET	fd;
	int		logoned;
	int		uid;
	int		seq;
	time_t	alivetimer;
} ICQCONNECTION;
	
char *ICQ_GetCommandText(int cmd);
ICQCONNECTION* ICQ_MakeConnection (char*host, int port);
void	ICQ_CloseConnection (ICQCONNECTION *conn);
int		ICQ_GetMessage (ICQCONNECTION *conn);
void	ICQ_SetLogin (ICQCONNECTION *conn, int uid, char *pw);
int		ICQ_FetchMessage (int *sender, int *type, char *msg, int maxlen);
void	ICQ_SendMessage (ICQCONNECTION *conn, int target, char *body);

#endif
