/*

    File: swap.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "types.h"
#include "common.h"
#include "swap.h"

int test_lin_swap(union swap_header *swap_header,t_diskext partition)
{
  if(memcmp(swap_header->magic.magic,"SWAP-SPACE",10)==0)
  {
    int i, j;
    for(i=PAGE_SIZE-10-1;i>=0;i--)
      if(swap_header->magic.reserved[i])
	break;
    for(j=7;j>=0;j--)
      if(swap_header->magic.reserved[i]&(1<<j))
	break;
    partition->part_size=(8*i+j+1)*(PAGE_SIZE/512);
    partition->part_type=P_LINSWAP;
    return 0;
  }
  else
  if(memcmp(swap_header->magic.magic,"SWAPSPACE2",10)==0)
  {
    partition->part_size=(swap_header->info.last_page - 1)*(PAGE_SIZE/512);
    partition->part_type=P_LINSWAP2;
    return 0;
  }
  return 1;
}
