/*

    File: fnctdsk.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#ifndef DJGPP
#include <sys/types.h>
#endif
#include <stdio.h>
#include "types.h"
#include "common.h"
#include "fnctdsk.h"
#include "lang.h"
#include "testdisk.h"
#include "hdaccess.h"
t_param_disk disk_car;
extern char* nom_os[256];
extern dword RS_offset;

/* BOOT */
dword NT_sect(t_sector_cst B)
{ return *((const dword*)&(B[0x28]));
}

byte NT_clustersize(t_sector_cst B)
{ return B[0x0D];
}

int bootable(t_entree_cst E)
{
  return E[0];
}

dword sect_rel(t_entree_cst E)
{ return *((const dword*)&(E[8]));
}

dword nbr_sect(t_entree_cst E)
{ return *((const dword*)&(E[12]));
}

dword CHS2SR(const word C, const byte H, const byte S)
{ return ((dword)C*(disk_car->head+1)+H)*disk_car->sector+S;
}

dword CHS2SRext(const uint C, const uint H, const uint S)
{ return ((dword)C*(disk_car->head+1)+H)*disk_car->sector+S;
}

dword get_SR(t_disk_cst pos)
{ return CHS2SR(pos->cylinder, pos->head, pos->sector);
}

dword get_SR_part(t_diskext_cst pos)
{ return CHS2SRext(pos->scylinder, pos->shead, pos->ssector);
}


dword get_LBA(t_disk_cst pos)
{ return get_SR(pos)-1;
}

dword get_LBA_part(t_diskext_cst pos)
{ return get_SR_part(pos)-1;
}

t_disk set_pos(t_disk pos, dword sect)
{
  pos->sector=(sect%disk_car->sector)+1;
  sect/=disk_car->sector;
  pos->head=sect%(disk_car->head+1);
  pos->cylinder=sect/(disk_car->head+1);
  return pos;
}

t_diskext set_posexts(t_diskext partition, dword sect)
{
  partition->ssector=(--sect%disk_car->sector)+1;
  sect/=disk_car->sector;
  partition->shead=sect%(disk_car->head+1);
  partition->scylinder=sect/(disk_car->head+1);
  return partition;
}

t_diskext set_posexte(t_diskext partition, dword sect)
{
  partition->esector=(--sect%disk_car->sector)+1;
  sect/=disk_car->sector;
  partition->ehead=sect%(disk_car->head+1);
  partition->ecylinder=sect/(disk_car->head+1);
  return partition;
}

dword get_sect_s(t_entree_cst E)
{ return CHS2SR(s_cyl(E),s_head(E),s_sect(E));
}

dword get_sect_e(t_entree_cst E)
{ return CHS2SR(e_cyl(E),e_head(E),e_sect(E));
}

t_disk  entree_s2pos(t_entree_cst E, t_disk_cst ref, t_disk pos)
{
  return set_pos(pos,debut_abs_entree(E,ref)); 
}

t_disk  entree_e2pos(t_entree_cst E, t_disk_cst ref, t_disk pos)
{
  return set_pos(pos,fin_abs_entree(E,ref));
}

void dup_t_diskext(t_diskext dest, t_diskext_cst src)
{
  dest->disk=src->disk;
  dest->scylinder=src->scylinder;
  dest->shead=src->shead;
  dest->ssector=src->ssector;
  dest->ecylinder=src->ecylinder;
  dest->ehead=src->ehead;
  dest->esector=src->esector;
  dest->part_type=src->part_type;
  dest->part_size=src->part_size;
  dest->status=src->status;
  dest->order=src->order;
}

void disk_apres(t_disk disk_pos)
{
  if (disk_pos->sector<disk_car->sector)
    disk_pos->sector++;
  else
    if (++disk_pos->head<disk_car->head)
    {
      disk_pos->sector=1;
    }
    else
      if (++disk_pos->cylinder<disk_car->cylinder)
      {
	disk_pos->head=0;
	disk_pos->sector=1;
      }
}

/*Check if no partition is over another*/
int test_over(t_entree_cst E1, t_entree_cst E2)
{
  dword s_E1, s_E2;
  s_E1=get_sect_s(E1);
  s_E2=get_sect_s(E2);
  if(s_E1>s_E2)
    return test_over(E2,E1);
  return (get_sect_e(E1)>=s_E2);
}

dword debut_abs_entree(t_entree_cst entree,t_disk_cst ref)
{
  if((os(entree)==P_EXTENDX)||(os(entree)==P_EXTENDED))
    return debut_rel_entree(entree)+RS_offset-1;
  else
    return debut_rel_entree(entree)+get_SR(ref)-1;
}
  
dword debut_rel_entree(t_entree_cst entree)
{
  return sect_rel(entree);
}

dword fin_rel_entree(t_entree_cst entree)
{
  return sect_rel(entree)+nbr_sect(entree)-1;
}

dword fin_abs_entree(t_entree_cst entree, t_disk_cst ref)
{
  return fin_rel_entree(entree)+get_LBA(ref);
}

void partition2entree(dword pos,t_diskext_cst partition, t_entree *entree)
{
  if(partition->status==STATUS_PRIM_BOOT)
    (*entree)[0]=0x80;
  else
    (*entree)[0]=0;             /* Non bootable */
  (*entree)[4]=partition->part_type;
  *((dword*)&((*entree)[8]))=get_SR_part(partition)-pos;
  if(partition->scylinder>1023)
  {
    (*entree)[1]=254;
    (*entree)[2]=63|((1023>>8)<<6);
    (*entree)[3]=(uchar)1023;
  }
  else
  {
    (*entree)[1]=partition->shead;
    (*entree)[2]=partition->ssector|((partition->scylinder>>8)<<6);
    (*entree)[3]=partition->scylinder;
  }
  if(partition->ecylinder>1023)
  {
    (*entree)[5]=254;
    (*entree)[6]=63|((1023>>8)<<6);
    (*entree)[7]=(uchar)1023;
  }
  else
  {
    (*entree)[5]=partition->ehead;
    (*entree)[6]=partition->esector|((partition->ecylinder>>8)<<6);
    (*entree)[7]=partition->ecylinder;
  }
  *((dword*)&((*entree)[12]))=partition->part_size;
}

int entree2partition(dword pos,t_diskext partition, t_entree_cst entree, int status)
{
  dword start_sect, end_sect;
  partition->disk=disk_car->disk;
  partition->part_type=os(entree);
  partition->sect_rel=sect_rel(entree);
  partition->order=0;
  switch(status)
  {
    case STATUS_PRIM:
      if(partition->part_type==P_EXTENDX || partition->part_type==P_EXTENDED)
	partition->status=STATUS_EXT;
      else
	if(bootable(entree))
	  partition->status=STATUS_PRIM_BOOT;
	else
	  partition->status=status;
      break;
    default:
      partition->status=status;
      break;
  }
  partition->ssector=s_sect(entree);
  if((partition->ssector==0)||(partition->ssector>disk_car->sector))
    return BAD_SS;
  partition->esector=e_sect(entree);
  if((partition->esector==0)||(partition->esector>disk_car->sector))
    return BAD_ES;
  partition->part_size=nbr_sect(entree);
  partition->scylinder=s_cyl(entree);
  partition->ecylinder=e_cyl(entree);
  if(partition->scylinder>partition->ecylinder)
    return BAD_EBS;
  if(partition->scylinder==partition->ecylinder)
  {
    if(partition->shead>partition->ehead)
      return BAD_EBS;
    if(partition->shead==partition->ehead)
      if(partition->ssector>partition->esector)
	return BAD_EBS;
  }
  switch(partition->part_type)
  {
    case P_EXTENDX:
    case P_EXTENDED:
      start_sect=RS_offset+partition->sect_rel;
      break;
    default:
      start_sect=pos+partition->sect_rel;
      break;
  }
  if(partition->scylinder<1023)
  {
    if((partition->shead=s_head(entree))>disk_car->head)
      return BAD_SH;
    if(start_sect!=get_sect_s(entree))
      return BAD_RS;
  }
  else  /* set CHS begin */
    set_posexts(partition,start_sect);
  if(partition->scylinder>disk_car->cylinder)
    return BAD_SC;
  end_sect=start_sect+partition->part_size-1;
  if(partition->ecylinder<1023)
  {
    if((partition->ehead=e_head(entree))>disk_car->head)
      return BAD_EH;
    if(end_sect!=get_sect_e(entree))
      return BAD_SCOUNT;
  }
  else  /* set CHS end */
    set_posexte(partition,end_sect);
  if(partition->ecylinder>disk_car->cylinder)
    return BAD_EC;
  return 0;
}

const char* errmsg_entree2partition(int errcode)
{
  switch(errcode)
  {
    case BAD_SS: return m_BAD_S_SECT;
    case BAD_ES: return m_BAD_E_SECT;
    case BAD_SH: return m_BAD_S_HEAD;
    case BAD_EH: return m_BAD_E_HEAD;
    case BAD_EBS: return m_END_BFR_START;
    case BAD_RS: return m_BAD_RS;
    case BAD_SC: return m_BAD_S_CYL;
    case BAD_EC: return m_BAD_E_CYL;
    case BAD_SCOUNT: return m_BAD_SCOUNT;
  }
  return "";
}

void aff_entree(t_entree_cst entree)
{
  if(nom_os[os(entree)])
    doprintf("\n %-28s ",nom_os[os(entree)]);
  else
    doprintf("\n Sys=%02X\t\t\t  ", os(entree));
  doprintf("%4u %3u %2u"
	 " %4u %3u %2u"
	 " %10lu"
	 " %10lu",
	  s_cyl(entree),s_head(entree),s_sect(entree),
	  e_cyl(entree),e_head(entree),e_sect(entree),
	  sect_rel(entree),nbr_sect(entree));
}

void aff_part_rapport(const int newline,t_diskext partition)
{
  switch(newline)
  {
    case 1: ecrit_rapport("\n   "); break;
    case 2: ecrit_rapport("%2d ", partition->order); break;
  }
  switch(partition->status)
  {
    case STATUS_PRIM:           ecrit_rapport("P"); break;
    case STATUS_PRIM_BOOT:      ecrit_rapport("*"); break;
    case STATUS_EXT:            ecrit_rapport("E"); break;
    case STATUS_EXT_IN_EXT:     ecrit_rapport("X"); break;
    case STATUS_LOG:            ecrit_rapport("L"); break;
    case STATUS_DELETED:        ecrit_rapport("D"); break;
  }
  if(nom_os[partition->part_type])
    ecrit_rapport(" %-28s ",nom_os[partition->part_type]);
  else
    ecrit_rapport(" Sys=%02X\t\t\t  ", partition->part_type);
  if(partition->sect_rel==0)
    ecrit_rapport("%4u %3u %2u %4u %3u %2u %10lu",
	  partition->scylinder,partition->shead,partition->ssector,
	  partition->ecylinder,partition->ehead,partition->esector,
	  partition->part_size);
  else
    ecrit_rapport("%4u %3u %2u %4u %3u %2u %10lu %10lu",
	  partition->scylinder,partition->shead,partition->ssector,
	  partition->ecylinder,partition->ehead,partition->esector,
	  partition->sect_rel,partition->part_size);
  fflush(stdout);
}

void aff_part(const int newline,t_diskext partition)
{
  switch(newline)
  {
    case 1: doprintf("\n   "); break;
    case 2: doprintf("%2d ", partition->order); break;
  }
  switch(partition->status)
  {
    case STATUS_PRIM:           doprintf("P"); break;
    case STATUS_PRIM_BOOT:      doprintf("*"); break;
    case STATUS_EXT:            doprintf("E"); break;
    case STATUS_EXT_IN_EXT:     doprintf("X"); break;
    case STATUS_LOG:            doprintf("L"); break;
    case STATUS_DELETED:        doprintf("D"); break;
  }
  if(nom_os[partition->part_type])
    doprintf(" %-28s ",nom_os[partition->part_type]);
  else
    doprintf(" Sys=%02X\t\t\t  ", partition->part_type);
  if(partition->sect_rel==0)
    doprintf("%4u %3u %2u %4u %3u %2u %10lu",
	  partition->scylinder,partition->shead,partition->ssector,
	  partition->ecylinder,partition->ehead,partition->esector,
	  partition->part_size);
  else
    doprintf("%4u %3u %2u %4u %3u %2u %10lu %10lu",
	  partition->scylinder,partition->shead,partition->ssector,
	  partition->ecylinder,partition->ehead,partition->esector,
	  partition->sect_rel,partition->part_size);
  fflush(stdout);
}

int read_MBR(void *buffer)
{
  t_disk pos=(t_disk)MALLOC(sizeof(*pos));
  pos->disk=disk_car->disk;
  pos->cylinder=0;
  pos->head=0;
  pos->sector=1;
  if(hd_read(1, buffer, pos))
  {
    doprintf(m_PART_RD_ERR);
    FREE(pos);
    return 1;
  }
  FREE(pos);
  return 0;
}

int read_ext(void *buffer, const t_diskext partition )
{
  if(hd_read2(1, buffer, partition))
  {
    doprintf(m_PART_RD_ERR);
    return 1;
  }
  return 0;
}

int write_MBR(void *buffer)
{
  t_disk pos=(t_disk)MALLOC(sizeof(*pos));
  pos->disk=disk_car->disk;
  pos->cylinder=0;
  pos->head=0;
  pos->sector=1;
  if(hd_write(1, buffer, pos))
  {
    doprintf(m_PART_WR_ERR);
    FREE(pos);
    return 1;
  }
  FREE(pos);
  return 0;
}

int write_ext(void *buffer, const t_diskext partition )
{
  if(hd_write2(1, buffer, partition))
  {
    doprintf(m_PART_WR_ERR);
    return 1;
  }
  return 0;
}

void dump(const uchar *nom_dump,uint lng)
{
  uint i,j;
  uchar car;
  doprintf(m_DUMP_HEXA);
  j=0;
  for (i=0; i<lng/0x10; i++)
  {
	for(j=0; j< 0x10;j++)
	{
	  car=*(nom_dump+i*0x10+j);
	  doprintf("%02x", car);
	  if(j%4==(4-1))
		doprintf(" ");
	}
	doprintf("  ");
	for(j=0; j< 0x10;j++)
	{
	  car=*(nom_dump+i*0x10+j);
	  if ((car<30)||(car > 127))
		doprintf(" ");
	  else
		doprintf("%c",  car);
	}
	doprintf("\n");
  }
  fflush(stdout);
  read_key();
}
#ifdef DUMP
#endif

void aff_LBA2CHS(dword pos_LBA)
{
  dword tmp;
  dword cylinder, head, sector;
  tmp=disk_car->sector;
  sector=(pos_LBA%tmp)+1;
  tmp=pos_LBA/tmp;
  cylinder=tmp/(disk_car->head+1);
  head=tmp%(disk_car->head+1);
  doprintf("%d/%d/%d", cylinder,head,sector);
}
