/*

    File: fat.h

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef FAT_H
#define FAT_H
#define FAT_NAME1       0x36
#define FAT_NAME2       0x52    /* FAT32 only */
#define NTFS_NAME       0x03
#define OS2_NAME        0x03

#define NBR_SECT        8

/*
 * FAT partition boot sector information, taken from the Linux
 * kernel sources.
 */

struct fat_boot_sector {
	__u8	ignored[3];	/* Boot strap short or near jump */
	__s8	system_id[8];	/* Name - can be used to special case
				   partition manager volumes */
	__u8	sector_size[2];	/* bytes per logical sector */
	__u8	cluster_size;	/* sectors/cluster */
	__u16	reserved;	/* reserved sectors */
	__u8	fats;		/* number of FATs */
	__u8	dir_entries[2];	/* root directory entries */
	__u8	sectors[2];	/* number of sectors */
	__u8	media;		/* 0x15 media code (unused) */
	__u16	fat_length;	/* 0x16 sectors/FAT */
	__u16	secs_track;	/* 0x18 sectors per track */
	__u16	heads;		/* 0x1A number of heads */
	__u32	hidden;		/* 0x1C hidden sectors (unused) */
	__u32	total_sect;	/* 0x20 number of sectors (if sectors == 0) */

	/* The following fields are only used by FAT32 */
	__u32	fat32_length;	/* 0x24 sectors/FAT */
	__u16	flags;		/* bit 8: fat mirroring, low 4: active fat */
	__u8	version[2];	/* major, minor filesystem version */
	__u32	root_cluster;	/* first cluster in root directory */
	__u16	info_sector;	/* filesystem info sector */
	__u16	backup_boot;	/* backup boot sector */
	__u16	reserved2[6];	/* Unused */
	/* */
	__u8	nothing[446];
	__u16	marker;
};
int check_FAT(t_diskext partition, int debug);
//int check_FAT_aux(t_sector_cst *buffer, t_diskext partition);
int check_FAT_aux(struct fat_boot_sector *, t_diskext, int debug );
int comp_FAT(t_diskext, dword, const dword);
//int analyse_FAT(const uchar buffer[0x200], dword * part_size,int);
int analyse_FAT(struct fat_boot_sector*fat_header, t_diskext partition,int debug,int dump_ind);
int recover_FAT(t_diskext partition,int debug);
int search_fat16(t_diskext_cst partition,dword max_offset,int p_fat12,int p_fat16,int p_fat32,int debug,int dump_ind);
int get_frag(uchar *buffer,int fat_type);
int create_boot_sector(int part_type,t_diskext_cst partition, int reserved, int debug,int dir_entries,dword root_cluster,int cluster_size,int fat_length);
int dump_fat(const struct fat_boot_sector*fat_header, int part_type);
int dump_2fat(const struct fat_boot_sector*fh1, const struct fat_boot_sector*fh2, int part_type);
int calcul_cluster_size(int part_type,dword data_size,int fat_length);
int get_part_type(int f_fat12,int f_fat16,int f_fat32);
int sort_fat(int pos_fat_test, int debug);
int search_fat_aux(t_diskext_cst partition,dword max_offset,int p_fat12,int p_fat16,int p_fat32,int *f_fat12,int*f_fat16,int*f_fat32,int debug,int dump_ind);
int select_fat(int pos_fat_test, int part_type, int f_fat12, int f_fat16, int f_fat32, int debug);
int set_fat_offset(int*reserved, int*fat_length, t_diskext_cst partition,dword max_offset,int p_fat12,int p_fat16,int p_fat32,int debug,int dump_ind);
int check_entree(uchar *entree);
int analyse_dir_entries(t_diskext_cst partition, int offset);
int get_root_cluster(t_diskext_cst partition,const int cluster_size, const dword no_of_cluster, const int offset);
dword get_subdirectory(t_disk_cst pos_disk,dword i);
dword get_next_cluster(t_diskext_cst partition, int part_type,const int offset, dword cluster);
#endif
