/*

    File: bfs.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "types.h"
#include "common.h"
#include "bfs.h"

int test_beos(struct disk_super_block *beos_block,t_diskext partition)
{
  if((beos_block->magic1==SUPER_BLOCK_MAGIC1)
     && (beos_block->magic2==(signed)SUPER_BLOCK_MAGIC2)
     && (beos_block->magic3==SUPER_BLOCK_MAGIC3))
  {
    partition->part_size=beos_block->num_blocks*((1<<beos_block->block_shift)/512);
    partition->part_type=P_BEOS;
    return 0;
  }
  return 1;
}
