/*

    File: testdisk.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <curses.h>
#include <time.h>
//#include <string.h>
#include <ctype.h>      /* toupper, tolower */
#include "types.h"
#include "common.h"
#include "testdisk.h"
#include "godmode.h"
#include "lang.h"
#include "fnctdsk.h"

#define LINE_LENGTH     80
int curses=0;
int search_mode=0;
int fast_mode=1;
extern t_param_disk disk_car;
extern t_diskext tab_part[NBR_PART_MAX];
enum {clearMBR_none,clearMBR_clean, clearMBR_mbr};
FILE *f_rapport=NULL;
char    *line_ptr,                      /* interactive input */
	line_buffer[LINE_LENGTH];

int ecrit_rapport(const char *_format, ...)
{
#ifdef DEBUG
  if(f_rapport)
#else
  if(f_rapport && !curses)
#endif
    return vfprintf(f_rapport,_format,(&_format)+1);
  return 0;
}

int doprintf(const char *_format, ...)
{
#ifdef DEBUG
  if(f_rapport)
#else
  if(f_rapport && !curses)
#endif
    vfprintf(f_rapport,_format,(&_format)+1);
  if(curses)
  {
    char res[800];
#ifdef DJGPP
    vsprintf(res,_format,(&_format)+1);
#else
    vsnprintf(res,sizeof(res),_format,(&_format)+1);
#endif
    return addstr(res);
  }
  else
    return vprintf(_format,(&_format)+1);
}

int read_line(void)
{
	if (!fgets(line_buffer, LINE_LENGTH, stdin))
		return 0;
	line_ptr = line_buffer;
	while (*line_ptr && !isgraph(*line_ptr))
		line_ptr++;
	return *line_ptr;
}

char read_char(const char *mesg)
{
	do
		fputs(mesg, stdout);
	while (!read_line());
	return *line_ptr;
}

int ask_YN(const char* msg)
{
  char res;
  doprintf(msg);
  fflush(stdout);
  do
  {
    res=read_key();
  } while((res!=c_NO)&(res!=c_YES));
#ifdef DJGPP
  doprintf("%c\n",res);
#else
  doprintf("\n%c\n",res); /* curses problem */
#endif
  return (res==c_YES);
}

FILE* init_log(const char*filename,int argc, char**argv)
{
  FILE*f_file=fopen(filename,"a");
  if(f_file==NULL)
	printf(m_LOG_ERR);
  else
  {
	int i;
	time_t my_time=time(NULL);
	fprintf(f_file,m_CMDLINE);
	for(i=1;i<argc;i++)
	  fprintf(f_file," %s", argv[i]);
	fprintf(f_file,"\n%s",ctime(&my_time));
  }
  return f_file;
}
	       
int main( int argc, char **argv )
{
  int i;
  unsigned int x;
  int trustBIOS=TRUST_NO, help=0, create_log=0,clearMBR=clearMBR_none,paranoid=0,debug=0, dump_ind=0,geometry_ind=0;
  /*
  doprintf("%d\n",up2power(1));
  doprintf("%d\n",up2power(2));
  doprintf("%d\n",up2power(3));
  doprintf("%d\n",up2power(4));
  doprintf("%d\n",up2power(5));
  doprintf("%d\n",up2power(6));
  return 0;
  */
  for(i=1;i<argc;i++)
  {
    for (x=0; x < strlen( argv[i] ); x++)
     argv[i][x] = tolower( argv[i][x] );
    if (!strcmp(argv[i],"/trust"))
      trustBIOS=TRUST_YES;
    else if (!strcmp(argv[i],"/liar"))
      trustBIOS=TRUST_NO;
    else if (!strcmp(argv[i],"/trust_auto"))
      trustBIOS=TRUST_AUTO;
    else if (!strcmp(argv[i],"/search"))
      search_mode=1;
    else if (!strcmp(argv[i],"/fast"))
      fast_mode=1;
    else if (!strcmp(argv[i],"/slow"))
      fast_mode=0;
    else if(!strcmp(argv[i],"/log"))
      create_log=1;
    else if(!strcmp(argv[i],"/mbr"))
      clearMBR=clearMBR_mbr;
    else if(!strcmp(argv[i],"/clean"))
      clearMBR=clearMBR_clean;
    else if(!strcmp(argv[i],"/paranoid"))
      paranoid=1;
    else if(!strcmp(argv[i],"/debug"))
      debug=1;
	else if(!strcmp(argv[i],"/dump"))
	  dump_ind=1;
	else if(!strcmp(argv[i],"/geometry"))
	  geometry_ind=1;
    else
      help=1;
  }
  if(!help && create_log)
    f_rapport=init_log("testdisk.log",argc,argv);
  doprintf("\nTestDisk 2.2, Data Recovery Utility by Christophe GRENIER, May 30 2000"
	 "\ngrenier@nef.esiea.fr"
	 "\nhttp://www.esiea.fr/public_html/Christophe.GRENIER/"
	 "\n");
  if(help)
  {
    doprintf("\nUsage: TestDisk [/liar] [/paranoid] [/log] [/debug] [/dump]"
		     "\n       TestDisk [/mbr] [/clean]"
	    "\n"
	    "\n/liar         : don't trust hard disk geometry given by BIOS"
	    "\n                BIOS usualy hide last cylinder"
	    "\n/search       : search in partition"
	    "\n[/fast|/slow] : fast(default) or slow partition recovery mode"
	    "\n/paranoid     : scan each cylinder"
	    "\n/log          : create a testdisk.log file"
	    "\n"
	    "\nTestDisk checks and recovers lost partitions"
	    "\nIt works with :"
	    "\n- FAT12, FAT16 <32M, FAT16 >32M, FAT32"
	    "\n- extended partition"
	    "\n- NTFS"
	    "\n- LINUX ext2fs, LINUX swap"
	    "\n- OS/2 MultiBoot (used in PartitionMagic)"
	    "\n"
	    "\nIf you have problems with TestDisk or bug reports, please contacte me.\n");
    return 0;
  }
  {
	disk_car=(t_disk)MALLOC(sizeof(*disk_car));
	for(i=0;i<NBR_PART_MAX;i++)
	  tab_part[i]=(t_diskext)MALLOC(sizeof(struct cellule_diskext));
	for(disk_car->disk=0x80;disk_car->disk<0x84;disk_car->disk++)
	{
	  if(!hd_identify(disk_car))
	  {
#ifdef __DJGPP__
	    if(trustBIOS==TRUST_NO|| (trustBIOS==TRUST_AUTO && disk_car->cylinder>=1024))
	      disk_car->cylinder++;
#else
	    if(trustBIOS==TRUST_YES || (trustBIOS==TRUST_AUTO && disk_car->cylinder<1024))
	      disk_car->cylinder--;
#endif
		if(geometry_ind)
		{
		}
	    switch(clearMBR)
	    {
	      case clearMBR_clean:
		write_clean_table();
		break;
	      case clearMBR_mbr:
		write_MBR_code();
		break;
	      case clearMBR_none:
		if(disk_car->disk>0x80)
		{
		  doprintf(m_PRESS_KEY);
		  fflush(stdout);
		  read_key();
		}
		doprintf("\n\n=====> " m_DRIVE " %02x - CHS %d %d %d - %d MB <=====",
		    disk_car->disk, disk_car->cylinder+1, disk_car->head+1, disk_car->sector,(disk_car->cylinder+1)*(disk_car->head+1)*disk_car->sector/2/1024);
                if(disk_car->cylinder+1==16384 && disk_car->head+1==16 && disk_car->sector==63)
                  doprintf(m_WARN_LBA);
		fflush(stdout);
		i=test_MBR(debug);
		doprintf(m_PRESS_KEY);
		fflush(stdout);
		read_key();
		god_mode(paranoid,debug, dump_ind);
		break;
	    }
	  }
	}
	if(debug)
	{
	  doprintf("\nmain: free the memory");
	  fflush(stdout);
	}
	for(i=0;i<NBR_PART_MAX;i++)
	  FREE(tab_part[i]);
	FREE(disk_car);
  }
#ifndef DJGPP
  doprintf("\n");
#endif
  if(f_rapport)
	fclose(f_rapport);
  return 0;
}
